/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.tsp.grid;

import internal.toolkit.base.tsp.grid.InternalValueReader;
import internal.toolkit.base.tsp.grid.MarkableStream;
import internal.toolkit.base.tsp.grid.TsDataBuilders;
import java.io.Closeable;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import jdplus.toolkit.base.api.timeseries.Ts;
import jdplus.toolkit.base.api.timeseries.TsCollection;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsInformationType;
import jdplus.toolkit.base.api.timeseries.util.ObsCharacteristics;
import jdplus.toolkit.base.api.timeseries.util.ObsGathering;
import jdplus.toolkit.base.api.timeseries.util.TsDataBuilder;
import jdplus.toolkit.base.tsp.fixme.Substitutor;
import jdplus.toolkit.base.tsp.grid.GridDataType;
import jdplus.toolkit.base.tsp.grid.GridInput;
import jdplus.toolkit.base.tsp.grid.GridLayout;
import jdplus.toolkit.base.tsp.grid.GridWriter;
import jdplus.toolkit.base.tsp.util.ObsFormat;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class GridReader {
    public static final GridReader DEFAULT = GridReader.builder().build();
    @NonNull
    private final ObsFormat format;
    @NonNull
    private final ObsGathering gathering;
    @NonNull
    private final GridLayout layout;
    @NonNull
    private final String namePattern;
    @NonNull
    private final String nameSeparator;
    private static final String NULL_NAME = null;

    public static Builder builder() {
        return new Builder().format(ObsFormat.DEFAULT).gathering(ObsGathering.DEFAULT).layout(GridLayout.UNDEFINED).namePattern("S${index}").nameSeparator("\n");
    }

    @NonNull
    public TsCollection read(@NonNull GridInput input) throws IOException {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        TsCollection.Builder output = TsCollection.builder().type(TsInformationType.Data).name(input.getName());
        try (TypedInputStream stream = TypedInputStream.of(input.getDataTypes(), this.format, input.open());){
            if (this.isSeriesByRow(stream)) {
                this.readSeriesByRow(stream, output);
            } else {
                this.readPeriodByRow(stream, output);
            }
        }
        return output.build();
    }

    private boolean isSeriesByRow(TypedInputStream stream) throws IOException {
        return this.layout.equals((Object)GridLayout.HORIZONTAL) || GridReader.peekSeriesByRow(stream);
    }

    private void readSeriesByRow(TypedInputStream input, TsCollection.Builder output) throws IOException {
        output.meta("gridLayout", GridLayout.HORIZONTAL.name());
        SeriesByRowHead head = SeriesByRowHead.peek(input);
        TypedInputStreamFunc<String> names = head.getNameFunc(this.namePattern, this.nameSeparator);
        TsDataBuilder data = TsDataBuilder.byDateTime((ObsGathering)this.gathering, (ObsCharacteristics[])new ObsCharacteristics[0]);
        head.skip(input);
        while (input.readRow()) {
            String nullableName = names.apply(input);
            for (int col = 0; col < head.columns && input.readCell(); ++col) {
                data.add((Object)head.getPeriod(col), input.getNumber());
            }
            TsData result = data.build();
            if (GridReader.isNotVoid(nullableName, result)) {
                output.item(Ts.builder().type(TsInformationType.Data).name(GridReader.fixNullName(nullableName)).data(result).build());
            }
            data.clear();
        }
    }

    private void readPeriodByRow(TypedInputStream input, TsCollection.Builder output) throws IOException {
        output.meta("gridLayout", GridLayout.VERTICAL.name());
        PeriodByRowHead head = PeriodByRowHead.peek(input);
        TsDataBuilders<LocalDateTime> data = TsDataBuilders.byDateTime(head.columns, this.gathering, new ObsCharacteristics[0]);
        head.skip(input);
        while (input.readRow()) {
            LocalDateTime period;
            if (!input.readCell() || (period = input.getDateTime()) == null) continue;
            for (int col = 0; col < head.columns && input.readCell(); ++col) {
                data.add(col, period, input.getNumber());
            }
        }
        List<String> names = head.getNames(this.namePattern, this.nameSeparator);
        for (int column = 0; column < head.columns; ++column) {
            TsData result;
            String nullableName = names.get(column);
            if (!GridReader.isNotVoid(nullableName, result = data.build(column))) continue;
            output.item(Ts.builder().type(TsInformationType.Data).name(GridReader.fixNullName(nullableName)).data(result).build());
        }
    }

    private static String joinSkippingNulls(String[] items, Collector<CharSequence, ?, String> nameJoiner) {
        return Stream.of(items).filter(Objects::nonNull).collect(nameJoiner);
    }

    private static boolean peekSeriesByRow(TypedInputStream typedStream) throws IOException {
        typedStream.mark();
        try {
            if (typedStream.readRow() && typedStream.readCell()) {
                while (typedStream.readCell()) {
                    if (typedStream.getDateTime() == null) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            typedStream.reset();
        }
    }

    private static <T> List<T> readCells(TypedInputStream stream, TypedInputStreamFunc<T> func) throws IOException {
        ArrayList<T> result = new ArrayList<T>();
        while (stream.readCell()) {
            result.add(func.apply(stream));
        }
        return result;
    }

    private static Supplier<String> getNameGenerator(String namePattern) {
        AtomicInteger index = new AtomicInteger(-1);
        Substitutor substitutor = GridReader.getIndexSubstitutor(index);
        return () -> {
            index.incrementAndGet();
            return substitutor.replace(namePattern);
        };
    }

    private static Substitutor getIndexSubstitutor(AtomicInteger counter) {
        return Substitutor.of(key -> {
            switch (key) {
                case "index": {
                    return counter.get();
                }
                case "number": {
                    return counter.get() + 1;
                }
            }
            return null;
        });
    }

    private static boolean isNotVoid(String nullableName, TsData result) {
        return nullableName != null || !result.isEmpty();
    }

    private static String fixNullName(String name) {
        return name != null ? name : "null";
    }

    @Generated
    GridReader(@NonNull ObsFormat format, @NonNull ObsGathering gathering, @NonNull GridLayout layout, @NonNull String namePattern, @NonNull String nameSeparator) {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        if (gathering == null) {
            throw new NullPointerException("gathering is marked non-null but is null");
        }
        if (layout == null) {
            throw new NullPointerException("layout is marked non-null but is null");
        }
        if (namePattern == null) {
            throw new NullPointerException("namePattern is marked non-null but is null");
        }
        if (nameSeparator == null) {
            throw new NullPointerException("nameSeparator is marked non-null but is null");
        }
        this.format = format;
        this.gathering = gathering;
        this.layout = layout;
        this.namePattern = namePattern;
        this.nameSeparator = nameSeparator;
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        return new Builder().format(this.format).gathering(this.gathering).layout(this.layout).namePattern(this.namePattern).nameSeparator(this.nameSeparator);
    }

    @NonNull
    @Generated
    public ObsFormat getFormat() {
        return this.format;
    }

    @NonNull
    @Generated
    public ObsGathering getGathering() {
        return this.gathering;
    }

    @NonNull
    @Generated
    public GridLayout getLayout() {
        return this.layout;
    }

    @NonNull
    @Generated
    public String getNamePattern() {
        return this.namePattern;
    }

    @NonNull
    @Generated
    public String getNameSeparator() {
        return this.nameSeparator;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GridReader)) {
            return false;
        }
        GridReader other = (GridReader)o;
        ObsFormat this$format = this.getFormat();
        ObsFormat other$format = other.getFormat();
        if (this$format == null ? other$format != null : !((Object)this$format).equals(other$format)) {
            return false;
        }
        ObsGathering this$gathering = this.getGathering();
        ObsGathering other$gathering = other.getGathering();
        if (this$gathering == null ? other$gathering != null : !this$gathering.equals(other$gathering)) {
            return false;
        }
        GridLayout this$layout = this.getLayout();
        GridLayout other$layout = other.getLayout();
        if (this$layout == null ? other$layout != null : !((Object)((Object)this$layout)).equals((Object)other$layout)) {
            return false;
        }
        String this$namePattern = this.getNamePattern();
        String other$namePattern = other.getNamePattern();
        if (this$namePattern == null ? other$namePattern != null : !this$namePattern.equals(other$namePattern)) {
            return false;
        }
        String this$nameSeparator = this.getNameSeparator();
        String other$nameSeparator = other.getNameSeparator();
        return !(this$nameSeparator == null ? other$nameSeparator != null : !this$nameSeparator.equals(other$nameSeparator));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ObsFormat $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : ((Object)$format).hashCode());
        ObsGathering $gathering = this.getGathering();
        result = result * 59 + ($gathering == null ? 43 : $gathering.hashCode());
        GridLayout $layout = this.getLayout();
        result = result * 59 + ($layout == null ? 43 : ((Object)((Object)$layout)).hashCode());
        String $namePattern = this.getNamePattern();
        result = result * 59 + ($namePattern == null ? 43 : $namePattern.hashCode());
        String $nameSeparator = this.getNameSeparator();
        result = result * 59 + ($nameSeparator == null ? 43 : $nameSeparator.hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "GridReader(format=" + String.valueOf(this.getFormat()) + ", gathering=" + String.valueOf(this.getGathering()) + ", layout=" + String.valueOf((Object)this.getLayout()) + ", namePattern=" + this.getNamePattern() + ", nameSeparator=" + this.getNameSeparator() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private ObsFormat format;
        @Generated
        private ObsGathering gathering;
        @Generated
        private GridLayout layout;
        @Generated
        private String namePattern;
        @Generated
        private String nameSeparator;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder format(@NonNull ObsFormat format) {
            if (format == null) {
                throw new NullPointerException("format is marked non-null but is null");
            }
            this.format = format;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder gathering(@NonNull ObsGathering gathering) {
            if (gathering == null) {
                throw new NullPointerException("gathering is marked non-null but is null");
            }
            this.gathering = gathering;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder layout(@NonNull GridLayout layout) {
            if (layout == null) {
                throw new NullPointerException("layout is marked non-null but is null");
            }
            this.layout = layout;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder namePattern(@NonNull String namePattern) {
            if (namePattern == null) {
                throw new NullPointerException("namePattern is marked non-null but is null");
            }
            this.namePattern = namePattern;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder nameSeparator(@NonNull String nameSeparator) {
            if (nameSeparator == null) {
                throw new NullPointerException("nameSeparator is marked non-null but is null");
            }
            this.nameSeparator = nameSeparator;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull GridReader build() {
            return new GridReader(this.format, this.gathering, this.layout, this.namePattern, this.nameSeparator);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "GridReader.Builder(format=" + String.valueOf(this.format) + ", gathering=" + String.valueOf(this.gathering) + ", layout=" + String.valueOf((Object)this.layout) + ", namePattern=" + this.namePattern + ", nameSeparator=" + this.nameSeparator + ")";
        }
    }

    private static final class TypedInputStream
    implements Closeable {
        @NonNull
        private final InternalValueReader<String> string;
        @NonNull
        private final InternalValueReader<LocalDateTime> dateTime;
        @NonNull
        private final InternalValueReader<Number> number;
        @NonNull
        private final MarkableStream delegate;

        static TypedInputStream of(Set<GridDataType> dataTypes, ObsFormat format, GridInput.Stream stream) {
            InternalValueReader<Number> numberFallback;
            InternalValueReader<LocalDateTime> dateTimeFallback;
            InternalValueReader<String> string;
            if (dataTypes.contains((Object)GridDataType.STRING)) {
                string = InternalValueReader.onString();
                dateTimeFallback = InternalValueReader.onStringParser(arg_0 -> format.dateTimeParser().parse(arg_0));
                numberFallback = InternalValueReader.onStringParser(arg_0 -> format.numberParser().parse(arg_0));
            } else {
                string = InternalValueReader.onNull();
                dateTimeFallback = InternalValueReader.onNull();
                numberFallback = InternalValueReader.onNull();
            }
            InternalValueReader<LocalDateTime> dateTime = dataTypes.contains((Object)GridDataType.LOCAL_DATE_TIME) ? InternalValueReader.onDateTime().or(dateTimeFallback) : dateTimeFallback;
            InternalValueReader<Number> number = dataTypes.contains((Object)GridDataType.DOUBLE) ? InternalValueReader.onNumber().or(numberFallback) : numberFallback;
            return new TypedInputStream(string, dateTime, number, new MarkableStream(stream));
        }

        public @Nullable Number getNumber() throws IOException {
            return this.number.read(this.delegate.getCell());
        }

        public @Nullable LocalDateTime getDateTime() throws IOException {
            return this.dateTime.read(this.delegate.getCell());
        }

        public @Nullable String getString() throws IOException {
            return this.string.read(this.delegate.getCell());
        }

        @Generated
        private TypedInputStream(@NonNull InternalValueReader<String> string, @NonNull InternalValueReader<LocalDateTime> dateTime, @NonNull InternalValueReader<Number> number, @NonNull MarkableStream delegate) {
            if (string == null) {
                throw new NullPointerException("string is marked non-null but is null");
            }
            if (dateTime == null) {
                throw new NullPointerException("dateTime is marked non-null but is null");
            }
            if (number == null) {
                throw new NullPointerException("number is marked non-null but is null");
            }
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            this.string = string;
            this.dateTime = dateTime;
            this.number = number;
            this.delegate = delegate;
        }

        @Generated
        public void mark() {
            this.delegate.mark();
        }

        @Generated
        public void reset() {
            this.delegate.reset();
        }

        @Generated
        public boolean readRow() throws IOException {
            return this.delegate.readRow();
        }

        @Generated
        public boolean readCell() throws IOException {
            return this.delegate.readCell();
        }

        @Generated
        public Object getCell() throws IOException {
            return this.delegate.getCell();
        }

        @Override
        @Generated
        public void close() throws IOException {
            this.delegate.close();
        }
    }

    private static final class SeriesByRowHead {
        private final int firstObsIndex;
        private final int columns;
        private final List<LocalDateTime> dates;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static SeriesByRowHead peek(TypedInputStream stream) throws IOException {
            stream.mark();
            try {
                List<LocalDateTime> dates = stream.readRow() ? GridReader.readCells(stream, TypedInputStream::getDateTime) : Collections.emptyList();
                int firstObsIndex = SeriesByRowHead.getFirstObsIndex(dates);
                dates = dates.subList(firstObsIndex, SeriesByRowHead.getLastObsIndex(dates) + 1);
                SeriesByRowHead seriesByRowHead = new SeriesByRowHead(firstObsIndex, dates.size(), dates);
                return seriesByRowHead;
            }
            finally {
                stream.reset();
            }
        }

        private static int getFirstObsIndex(List<LocalDateTime> dates) {
            return IntStream.range(0, dates.size()).filter(i -> dates.get(i) != null).findFirst().orElse(0);
        }

        private static int getLastObsIndex(List<LocalDateTime> dates) {
            return GridWriter.reverseRange(0, dates.size()).filter(i -> dates.get(i) != null).findFirst().orElse(0);
        }

        void skip(TypedInputStream stream) throws IOException {
            stream.readRow();
        }

        LocalDateTime getPeriod(int column) {
            return this.dates.get(column);
        }

        TypedInputStreamFunc<String> getNameFunc(String namePattern, String nameSeparator) {
            switch (this.firstObsIndex) {
                case 0: {
                    Supplier<String> nameGenerator = GridReader.getNameGenerator(namePattern);
                    return stream -> (String)nameGenerator.get();
                }
                case 1: {
                    return stream -> stream.readCell() ? stream.getString() : NULL_NAME;
                }
            }
            Collector<CharSequence, ?, String> nameJoiner = Collectors.joining(nameSeparator);
            String[] path = new String[this.firstObsIndex];
            return stream -> {
                boolean hasHeader = false;
                for (int index = 0; index < path.length && stream.readCell(); ++index) {
                    String name = stream.getString();
                    if (name != null) {
                        hasHeader = true;
                        path[index] = name;
                        continue;
                    }
                    if (!hasHeader) continue;
                    path[index] = null;
                }
                return !hasHeader ? NULL_NAME : GridReader.joinSkippingNulls(path, nameJoiner);
            };
        }

        @Generated
        public SeriesByRowHead(int firstObsIndex, int columns, List<LocalDateTime> dates) {
            this.firstObsIndex = firstObsIndex;
            this.columns = columns;
            this.dates = dates;
        }
    }

    private static interface TypedInputStreamFunc<T> {
        public T apply(TypedInputStream var1) throws IOException;
    }

    private static final class PeriodByRowHead {
        private final int rows;
        private final int columns;
        private final String[][] values;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static PeriodByRowHead peek(TypedInputStream stream) throws IOException {
            stream.mark();
            try {
                if (!stream.readRow()) {
                    PeriodByRowHead periodByRowHead = new PeriodByRowHead(0, 0, new String[0][]);
                    return periodByRowHead;
                }
                List<String> line = PeriodByRowHead.readNameLine(stream);
                if (line == null) {
                    int columns = PeriodByRowHead.countConsecutiveNonNullCellNumber(stream);
                    PeriodByRowHead periodByRowHead = new PeriodByRowHead(0, columns, new String[0][]);
                    return periodByRowHead;
                }
                List<String> firstLine = line;
                if (!stream.readRow() || (line = PeriodByRowHead.readNameLine(stream)) == null) {
                    PeriodByRowHead periodByRowHead = new PeriodByRowHead(1, firstLine.size(), new String[][]{firstLine.toArray(new String[firstLine.size()])});
                    return periodByRowHead;
                }
                ArrayList<String[]> lines = new ArrayList<String[]>();
                lines.add(firstLine.toArray(new String[firstLine.size()]));
                do {
                    lines.add(line.toArray(new String[firstLine.size()]));
                } while (stream.readRow() && (line = PeriodByRowHead.readNameLine(stream)) != null);
                PeriodByRowHead periodByRowHead = new PeriodByRowHead(lines.size(), firstLine.size(), (String[][])lines.toArray((T[])new String[lines.size()][]));
                return periodByRowHead;
            }
            finally {
                stream.reset();
            }
        }

        private static int countConsecutiveNonNullCellNumber(TypedInputStream stream) throws IOException {
            int result = 0;
            while (stream.readCell() && stream.getNumber() != null) {
                ++result;
            }
            return result;
        }

        private static List<String> readNameLine(TypedInputStream stream) throws IOException {
            return stream.readCell() && stream.getDateTime() == null ? GridReader.readCells(stream, TypedInputStream::getString) : null;
        }

        void skip(TypedInputStream stream) throws IOException {
            for (int row = 0; row < this.rows && stream.readRow(); ++row) {
            }
        }

        List<String> getNames(String namePattern, String nameSeparator) {
            switch (this.rows) {
                case 0: {
                    return Stream.generate(GridReader.getNameGenerator(namePattern)).limit(this.columns).collect(Collectors.toList());
                }
                case 1: {
                    return Stream.of(this.values[0]).limit(this.columns).collect(Collectors.toList());
                }
            }
            Collector<CharSequence, ?, String> nameJoiner = Collectors.joining(nameSeparator);
            String[] path = new String[this.rows];
            ArrayList<String> result = new ArrayList<String>();
            for (int column = 0; column < this.columns; ++column) {
                boolean hasHeader = false;
                for (int row = 0; row < this.rows - 1; ++row) {
                    String name = this.values[row][column];
                    if (name == null) continue;
                    hasHeader = true;
                    path[row] = name;
                }
                String lastCell = this.values[this.rows - 1][column];
                if (lastCell != null || hasHeader) {
                    path[this.rows - 1] = lastCell;
                    result.add(GridReader.joinSkippingNulls(path, nameJoiner));
                    continue;
                }
                result.add(null);
            }
            return result;
        }

        @Generated
        public PeriodByRowHead(int rows, int columns, String[][] values) {
            this.rows = rows;
            this.columns = columns;
            this.values = values;
        }
    }
}

