/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.geo.distributions.VonMisesFisherDistribution;
import dr.geo.math.Space;
import dr.inference.model.Parameter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class VonMisesFisherDiffusionModel
extends MultivariateDiffusionModel {
    public static final String VON_MISES_FISHER_MODEL = "vonMisesFisherDiffusionModel";
    public static final String KAPPA = "kappa";
    private Parameter concentrationParameter;
    private int p;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("kappa", new XMLSyntaxRule[]{new ElementRule(Parameter.class)})};

        @Override
        public String getParserName() {
            return VonMisesFisherDiffusionModel.VON_MISES_FISHER_MODEL;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            XMLObject xMLObject2 = xMLObject.getChild(VonMisesFisherDiffusionModel.KAPPA);
            Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
            return new VonMisesFisherDiffusionModel(parameter);
        }

        @Override
        public String getParserDescription() {
            return "Describes a von Mises-Fisher distributed diffusion process on a sphere.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return MultivariateDiffusionModel.class;
        }
    };

    public VonMisesFisherDiffusionModel(Parameter parameter) {
        this(3, parameter);
    }

    public VonMisesFisherDiffusionModel(int n, Parameter parameter) {
        this.p = n;
        this.concentrationParameter = parameter;
        this.calculatePrecisionInfo();
        this.addVariable(parameter);
    }

    @Override
    protected void calculatePrecisionInfo() {
        if (this.p == 1 || this.p > 3) {
            throw new RuntimeException("Von Mises-Fisher distribution only implemented for circles and spheres");
        }
    }

    private boolean isInBounds(double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[1];
        return d >= -90.0 && d < 90.0 && d2 > -180.0 && d2 < 180.0;
    }

    @Override
    protected double calculateLogDensity(double[] dArray, double[] dArray2, double d) {
        if (!this.isInBounds(dArray) || !this.isInBounds(dArray2)) {
            return Double.NEGATIVE_INFINITY;
        }
        double d2 = this.concentrationParameter.getParameterValue(0) / d;
        return VonMisesFisherDistribution.logPdf(dArray, dArray2, d2, Space.LAT_LONG);
    }

    public static void main(String[] stringArray) {
        Parameter.Default default_ = new Parameter.Default(2.0);
        VonMisesFisherDiffusionModel vonMisesFisherDiffusionModel = new VonMisesFisherDiffusionModel(default_);
        double[] dArray = new double[]{90.0, 0.0};
        double[] dArray2 = new double[]{0.0, 90.0};
        double d = 0.1;
        System.err.println("logPDF = " + vonMisesFisherDiffusionModel.calculateLogDensity(dArray, dArray2, d) + " ?= -18.84214");
    }
}

