/*
 * Decompiled with CFR 0.152.
 */
package OpenSourceExtensions;

import org.apache.commons.math.MathException;
import org.apache.commons.math.special.Erf;

public class StatUtil {
    private static final double P_LOW = 0.02425;
    private static final double P_HIGH = 0.97575;
    private static final double[] ICDF_A = new double[]{-39.69683028665376, 220.9460984245205, -275.9285104469687, 138.357751867269, -30.66479806614716, 2.506628277459239};
    private static final double[] ICDF_B = new double[]{-54.47609879822406, 161.5858368580409, -155.6989798598866, 66.80131188771972, -13.28068155288572};
    private static final double[] ICDF_C = new double[]{-0.007784894002430293, -0.3223964580411365, -2.400758277161838, -2.549732539343734, 4.374664141464968, 2.938163982698783};
    private static final double[] ICDF_D = new double[]{0.007784695709041462, 0.3224671290700398, 2.445134137142996, 3.754408661907416};

    public static double getInvCDF(double d) {
        if (d == 0.0) {
            d += 1.0E-14;
        }
        if (d == 1.0) {
            d -= 1.0E-14;
        }
        double d2 = 0.0;
        if (d == 0.0) {
            d2 = Double.NEGATIVE_INFINITY;
        } else if (d == 1.0) {
            d2 = Double.POSITIVE_INFINITY;
        } else if (Double.isNaN(d) || d < 0.0 || d > 1.0) {
            d2 = Double.NaN;
        } else if (d < 0.02425) {
            double d3 = Math.sqrt(-2.0 * Math.log(d));
            d2 = (((((ICDF_C[0] * d3 + ICDF_C[1]) * d3 + ICDF_C[2]) * d3 + ICDF_C[3]) * d3 + ICDF_C[4]) * d3 + ICDF_C[5]) / ((((ICDF_D[0] * d3 + ICDF_D[1]) * d3 + ICDF_D[2]) * d3 + ICDF_D[3]) * d3 + 1.0);
        } else if (0.97575 < d) {
            double d4 = Math.sqrt(-2.0 * Math.log(1.0 - d));
            d2 = -(((((ICDF_C[0] * d4 + ICDF_C[1]) * d4 + ICDF_C[2]) * d4 + ICDF_C[3]) * d4 + ICDF_C[4]) * d4 + ICDF_C[5]) / ((((ICDF_D[0] * d4 + ICDF_D[1]) * d4 + ICDF_D[2]) * d4 + ICDF_D[3]) * d4 + 1.0);
        } else {
            double d5 = d - 0.5;
            double d6 = d5 * d5;
            d2 = (((((ICDF_A[0] * d6 + ICDF_A[1]) * d6 + ICDF_A[2]) * d6 + ICDF_A[3]) * d6 + ICDF_A[4]) * d6 + ICDF_A[5]) * d5 / (((((ICDF_B[0] * d6 + ICDF_B[1]) * d6 + ICDF_B[2]) * d6 + ICDF_B[3]) * d6 + ICDF_B[4]) * d6 + 1.0);
        }
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            System.err.println("getInvCDF(" + d + ") is infinite or NaN");
        }
        return d2;
    }

    public static double normal_cdf(double d) {
        double d2;
        try {
            d2 = 0.5 * (1.0 + Erf.erf((double)(d / Math.sqrt(2.0))));
        }
        catch (MathException mathException) {
            return Double.NaN;
        }
        if (d2 <= 0.0) {
            return 1.0E-14;
        }
        if (d2 >= 1.0) {
            return 0.99999999999999;
        }
        return d2;
    }
}

