/*
 * Decompiled with CFR 0.152.
 */
package ec.util.spreadsheet.html;

import ec.util.spreadsheet.Sheet;
import ec.util.spreadsheet.helpers.ArrayBook;
import ec.util.spreadsheet.helpers.ArraySheet;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.Objects;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;
import standalone_spreadsheet.org.jsoup.Jsoup;
import standalone_spreadsheet.org.jsoup.nodes.Document;
import standalone_spreadsheet.org.jsoup.nodes.Element;

final class HtmlBookReader {
    private Charset charset = null;
    private String baseUri = "";

    HtmlBookReader() {
    }

    public void setCharset(@Nullable Charset charset) {
        this.charset = charset;
    }

    public void setBaseUri(@NonNull String baseUri) {
        this.baseUri = Objects.requireNonNull(baseUri);
    }

    @NonNull
    public ArrayBook read(@NonNull String html) {
        if (html == null) {
            throw new NullPointerException("html is marked non-null but is null");
        }
        return HtmlBookReader.readHtml(Jsoup.parse(html, this.baseUri));
    }

    @NonNull
    public ArrayBook read(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        HtmlBookReader.checkFile(file);
        return HtmlBookReader.readHtml(Jsoup.parse(file, this.getCharsetNameOrNull(), this.baseUri));
    }

    @NonNull
    public ArrayBook read(@NonNull InputStream stream) throws IOException {
        Objects.requireNonNull(stream);
        if (stream.available() == 0) {
            throw new EOFException();
        }
        return HtmlBookReader.readHtml(Jsoup.parse(stream, this.getCharsetNameOrNull(), this.baseUri));
    }

    @NonNull
    private static File checkFile(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (!file.exists()) {
            throw new NoSuchFileException(file.getPath());
        }
        if (!file.canRead() || file.isDirectory()) {
            throw new AccessDeniedException(file.getPath());
        }
        if (file.length() == 0L) {
            throw new EOFException(file.getPath());
        }
        return file;
    }

    private String getCharsetNameOrNull() {
        return this.charset != null ? this.charset.name() : null;
    }

    private static ArrayBook readHtml(Document doc) {
        ArrayBook.Builder bookBuilder = ArrayBook.builder();
        ArraySheet.Builder sheetBuilder = ArraySheet.builder();
        RowSpans rowSpans = new RowSpans();
        int sheetIndex = 0;
        for (Element table : doc.getElementsByTag("table")) {
            bookBuilder.sheet((Sheet)HtmlBookReader.readTable(table, sheetIndex, sheetBuilder, rowSpans));
            ++sheetIndex;
        }
        return bookBuilder.build();
    }

    private static ArraySheet readTable(Element table, int tableIndex, ArraySheet.Builder builder, RowSpans rowSpans) {
        builder.clear();
        rowSpans.clear();
        builder.name(HtmlBookReader.parseTableName(table, tableIndex));
        int i = 0;
        for (Element row : table.getElementsByTag("tr")) {
            if (row.parent().tagName().equals("tfoot")) continue;
            int j = 0;
            for (Element cell : row.children().select("td, th")) {
                while (rowSpans.hasSpan(j)) {
                    ++j;
                }
                String cellValue = cell.text();
                if (!cellValue.isEmpty()) {
                    builder.value(i, j, (Object)cellValue);
                }
                rowSpans.increase(j, HtmlBookReader.parseSpan(cell.attr("rowspan")));
                j += HtmlBookReader.parseSpan(cell.attr("colspan"));
            }
            rowSpans.decrease();
            ++i;
        }
        return builder.build();
    }

    private static String parseTableName(Element table, int tableIndex) {
        String result;
        Element first;
        if (table.childNodeSize() > 0 && (first = table.child(0)).tagName().equals("caption") && (result = first.text()) != null && !result.isEmpty()) {
            return result;
        }
        return "Sheet " + tableIndex;
    }

    private static int parseSpan(String value) {
        try {
            int result = Integer.parseInt(value);
            return result > 0 ? result : 0;
        }
        catch (NumberFormatException ex) {
            return 1;
        }
    }

    private static final class RowSpans {
        private int[] data = new int[0];

        private RowSpans() {
        }

        private void checkSize(int columnIndex) {
            if (this.data.length < columnIndex + 1) {
                int[] old = this.data;
                this.data = new int[columnIndex + 1];
                System.arraycopy(old, 0, this.data, 0, old.length);
            }
        }

        public void increase(int columnIndex, int count) {
            if (count > 0) {
                this.checkSize(columnIndex);
                int n = columnIndex;
                this.data[n] = this.data[n] + count;
            }
        }

        public boolean hasSpan(int columnIndex) {
            return columnIndex < this.data.length && this.data[columnIndex] > 0;
        }

        public void decrease() {
            for (int j = 0; j < this.data.length; ++j) {
                if (this.data[j] <= 0) continue;
                this.data[j] = this.data[j] - 1;
            }
        }

        public void clear() {
            Arrays.fill(this.data, 0);
        }
    }
}

