/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pooling.kdtree;

import java.util.Objects;

public class Range {
    private final boolean infinite;
    private final Comparable low;
    private final Comparable high;
    private int hashCode;
    public static final Range INFINITE = new Range();
    private static final String IR = "infinite range";
    private static final IllegalStateException IRE = new IllegalStateException("infinite range");

    public Range(Comparable comparable, Comparable comparable2) {
        this.infinite = false;
        this.low = comparable;
        this.high = comparable2;
        this.hashCode = Objects.hash(comparable, comparable2, this.infinite);
        if (!comparable.getClass().equals(comparable2.getClass())) {
            throw new IllegalArgumentException("incompatible coordinates");
        }
    }

    public Range(Comparable comparable) {
        this(comparable, comparable);
    }

    private Range() {
        this.high = IR;
        this.low = IR;
        this.infinite = true;
    }

    public Comparable low() {
        if (this.infinite) {
            throw IRE;
        }
        return this.low;
    }

    public Comparable high() {
        if (this.infinite) {
            throw IRE;
        }
        return this.high;
    }

    public boolean infinite() {
        return this.infinite;
    }

    public String toString() {
        if (this.infinite()) {
            return "[INFINITE]";
        }
        return "[" + this.low + ", " + this.high + "]";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (null != object && object instanceof Range) {
            Range range = (Range)object;
            if (this.hashCode() != range.hashCode()) {
                return false;
            }
            return Objects.equals(this.low, range.low) && Objects.equals(this.high, range.high) && Objects.equals(this.infinite, range.infinite);
        }
        return false;
    }
}

