## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(VariableSelection)

## -----------------------------------------------------------------------------
data("dat")
head(dat,5)

## -----------------------------------------------------------------------------
example1 <- modelselect.lm(formula = Y~X1+X2+X3+X4, data = dat)

## -----------------------------------------------------------------------------
head(example1$models)
example1$variables

## -----------------------------------------------------------------------------
example2 <- modelselect.lm(formula = Y~., data = dat)
example2$variables

## -----------------------------------------------------------------------------
example3 <- modelselect.lm(formula = Y~X1*X2+X3+X4+X5+X6, data = dat)
example3$variables

## -----------------------------------------------------------------------------
example5 <- modelselect.lm(formula = Y~X1+X2+X3+X4, data = dat, GA_var = 16, maxiterations = 2000, runs_til_stop = 1000, monitor = TRUE, popSize = 100)

## -----------------------------------------------------------------------------
lm_model <- lm.best(object = example1, method = "models")
lm_model$coefficients

## -----------------------------------------------------------------------------
lm_var <- lm.best(object = example2, method = "variables", threshold = 0.9)

## -----------------------------------------------------------------------------
summary(lm_model)

## -----------------------------------------------------------------------------
data("glmdat")
head(glmdat,5)

## -----------------------------------------------------------------------------
example.glm <- modelselect.glm(formula = Y~., family = "binomial", data = glmdat)
example.glm$variables

## -----------------------------------------------------------------------------
glm_model <- glm.best(object = example.glm, family = "binomial", method = "models", threshold = 0.95)

## -----------------------------------------------------------------------------
summary(glm_model)

