## ----echo = FALSE, results = "hide", message = FALSE-------------------------------
oldoptions <- options()
oldpar <- par()
options(width = 85)
require(houba)

## ----create-file-------------------------------------------------------------------
A <- mvector(datatype = "double", length = 100)
A

## ----create-file2------------------------------------------------------------------
filename <- file.path(tempdir(), "integers120")
B <- mmatrix(datatype = "integer", nrow = 12, ncol = 10, filename = filename)
B

## ----from_R------------------------------------------------------------------------
# Convert regular R objects to memory-mapped objects
a <- matrix(1:20, 4, 5)
A <- as.mmatrix(a, datatype = "float")
A

## ----from_R2-----------------------------------------------------------------------
v <- 1:10
V <- as.mvector(v)
V

## ----to_R--------------------------------------------------------------------------
as.vector(V)

## ----------------------------------------------------------------------------------
C <- mvector("int", 120, filename)
C

## ----------------------------------------------------------------------------------
B[1:4] <- 1:4
C

## ----flush-------------------------------------------------------------------------
B[1:4] <- 2:5
flush(B)
C

## ----descriptor_create-------------------------------------------------------------
B
dsc <- descriptor.file(B)

## ----descriptor_read---------------------------------------------------------------
D <- read.descriptor(dsc)
D

## ----bigmemory---------------------------------------------------------------------
library(bigmemory)
desc <- dget(dsc)

## ----bigmemory2--------------------------------------------------------------------
bm <- attach.big.matrix(desc)

## ----bigmemory3--------------------------------------------------------------------
bm[,1]

## ----------------------------------------------------------------------------------
B
rdata_file <- tempfile(fileext = ".rda")
save.image(rdata_file)

## ----------------------------------------------------------------------------------
rm(B)

## ----------------------------------------------------------------------------------
load(rdata_file)
B

## ----------------------------------------------------------------------------------
B <- restore(B)
B

## ----------------------------------------------------------------------------------
C <- copy(B)
C

## ----dim---------------------------------------------------------------------------
a <- matrix(1:12, 3, 4)
A <- as.mmatrix(a)
A
dim(A)

## ----dim2--------------------------------------------------------------------------
dim(A) <- c(4, 3)
A

## ----dim3--------------------------------------------------------------------------
dim(A) <- NULL
A

## ----dim4--------------------------------------------------------------------------
dim(A) <- c(2,2,3)
A

## ----access------------------------------------------------------------------------
a <- matrix( sample(0:99, 2500, TRUE), 50, 50)
A <- as.mmatrix(a)

## ----access2-----------------------------------------------------------------------
A[1,1]

## ----access3-----------------------------------------------------------------------
A[1,]

## ----houba-------------------------------------------------------------------------
houba(max.size = 20)

## ----houba2------------------------------------------------------------------------
A[1,]

## ----assign------------------------------------------------------------------------
A[1,1] <- 0
A[2,] <- 10
A

## ----assign2-----------------------------------------------------------------------
V <- as.mvector(1:50, "int")
A[3,] <- V
A

## ----no-promo----------------------------------------------------------------------
A[1,1] <- pi
A[1,1]

## ----arithmetic--------------------------------------------------------------------
a <- matrix( sample.int(16), 4, 4)
A <- as.mmatrix(a, datatype = "float")
A <- 1 + 2*A
A

## ----arithmetic2-------------------------------------------------------------------
B <- A + 2
C <- A / B
C

## ----no-promo2---------------------------------------------------------------------
A <- as.mvector( seq(0, 1, length = 11), datatype = "float" )
B <- as.mvector( 0:10, datatype = "integer" )

## ----no-promo3---------------------------------------------------------------------
A + B

## ----nop4--------------------------------------------------------------------------
B + A

## ----inplace-----------------------------------------------------------------------
V <- as.mvector(1:20, "float")
W <- as.mvector(sample.int(20))

inplace.sum(V, 1)          # Add 1 to all elements
inplace.prod(V, W)         # Multiply elements of V by elements of W
inplace.minus(V, c(1,2))   # Subtract c(1,2) from all elements (recycling)
inplace.div(V, 4)          # Divide all elements by 4
inplace.opposite(V)        # Take opposite of all elements
inplace.inverse(V)         # Take reciprocal of all elements

V

## ----cs----------------------------------------------------------------------------
a <- matrix( sample.int(100), 10, 10)
A <- as.mmatrix(a)

# Row sums and meands
rowSums(A)
rowMeans(A)

## ----cs2---------------------------------------------------------------------------
houba(max.size = 5)
rowSums(A)

## ----apply-------------------------------------------------------------------------
houba(max.size = 5)
apply(A, 1, sd)

## ----apply2------------------------------------------------------------------------
apply(A, 1, sum)

## ----apply3------------------------------------------------------------------------
houba(max.size = 1e6)
apply(A, 1, sd)

## ----echo = FALSE, results = "hide", message = FALSE--------------------------
options(oldoptions)
unlink(filename)
unlink(dsc)

