library("foreign")
library("paran")
x <- read.spss("BANK2.sav", to.data.frame=T)

px <- prcomp(x)
lx <- px$sdev^2
pz <- prcomp(x, scale=T)
lz <- pz$sdev^2

pdf("pca_covcor.pdf", width=10, height=6)
par(mfrow=c(2,4))
plot(px$x[,1], px$x[,2], pch=19, xlab="PC1", ylab="PC2")
plot(px$x[,1], px$x[,3], pch=19, xlab="PC1", ylab="PC3")
plot(pz$x[,1], pz$x[,2], pch=19, xlab="PC1", ylab="PC2")
plot(pz$x[,1], pz$x[,3], pch=19, xlab="PC1", ylab="PC3")
plot(seq(lx), lx, main="Scree (covariance)", type="b", pch=19, xlab="index", ylab="Variances")
abline(h=mean(lx), col="green", lwd=2)
p90 <- sum(cumsum(lx)/sum(lx)<0.9)
abline(v=p90+1.5, col="red", lwd="2")
plot(px$x[,2], px$x[,3], pch=19, xlab="PC2", ylab="PC3")
plot(seq(lz), lz, main="Scree (correlation)", type="b", pch=19, xlab="index", ylab="Variances")
abline(h=mean(lz), col="green", lwd=2)
p90 <- sum(cumsum(lz)/sum(lz)<0.9)
abline(v=p90+1.5, col="red", lwd="2")
hx <-paran(x, iterations=1000, centile=95)
lines(seq(lz), hx$RndEv, col="blue", lwd=2)
points(seq(lz), hx$RndEv, col="blue", pch=19)
plot(pz$x[,2], pz$x[,3], pch=19, xlab="PC2", ylab="PC3")
dev.off()
if (interactive()) browseURL(paste0(getwd(),"/pca_covcor.pdf"))