/*
 * Decompiled with CFR 0.152.
 */
package internal.spreadsheet.base.api.grid;

import ec.util.spreadsheet.Sheet;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Predicate;
import jdplus.toolkit.base.tsp.grid.GridDataType;
import jdplus.toolkit.base.tsp.grid.GridInput;
import lombok.Generated;
import lombok.NonNull;

public final class SheetGridInput
implements GridInput {
    private final Sheet sheet;
    private final Predicate<Class<?>> isSupportedDataType;
    private final ZoneId zoneId = ZoneId.systemDefault();

    @NonNull
    public Set<GridDataType> getDataTypes() {
        EnumSet<GridDataType> dataTypes = EnumSet.noneOf(GridDataType.class);
        if (this.isSupportedDataType.test(String.class)) {
            dataTypes.add(GridDataType.STRING);
        }
        if (this.isSupportedDataType.test(Double.class)) {
            dataTypes.add(GridDataType.DOUBLE);
        }
        if (this.isSupportedDataType.test(Date.class)) {
            dataTypes.add(GridDataType.LOCAL_DATE_TIME);
        }
        return dataTypes;
    }

    @NonNull
    public String getName() {
        return this.sheet.getName();
    }

    @NonNull
    public GridInput.Stream open() throws IOException {
        return new SheetGridInputStream();
    }

    @Generated
    private SheetGridInput(Sheet sheet, Predicate<Class<?>> isSupportedDataType) {
        this.sheet = sheet;
        this.isSupportedDataType = isSupportedDataType;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull SheetGridInput of(Sheet sheet, Predicate<Class<?>> isSupportedDataType) {
        return new SheetGridInput(sheet, isSupportedDataType);
    }

    private final class SheetGridInputStream
    implements GridInput.Stream {
        private int row = -1;
        private int col = -1;

        private SheetGridInputStream() {
        }

        public boolean readCell() {
            ++this.col;
            return this.col < SheetGridInput.this.sheet.getColumnCount();
        }

        public boolean readRow() {
            this.col = -1;
            ++this.row;
            return this.row < SheetGridInput.this.sheet.getRowCount();
        }

        public Object getCell() {
            Object result = SheetGridInput.this.sheet.getCellValue(this.row, this.col);
            return result instanceof Date ? this.toDateTime((Date)result) : result;
        }

        public void close() {
        }

        private LocalDateTime toDateTime(Date o) {
            return LocalDateTime.ofInstant(o.toInstant(), SheetGridInput.this.zoneId);
        }
    }
}

