/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.regarima;

import jdplus.sa.base.core.regarima.AutomaticTradingRegressionModule;
import jdplus.sa.base.core.regarima.ModelBuilder;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.calendars.LengthOfPeriodType;
import jdplus.toolkit.base.api.timeseries.regression.ILengthOfPeriodVariable;
import jdplus.toolkit.base.api.timeseries.regression.ITradingDaysVariable;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.ModellingUtility;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.regarima.AICcComparator;
import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaUtility;
import jdplus.toolkit.base.core.regsarima.regular.IModelComparator;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.ProcessingResult;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.stats.likelihood.LikelihoodStatistics;

public class CalendarEffectsDetectionModule
implements AutomaticTradingRegressionModule {
    private final IModelComparator comparator;
    private final ITradingDaysVariable td;
    private final ILengthOfPeriodVariable lp;
    private final LengthOfPeriodType adjust;
    private final double eps;

    public static Builder builder() {
        return new Builder();
    }

    private CalendarEffectsDetectionModule(Builder builder) {
        this.comparator = builder.comparator;
        this.eps = builder.eps;
        this.lp = builder.lp;
        this.td = builder.td;
        this.adjust = builder.adjust;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessingResult test(RegSarimaModelling context) {
        ProcessingLog log = context.getLog();
        log.push("automatic trading days selection");
        try {
            int best;
            ModelDescription description = context.getDescription();
            IRegArimaComputer processor = RegArimaUtility.processor((boolean)true, (double)this.eps);
            ModelDescription ntddesc = ModelDescription.copyOf((ModelDescription)description);
            boolean removed = ntddesc.removeVariable(var -> ModellingUtility.isTradingDays((Variable)var));
            if (this.lp != null) {
                if (ntddesc.isAdjusted()) {
                    ntddesc.setPreadjustment(LengthOfPeriodType.None);
                } else {
                    ntddesc.removeVariable(var -> ModellingUtility.isLengthOfPeriod((Variable)var));
                }
            }
            ModelDescription tddesc = ModelDescription.copyOf((ModelDescription)ntddesc);
            tddesc.addVariable(Variable.variable((String)"td", (ITsVariable)this.td, ModelBuilder.calendarAMI));
            if (this.lp != null) {
                if (tddesc.isLogTransformation() && this.adjust != LengthOfPeriodType.None) {
                    tddesc.setPreadjustment(this.adjust);
                } else {
                    tddesc.addVariable(Variable.variable((String)"lp", (ITsVariable)this.lp, ModelBuilder.calendarAMI));
                }
            }
            RegArimaEstimation tdest = tddesc.estimate(processor);
            RegArimaEstimation ntdest = ntddesc.estimate(processor);
            boolean changed = false;
            if (this.comparator.compare(ntdest, tdest) == 0) {
                best = 1;
                if (!removed) {
                    changed = true;
                }
                context.set(tddesc, tdest);
            } else {
                best = 0;
                if (removed) {
                    changed = true;
                }
                context.set(ntddesc, ntdest);
            }
            AutomaticTradingRegressionModule.Info info = new AutomaticTradingRegressionModule.Info(new String[]{"no td", this.td.description(null)}, new LikelihoodStatistics[]{ntdest.statistics(), tdest.statistics()}, best);
            log.info((String)(best == 0 ? "no trading days" : "selected trading days: " + info.getNames()[best]), (Object)info);
            ProcessingResult processingResult = changed ? ProcessingResult.Changed : ProcessingResult.Unchanged;
            return processingResult;
        }
        finally {
            log.pop();
        }
    }

    public static class Builder {
        private ITradingDaysVariable td;
        private ILengthOfPeriodVariable lp;
        private LengthOfPeriodType adjust = LengthOfPeriodType.None;
        private IModelComparator comparator = new AICcComparator(0.0);
        private double eps = 1.0E-5;

        public Builder tradingDays(ITradingDaysVariable td) {
            this.td = td;
            return this;
        }

        public Builder leapYear(ILengthOfPeriodVariable lp) {
            this.lp = lp;
            return this;
        }

        public Builder estimationPrecision(double eps) {
            this.eps = eps;
            return this;
        }

        public Builder adjust(LengthOfPeriodType adjust) {
            this.adjust = adjust;
            return this;
        }

        public Builder modelComparator(IModelComparator comparator) {
            this.comparator = comparator;
            return this;
        }

        public CalendarEffectsDetectionModule build() {
            return new CalendarEffectsDetectionModule(this);
        }
    }
}

