/*
 * Decompiled with CFR 0.152.
 */
package dmLab.array;

import dmLab.array.functions.ExtFunctions;
import dmLab.array.meta.Attribute;
import dmLab.array.meta.AttributesMetaInfo;
import dmLab.mcfs.MCFSParams;
import java.util.ArrayList;
import java.util.HashSet;

public abstract class Array
implements Cloneable {
    public static String SPACE_CHAR = "_";
    public Attribute[] attributes = null;
    protected int decAttrIdx = -1;
    private AttributesMetaInfo attributesDict = null;
    public boolean debug = false;

    /*
     * WARNING - void declaration
     */
    public static int[] colMask2colIdx(int[] colMask) {
        void var2_4;
        ArrayList<Integer> colIdx = new ArrayList<Integer>();
        for (int i = 0; i < colMask.length; ++i) {
            if (colMask[i] != 1) continue;
            colIdx.add(i);
        }
        int[] colIdxInt = new int[colIdx.size()];
        for (int i = 0; i < colIdx.size(); ++i) {
            colIdxInt[i] = (Integer)colIdx.get(i);
        }
        return var2_4;
    }

    public abstract void init(int var1, int var2);

    protected final void initAttributes$255f295(int cols) {
        this.attributesDict = null;
        this.decAttrIdx = -1;
        this.attributes = new Attribute[cols];
        for (int i = 0; i < this.attributes.length; ++i) {
            this.attributes[i] = new Attribute();
        }
    }

    public abstract Array clone();

    public abstract Array clone(boolean[] var1, boolean[] var2);

    public final int getDecAttrIdx() {
        return this.decAttrIdx;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean setDecAttrIdx(int col) {
        void var1_1;
        if (col < 0 || col >= this.colsNumber()) {
            return false;
        }
        this.decAttrIdx = var1_1;
        this.setAllDecValues();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final String[] getColNames(boolean includeDecision) {
        void var3_3;
        int colNumber = this.colsNumber();
        String[] colNames = new String[colNumber];
        Array array = this;
        int decIndex = array.decAttrIdx;
        if (includeDecision) {
            decIndex = -1;
        } else {
            colNames = new String[colNumber - 1];
        }
        int j = 0;
        for (int i = 0; i < colNumber; ++i) {
            if (i == decIndex) continue;
            colNames[j++] = this.attributes[i].name;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final String[] getColNames(int[] colIdx, boolean includeDecision) {
        void var2_3;
        ArrayList<String> colNames = new ArrayList<String>();
        Array array = this;
        int decIndex = array.decAttrIdx;
        for (int i = 0; i < colIdx.length; ++i) {
            if (colIdx[i] == decIndex) continue;
            colNames.add(this.attributes[colIdx[i]].name);
        }
        String[] colNamesArray = new String[1];
        return var2_3.toArray(colNamesArray);
    }

    /*
     * WARNING - void declaration
     */
    public final int getColIndex(String colName) {
        void var2_2;
        int index = -1;
        for (int i = 0; i < this.attributes.length; ++i) {
            if (!this.attributes[i].name.equalsIgnoreCase(colName)) continue;
            index = i;
            break;
        }
        return (int)var2_2;
    }

    protected final void bindAttributes(Attribute[] srcAttributes) {
        Attribute[] attributesTMP = this.attributes;
        this.attributes = new Attribute[this.attributes.length + srcAttributes.length];
        int j = 0;
        for (int i = 0; i < this.attributes.length; ++i) {
            this.attributes[i] = i < attributesTMP.length ? attributesTMP[i] : srcAttributes[j++];
        }
    }

    public abstract void cbind(Array var1);

    public abstract int rowsNumber();

    public abstract int colsNumber();

    public abstract boolean setAllDecValues();

    public abstract boolean setDecValues(String[] var1);

    public abstract String[] getDecValuesStr();

    public abstract String readValueStr(int var1, int var2);

    public abstract boolean writeValueStr(int var1, int var2, String var3);

    public abstract boolean findDomains();

    public abstract boolean domainsCreated();

    public abstract String[] getDomainStr(int var1);

    public abstract String[] getColumnStr(int var1);

    public abstract void swapColumns(int var1, int var2);

    public final boolean isTargetNominal() {
        return this.attributes[this.decAttrIdx].type == 1;
    }

    public final AttributesMetaInfo buildAttributesMetaInfo(boolean refresh) {
        if (this.attributesDict == null) {
            this.attributesDict = new AttributesMetaInfo(this);
        }
        return this.attributesDict;
    }

    public final void fixAttributesNames$1385ff() {
        HashSet<String> attrSet = new HashSet<String>();
        for (int i = 0; i < this.attributes.length; ++i) {
            if (ExtFunctions.isContrastAttribute(this.attributes[i].name)) {
                this.attributes[i].name = MCFSParams.FIX_ATTR_PREFIX + this.attributes[i].name;
            }
            int idx = 1;
            String currAttrName = this.attributes[i].name;
            while (attrSet.contains(currAttrName)) {
                currAttrName = this.attributes[i].name + "." + idx;
                ++idx;
            }
            this.attributes[i].name = currAttrName;
            attrSet.add(this.attributes[i].name);
        }
    }
}

