/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier.adx.ruleSet;

import dmLab.array.Array;
import dmLab.array.FArray;
import dmLab.classifier.adx.ADXParams;
import dmLab.classifier.adx.complex.Quality;
import dmLab.classifier.adx.complex.complexLinks.ComplexLink;
import dmLab.classifier.adx.complex.complexLinks.ComplexLinks;
import dmLab.classifier.adx.ruleSet.RuleSet;
import dmLab.classifier.adx.selector.SelectorList;

public final class SelectRules {
    public final void selectMinFinalRuleSet_fast(RuleSet ruleSet, FArray array, SelectorList selectorsList, ADXParams adxParams, int finalBeam) {
        Object object;
        int eventsNumber = ((Array)array).rowsNumber();
        ruleSet.createLinks(adxParams);
        RuleSet ruleSet2 = ruleSet;
        ComplexLinks links = ruleSet2.complexLinks;
        int[] posEvents = new int[eventsNumber];
        int decisionId = array.getDecAttrIdx();
        float decValue = array.getDecValues()[ruleSet.decValIndex];
        int posNumber = 0;
        int negNumber = 0;
        for (int i = 0; i < eventsNumber; ++i) {
            if (array.readValue(decisionId, i) == decValue) {
                posEvents[i] = 1;
                ++posNumber;
                continue;
            }
            posEvents[i] = -1;
            ++negNumber;
        }
        int maxEventsForSelection = adxParams.maxEventsForSelection;
        int size = posEvents.length;
        if (posEvents.length > maxEventsForSelection) {
            double minProb = (double)(size - maxEventsForSelection) / (double)size;
            for (int i = 0; i < size; ++i) {
                if (!(Math.random() < minProb)) continue;
                if (posEvents[i] == 1) {
                    --posNumber;
                } else if (posEvents[i] == -1) {
                    --negNumber;
                }
                posEvents[i] = 0;
            }
        }
        int rulesNumber = links.size();
        int addedRules = 0;
        links.sort();
        links.disableAll();
        links.calcGlobalParams$4379dc3a();
        double globalScoreIndex = SelectRules.scoreIndex$2a44e1a7(array, selectorsList, links, adxParams, posEvents, posNumber, negNumber);
        for (int i = rulesNumber - 1; i >= 0; --i) {
            double d;
            links.enable(i);
            links.calcGlobalParams$4379dc3a();
            double scoreIndex = SelectRules.scoreIndex$2a44e1a7(array, selectorsList, links, adxParams, posEvents, posNumber, negNumber);
            if (d >= globalScoreIndex) {
                globalScoreIndex = scoreIndex;
                if (++addedRules != finalBeam) continue;
                break;
            }
            links.disable(i);
        }
        ruleSet2 = object;
        ruleSet2.complexLinks.initIterator(false);
        while ((object = ruleSet2.complexLinks.getNext()) != null) {
            ruleSet2.complexSetArray[((ComplexLink)object).setIndex].removeComplex(((ComplexLink)object).complexIndex);
        }
        object = ruleSet2;
        for (int i = 0; i < ((RuleSet)object).complexSetArray.length; ++i) {
            if (((RuleSet)object).complexSetArray[i] == null) continue;
            ((RuleSet)object).complexSetArray[i].trimList();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static double scoreIndex$2a44e1a7(FArray array, SelectorList selectorsList, ComplexLinks links, ADXParams adxParams, int[] posEvents, int posNumber, int negNumber) {
        void var3_3;
        double posScore = 0.0;
        double negScore = 0.0;
        for (int i = 0; i < posEvents.length; ++i) {
            if (posEvents[i] == 0) continue;
            double score = links.calcScore(selectorsList, array, i, adxParams);
            if (posEvents[i] == 1) {
                posScore += score;
                continue;
            }
            if (posEvents[i] != -1) continue;
            negScore += score;
        }
        double d = Quality.calc((float)(posScore / (double)posNumber), (float)(negScore / (double)negNumber), var3_3.scoreQ);
        return d;
    }
}

