// Copyright (C) 2014-2015 Bart Smeets
// Copyright (C) 2015-2016 Bart Smeets and Iñaki Ucar
// Copyright (C) 2016-2018 Iñaki Ucar
//
// This file is part of simmer.
//
// simmer is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// simmer is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with simmer. If not, see <http://www.gnu.org/licenses/>.

#ifndef simmer__entity_h
#define simmer__entity_h

#include <simmer/common.h>
#include <simmer/simulator.h>

namespace simmer {

  /**
   *  Base class. Every element in a simulation model is an entity.
   */
  class Entity {
  public:
    Simulator* sim;
    std::string name;

    Entity(Simulator* sim, const std::string& name, int mon)
      : sim(sim), name(name), mon(std::abs(mon)) {}
    virtual ~Entity() {}
    virtual void reset() = 0;
    int is_monitored() const { return mon; }

  private:
    int mon;
  };

} // namespace simmer

#endif
