## ----style, echo = FALSE, results = 'asis'------------------------------------
BiocStyle::markdown()

## ----options, include = FALSE-------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(tidyGenR)

## ----results = 'hide'---------------------------------------------------------
fq <-
 list.files(system.file("extdata", "truncated",
                        package = "tidyGenR"),
                        pattern = "F_filt.fastq.gz",
            full.names = TRUE)
ex_d <-
  explore_dada(fq,
    value_na = 10,
    reduced = TRUE,
    pool = FALSE,
    vline = 2,
    hline_fr = 0.1,
    omega_a = 0.9,
    band_size = 16
    )

## -----------------------------------------------------------------------------
ex_d$p3

## ----results='hide'-----------------------------------------------------------
# path to fastq
truncated <-
 system.file("extdata", "truncated", package = "tidyGenR")

# variant calling

omega_a_test <- c(relaxed = 4, restrictive = 6)

variants_called <-
  omega_a_test |>
    lapply(function(x) {
    variant_call(in_dir = truncated,
                 omega_a_f = exp(-exp(x)),
                 band_size = 16,
                 maf = 0.1
                 )
    })

# compare calls
comp_call <- 
  compare_calls(variants_called)

## -----------------------------------------------------------------------------
comp_call$plot2

