/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.bigfasttree.thorney;

import dr.evolution.tree.FlexibleTree;
import dr.evolution.tree.MutableTree;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.Taxon;
import dr.evomodel.tree.TreeChangedEvent;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ConstrainedTreeModel
extends TreeModel {
    public static final String CONSTRAINED_TREE_MODEL = "constrainedTreeModel";
    private final List<WrappingSubtree> subtrees;
    private int root = -1;
    private int storedRoot;
    private int[] edges = null;
    private int[] storedEdges = null;
    private double[] heights = null;
    private double[] storedHeights = null;
    private final NodeRef[] nodes;
    private final int nodeCount;
    private final int externalNodeCount;
    private final int internalNodeCount;

    public ConstrainedTreeModel(Tree tree, Tree tree2) {
        this(CONSTRAINED_TREE_MODEL, tree, false, false, tree2);
    }

    public ConstrainedTreeModel(ConstrainedTreeModel constrainedTreeModel) {
        super(CONSTRAINED_TREE_MODEL, constrainedTreeModel.isVariable());
        Serializable serializable;
        int n;
        this.internalNodeCount = constrainedTreeModel.getInternalNodeCount();
        this.externalNodeCount = constrainedTreeModel.getExternalNodeCount();
        this.nodeCount = this.internalNodeCount + this.externalNodeCount;
        this.nodes = new NodeRef[this.nodeCount];
        for (n = 0; n < this.nodeCount; ++n) {
            serializable = constrainedTreeModel.getNode(n);
            this.nodes[n] = constrainedTreeModel.isExternal((NodeRef)serializable) ? new Node(n, constrainedTreeModel.getNodeTaxon((NodeRef)serializable)) : new Node(n);
        }
        this.root = constrainedTreeModel.getRoot().getNumber();
        this.edges = new int[this.nodeCount * 3];
        System.arraycopy(constrainedTreeModel.edges, 0, this.edges, 0, this.nodeCount * 3);
        this.storedEdges = new int[this.nodeCount * 3];
        this.heights = new double[this.nodeCount];
        System.arraycopy(constrainedTreeModel.heights, 0, this.heights, 0, this.nodeCount);
        this.storedHeights = new double[this.nodeCount];
        this.subtrees = new ArrayList<WrappingSubtree>();
        for (n = 0; n < constrainedTreeModel.getSubtreeCount(); ++n) {
            serializable = (WrappingSubtree)constrainedTreeModel.getSubtree(n);
            HashSet<NodeRef> hashSet = new HashSet<NodeRef>();
            for (int i = 0; i < ((WrappingSubtree)serializable).getExternalNodeCount(); ++i) {
                WrappingSubtree.Node node = (WrappingSubtree.Node)((WrappingSubtree)serializable).getExternalNode(i);
                NodeRef nodeRef = this.nodes[node.getBaseNodeNumber()];
                hashSet.add(nodeRef);
            }
            WrappingSubtree wrappingSubtree = new WrappingSubtree(this, hashSet, n);
            this.subtrees.add(wrappingSubtree);
        }
    }

    public ConstrainedTreeModel(String string, Tree tree, Tree tree2) {
        this(string, tree, false, false, tree2);
    }

    public ConstrainedTreeModel(TreeModel treeModel, Tree tree) {
        this(CONSTRAINED_TREE_MODEL, treeModel, tree);
    }

    public ConstrainedTreeModel(String string, Tree tree, boolean bl, boolean bl2, Tree tree2) {
        super(string, !bl2);
        Serializable serializable;
        Serializable serializable2;
        this.setId(string);
        FlexibleTree flexibleTree = new FlexibleTree(tree);
        flexibleTree.resolveTree();
        if (!bl) {
            MutableTree.Utils.correctHeightsForTips(flexibleTree);
        }
        this.internalNodeCount = flexibleTree.getInternalNodeCount();
        this.externalNodeCount = flexibleTree.getExternalNodeCount();
        this.nodeCount = this.internalNodeCount + this.externalNodeCount;
        this.nodes = new NodeRef[this.nodeCount];
        this.edges = new int[this.nodeCount * 3];
        this.storedEdges = new int[this.nodeCount * 3];
        this.heights = new double[this.nodeCount];
        this.storedHeights = new double[this.nodeCount];
        boolean bl3 = false;
        NodeRef nodeRef = flexibleTree.getRoot();
        do {
            nodeRef = TreeUtils.postorderSuccessor(flexibleTree, nodeRef);
            int n = nodeRef.getNumber();
            if (flexibleTree.isExternal(nodeRef)) {
                this.nodes[n] = new Node(n, flexibleTree.getNodeTaxon(nodeRef));
                this.edges[n * 3] = flexibleTree.getParent(nodeRef).getNumber();
                this.edges[n * 3 + 1] = -1;
                this.edges[n * 3 + 2] = -1;
            } else {
                if (flexibleTree.isRoot(nodeRef)) {
                    this.root = n;
                    bl3 = true;
                    this.edges[n * 3] = -1;
                } else {
                    this.edges[n * 3] = flexibleTree.getParent(nodeRef).getNumber();
                }
                this.nodes[n] = new Node(n);
                this.edges[n * 3 + 1] = flexibleTree.getChild(nodeRef, 0).getNumber();
                this.edges[n * 3 + 2] = flexibleTree.getChild(nodeRef, 1).getNumber();
            }
            this.heights[n] = flexibleTree.getNodeHeight(nodeRef);
        } while (!bl3);
        HashMap<BitSet, NodeRef> hashMap = this.getBitSetNodeMap(tree2, tree2);
        HashMap<BitSet, NodeRef> hashMap2 = this.getBitSetNodeMap(tree2, this);
        HashMap<NodeRef, NodeRef> hashMap3 = new HashMap<NodeRef, NodeRef>();
        for (Serializable serializable3 : hashMap.keySet()) {
            serializable2 = (NodeRef)hashMap.get(serializable3);
            serializable = (NodeRef)hashMap2.get(serializable3);
            if (serializable == null) {
                throw new RuntimeException("All clades in the constraints tree must be present in the starting tree");
            }
            hashMap3.put((NodeRef)serializable2, (NodeRef)serializable);
        }
        this.subtrees = new ArrayList<WrappingSubtree>();
        for (int i = 0; i < tree2.getInternalNodeCount(); ++i) {
            Serializable serializable3;
            serializable3 = tree2.getInternalNode(i);
            serializable2 = new HashSet();
            for (int j = 0; j < tree2.getChildCount((NodeRef)serializable3); ++j) {
                NodeRef nodeRef2 = tree2.getChild((NodeRef)serializable3, j);
                serializable2.add((NodeRef)hashMap3.get(nodeRef2));
            }
            serializable = new WrappingSubtree(this, (Set<NodeRef>)((Object)serializable2), this.subtrees.size());
            this.subtrees.add((WrappingSubtree)serializable);
        }
    }

    private HashMap<BitSet, NodeRef> getBitSetNodeMap(Tree tree, Tree tree2) {
        HashMap<BitSet, NodeRef> hashMap = new HashMap<BitSet, NodeRef>();
        this.addBits(tree, tree2, tree2.getRoot(), hashMap);
        return hashMap;
    }

    private BitSet addBits(Tree tree, Tree tree2, NodeRef nodeRef, HashMap<BitSet, NodeRef> hashMap) {
        BitSet bitSet = new BitSet();
        if (tree2.isExternal(nodeRef)) {
            String string = tree2.getNodeTaxon(nodeRef).getId();
            bitSet.set(tree.getTaxonIndex(string));
        } else {
            for (int i = 0; i < tree2.getChildCount(nodeRef); ++i) {
                NodeRef nodeRef2 = tree2.getChild(nodeRef, i);
                bitSet.or(this.addBits(tree, tree2, nodeRef2, hashMap));
            }
        }
        hashMap.put(bitSet, nodeRef);
        return bitSet;
    }

    public int getSubtreeCount() {
        return this.subtrees.size();
    }

    public TreeModel getSubtree(NodeRef nodeRef, SubtreeContext subtreeContext) {
        return this.subtrees.get(((Node)nodeRef).getSubtreeNumber(subtreeContext));
    }

    public void copyEdgesAndHeights(ConstrainedTreeModel constrainedTreeModel) {
        System.arraycopy(constrainedTreeModel.heights, 0, this.heights, 0, this.nodeCount);
        System.arraycopy(constrainedTreeModel.edges, 0, this.edges, 0, this.nodeCount * 3);
    }

    public TreeModel getSubtree(NodeRef nodeRef) {
        return this.subtrees.get(((Node)nodeRef).getSubtreeNumber(SubtreeContext.IncludeRoot));
    }

    public TreeModel getSubtree(int n) {
        return this.subtrees.get(n);
    }

    private int getSubtreeIndex(NodeRef nodeRef, SubtreeContext subtreeContext) {
        return ((Node)nodeRef).getSubtreeNumber(subtreeContext);
    }

    public int getSubtreeIndex(NodeRef nodeRef) {
        return ((Node)nodeRef).getSubtreeNumber(SubtreeContext.IncludeRoot);
    }

    private NodeRef getNodeInSubtree(Tree tree, NodeRef nodeRef, SubtreeContext subtreeContext) {
        return ((WrappingSubtree)tree).getWrappingNode(nodeRef, subtreeContext);
    }

    public NodeRef getNodeInSubtree(Tree tree, NodeRef nodeRef) {
        return this.getNodeInSubtree(tree, nodeRef, SubtreeContext.IncludeRoot);
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    public void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    public boolean inTreeEdit() {
        return this.inEdit;
    }

    @Override
    public int getNodeCount() {
        return this.nodeCount;
    }

    @Override
    public double getNodeHeight(NodeRef nodeRef) {
        return this.heights[nodeRef.getNumber()];
    }

    public double getNodeHeightUpper(NodeRef nodeRef) {
        if (this.isRoot(nodeRef)) {
            return Double.POSITIVE_INFINITY;
        }
        return this.getNodeHeight(this.getParent(nodeRef));
    }

    public double getNodeHeightLower(NodeRef nodeRef) {
        if (this.isExternal(nodeRef)) {
            return 0.0;
        }
        return Math.max(this.getNodeHeight(this.getChild(nodeRef, 0)), this.getNodeHeight(this.getChild(nodeRef, 1)));
    }

    @Override
    public double getNodeRate(NodeRef nodeRef) {
        return 1.0;
    }

    @Override
    public Object getNodeAttribute(NodeRef nodeRef, String string) {
        throw new UnsupportedOperationException("getNodeAttribute not available in BigFastTreeModel");
    }

    @Override
    public Iterator getNodeAttributeNames(NodeRef nodeRef) {
        throw new UnsupportedOperationException("getNodeAttributeNames not available in BigFastTreeModel");
    }

    @Override
    public double[] getMultivariateNodeTrait(NodeRef nodeRef, String string) {
        throw new UnsupportedOperationException("getMultivariateNodeTrait not available in BigFastTreeModel");
    }

    @Override
    public Taxon getNodeTaxon(NodeRef nodeRef) {
        return ((Node)nodeRef).taxon;
    }

    @Override
    public boolean isExternal(NodeRef nodeRef) {
        return nodeRef.getNumber() < this.externalNodeCount;
    }

    @Override
    public boolean isRoot(NodeRef nodeRef) {
        return nodeRef.getNumber() == this.root;
    }

    @Override
    public int getChildCount(NodeRef nodeRef) {
        if (this.isExternal(nodeRef)) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            if (this.edges[nodeRef.getNumber() * 3 + i + 1] <= -1) continue;
            ++n;
        }
        return n;
    }

    @Override
    public NodeRef getChild(NodeRef nodeRef, int n) {
        return this.nodes[this.getChild(nodeRef.getNumber(), n)];
    }

    @Override
    public NodeRef getParent(NodeRef nodeRef) {
        if (this.isRoot(nodeRef)) {
            return null;
        }
        int n = this.getParent(nodeRef.getNumber());
        return n == -1 ? null : this.nodes[n];
    }

    @Override
    public NodeRef getExternalNode(int n) {
        return this.nodes[n];
    }

    @Override
    public NodeRef getInternalNode(int n) {
        return this.nodes[n + this.externalNodeCount];
    }

    @Override
    public NodeRef getNode(int n) {
        return this.nodes[n];
    }

    @Override
    public NodeRef[] getNodes() {
        return this.nodes;
    }

    @Override
    public int getExternalNodeCount() {
        return this.externalNodeCount;
    }

    @Override
    public int getInternalNodeCount() {
        return this.internalNodeCount;
    }

    @Override
    public NodeRef getRoot() {
        return this.nodes[this.root];
    }

    @Override
    public boolean isTipDateSampled() {
        return false;
    }

    private int getParent(int n) {
        return this.edges[n * 3];
    }

    private int getChild(int n, int n2) {
        assert (n2 == 0 || n2 == 1);
        return this.edges[n * 3 + n2 + 1];
    }

    private void setParent(int n, int n2) {
        this.edges[n * 3] = n2;
    }

    private void setChild(int n, int n2, int n3) {
        assert (n2 == 0 || n2 == 1);
        this.edges[n * 3 + n2 + 1] = n3;
    }

    public void endTreeEditQuietly() {
        this.inEdit = false;
    }

    @Override
    public void setRoot(NodeRef nodeRef) {
        throw new RuntimeException("Cannot directly change the topology of a constrained tree! Please use a compatible operator");
    }

    public void setRootByForce(NodeRef nodeRef) {
        this.root = nodeRef.getNumber();
    }

    @Override
    public void addChild(NodeRef nodeRef, NodeRef nodeRef2) {
        throw new RuntimeException("Cannot directly change the toplogy of a constrained tree! Please use a compatible operator");
    }

    private void addChildByForce(NodeRef nodeRef, NodeRef nodeRef2) {
        this.addChildQuietlyByForce(nodeRef, nodeRef2);
        this.pushTreeChangedEvent(TreeChangedEvent.create(nodeRef, false));
        this.pushTreeChangedEvent(TreeChangedEvent.create(nodeRef2, false));
    }

    private void addChildQuietlyByForce(NodeRef nodeRef, NodeRef nodeRef2) {
        if (!this.inEdit) {
            throw new RuntimeException("Must be in edit transaction to call this method!");
        }
        int n = nodeRef.getNumber();
        int n2 = nodeRef2.getNumber();
        if (this.getChild(n, 0) == -1) {
            this.setChild(n, 0, n2);
        } else if (this.getChild(n, 1) == -1) {
            this.setChild(n, 1, n2);
        } else {
            throw new IllegalArgumentException("Node already has two children");
        }
        this.setParent(n2, n);
    }

    @Override
    public void removeChild(NodeRef nodeRef, NodeRef nodeRef2) {
        throw new RuntimeException("Cannot directly change the toplogy of a constrained tree! Please use a compatible operator");
    }

    private void removeChildQuietlyByForce(NodeRef nodeRef, NodeRef nodeRef2) {
        if (!this.inEdit) {
            throw new RuntimeException("Must be in edit transaction to call this method!");
        }
        int n = nodeRef.getNumber();
        int n2 = nodeRef2.getNumber();
        if (this.getChild(n, 0) == n2) {
            this.setChild(n, 0, -1);
            if (this.getChildCount(nodeRef) == 1) {
                this.setChild(n, 0, this.getChild(n, 1));
                this.setChild(n, 1, -1);
            }
        } else if (this.getChild(n, 1) == n2) {
            this.setChild(n, 1, -1);
        } else {
            throw new IllegalArgumentException("Child not in node");
        }
        this.setParent(n2, -1);
    }

    private void removeChildByForce(NodeRef nodeRef, NodeRef nodeRef2) {
        this.removeChildQuietlyByForce(nodeRef, nodeRef2);
        this.pushTreeChangedEvent(TreeChangedEvent.create(nodeRef, false));
        this.pushTreeChangedEvent(TreeChangedEvent.create(nodeRef2, false));
    }

    protected void clearTopology() {
        Arrays.fill(this.edges, -1);
    }

    @Override
    public void replaceChild(NodeRef nodeRef, NodeRef nodeRef2, NodeRef nodeRef3) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public boolean isTreeValid() {
        for (NodeRef nodeRef : this.nodes) {
            double d = this.getNodeHeight(nodeRef);
            if (!(d > this.getNodeHeightUpper(nodeRef)) && !(d < this.getNodeHeightLower(nodeRef))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setNodeHeight(NodeRef nodeRef, double d) {
        this.heights[nodeRef.getNumber()] = d;
        this.pushTreeChangedEvent(TreeChangedEvent.create(nodeRef, true));
    }

    @Override
    public void setNodeHeightQuietly(NodeRef nodeRef, double d) {
        this.heights[nodeRef.getNumber()] = d;
    }

    @Override
    public void setNodeRate(NodeRef nodeRef, double d) {
        throw new UnsupportedOperationException("BigFastTreeModel cannot have node rates set");
    }

    public void setNodeTrait(NodeRef nodeRef, String string, double d) {
        throw new UnsupportedOperationException("BigFastTreeModel cannot have traits set");
    }

    @Override
    public void setMultivariateTrait(NodeRef nodeRef, String string, double[] dArray) {
        throw new UnsupportedOperationException("BigFastTreeModel cannot have traits set");
    }

    @Override
    public void setBranchLength(NodeRef nodeRef, double d) {
        throw new UnsupportedOperationException("BigFastTreeModel cannot have branch lengths set");
    }

    @Override
    public void setNodeAttribute(NodeRef nodeRef, String string, Object object) {
        throw new UnsupportedOperationException("BigFastTreeModel does not use NodeAttributes");
    }

    @Override
    public void adoptTreeStructure(int[] nArray, double[] dArray, int[] nArray2, String[] stringArray) {
        int n;
        int n2;
        int[] nArray3 = this.createNodeMap(stringArray);
        if (this.nodeCount != nArray.length) {
            throw new RuntimeException("Incorrect number of edges provided: " + nArray.length + " versus " + this.nodeCount + " nodes.");
        }
        for (n2 = this.externalNodeCount; n2 < this.nodeCount; ++n2) {
            n = this.getChildCount(this.nodes[n2]);
            for (int i = 0; i < n; ++i) {
                this.removeChildByForce(this.nodes[n2], this.getChild(this.nodes[n2], 0));
            }
        }
        for (n2 = 0; n2 < this.getExternalNodeCount(); ++n2) {
            this.setNodeHeight(this.getExternalNode(nArray3[n2]), dArray[n2]);
        }
        for (n2 = 0; n2 < this.getExternalNodeCount() - 1; ++n2) {
            this.setNodeHeight(this.getInternalNode(n2), dArray[this.getExternalNodeCount() + n2]);
        }
        n2 = -1;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] != -1) {
                if (n < this.getExternalNodeCount()) {
                    this.addChildByForce(this.getNode(nArray[n]), this.getExternalNode(nArray3[n]));
                    System.out.println("external: " + nArray[n] + " > " + nArray3[n]);
                    continue;
                }
                this.addChildByForce(this.getNode(nArray[n]), this.getNode(n));
                System.out.println("internal: " + nArray[n] + " > " + n);
                continue;
            }
            n2 = n;
        }
        for (n = 0; n < nArray.length; ++n) {
            NodeRef nodeRef;
            NodeRef nodeRef2;
            NodeRef nodeRef3;
            if (nArray[n] == -1) continue;
            if (n < this.externalNodeCount) {
                if (nArray2[n] != 0 || this.getChild(this.nodes[nArray[n]], 0) == this.nodes[nArray3[n]]) continue;
                nodeRef3 = this.getNode(nArray[n]);
                nodeRef2 = this.getChild(nodeRef3, 0);
                nodeRef = this.getChild(nodeRef3, 1);
                this.removeChildByForce(nodeRef3, nodeRef2);
                this.removeChildByForce(nodeRef3, nodeRef);
                this.addChildByForce(nodeRef3, nodeRef);
                this.addChildByForce(nodeRef3, nodeRef2);
                continue;
            }
            if (nArray2[n] != 0 || this.getChild(this.nodes[nArray[n]], 0) == this.nodes[n]) continue;
            nodeRef3 = this.getNode(nArray[n]);
            nodeRef2 = this.getChild(nodeRef3, 0);
            nodeRef = this.getChild(nodeRef3, 1);
            this.removeChildByForce(nodeRef3, nodeRef2);
            this.removeChildByForce(nodeRef3, nodeRef);
            this.addChildByForce(nodeRef3, nodeRef);
            this.addChildByForce(nodeRef3, nodeRef2);
        }
        this.setRootByForce(this.nodes[n2]);
    }

    @Override
    protected void storeState() {
        System.arraycopy(this.edges, 0, this.storedEdges, 0, this.edges.length);
        System.arraycopy(this.heights, 0, this.storedHeights, 0, this.heights.length);
        this.storedRoot = this.root;
    }

    @Override
    protected void restoreState() {
        int[] nArray = this.storedEdges;
        this.storedEdges = this.edges;
        this.edges = nArray;
        double[] dArray = this.storedHeights;
        this.storedHeights = this.heights;
        this.heights = dArray;
        this.root = this.storedRoot;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Taxon getTaxon(int n) {
        return ((Node)this.getExternalNode(n)).taxon;
    }

    private static class Node
    implements NodeRef {
        private final Taxon taxon;
        private final int number;
        private int subtreeNumberIncludeRoots;
        private int subtreeNumberIncludeTips;
        private int subtreeNodeNumberIncludeRoots;
        private int subtreeNodeNumberIncludeTips;

        private Node(int n) {
            this(n, (Taxon)null);
        }

        private Node(int n, Taxon taxon) {
            this.number = n;
            this.taxon = taxon;
            this.subtreeNumberIncludeRoots = -1;
            this.subtreeNumberIncludeTips = -1;
            this.subtreeNodeNumberIncludeRoots = -1;
            this.subtreeNodeNumberIncludeTips = -1;
        }

        @Override
        public int getNumber() {
            return this.number;
        }

        @Override
        public void setNumber(int n) {
            throw new UnsupportedOperationException("Node is immutable");
        }

        public Taxon getTaxon() {
            return this.taxon;
        }

        private int getSubtreeNumber(SubtreeContext subtreeContext) {
            switch (subtreeContext) {
                case IncludeRoot: {
                    return this.subtreeNumberIncludeRoots;
                }
                case IncludeTips: {
                    return this.subtreeNumberIncludeTips;
                }
            }
            throw new IllegalArgumentException("unknown subtree number context");
        }

        private void setSubtreeNumber(int n, SubtreeContext subtreeContext) {
            switch (subtreeContext) {
                case IncludeRoot: {
                    if (this.subtreeNumberIncludeRoots != -1) {
                        throw new UnsupportedOperationException("Node is immutable");
                    }
                    this.subtreeNumberIncludeRoots = n;
                    break;
                }
                case IncludeTips: {
                    if (this.subtreeNumberIncludeTips != -1) {
                        throw new UnsupportedOperationException("Node is immutable");
                    }
                    this.subtreeNumberIncludeTips = n;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown subtree number context");
                }
            }
        }

        private int getSubtreeNodeNumber(SubtreeContext subtreeContext) {
            switch (subtreeContext) {
                case IncludeRoot: {
                    return this.subtreeNodeNumberIncludeRoots;
                }
                case IncludeTips: {
                    return this.subtreeNodeNumberIncludeTips;
                }
            }
            throw new IllegalArgumentException("unknown subtree number context");
        }

        private void setSubtreeNodeNumber(int n, SubtreeContext subtreeContext) {
            switch (subtreeContext) {
                case IncludeRoot: {
                    if (this.subtreeNodeNumberIncludeRoots != -1) {
                        throw new UnsupportedOperationException("Node is immutable");
                    }
                    this.subtreeNodeNumberIncludeRoots = n;
                    break;
                }
                case IncludeTips: {
                    if (this.subtreeNodeNumberIncludeTips != -1) {
                        throw new UnsupportedOperationException("Node is immutable");
                    }
                    this.subtreeNodeNumberIncludeTips = n;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown subtree number context");
                }
            }
        }
    }

    protected class WrappingSubtree
    extends TreeModel {
        public static final String WRAPPED_TREE_MODEL = "wrappedTreeModel";
        private final int root;
        private final ConstrainedTreeModel wrappedTree;
        private final Node[] nodes;
        private final int nodeCount;
        private final int externalNodeCount;
        private final int internalNodeCount;
        private final int number;

        public WrappingSubtree(String string, ConstrainedTreeModel constrainedTreeModel2, Set<NodeRef> set, int n) {
            NodeRef nodeRef2;
            super(string, constrainedTreeModel2.isVariable());
            this.setId(string);
            this.wrappedTree = constrainedTreeModel2;
            this.number = n;
            this.externalNodeCount = set.size();
            this.nodeCount = this.externalNodeCount * 2 - 1;
            this.internalNodeCount = this.nodeCount - this.externalNodeCount;
            this.nodes = new Node[this.nodeCount];
            int[] nArray = new int[this.externalNodeCount];
            int n2 = 0;
            for (NodeRef nodeRef2 : set) {
                this.nodes[n2] = new Node(n2, nodeRef2.getNumber());
                ((dr.evomodel.bigfasttree.thorney.ConstrainedTreeModel$Node)nodeRef2).setSubtreeNumber(n, SubtreeContext.IncludeTips);
                ((dr.evomodel.bigfasttree.thorney.ConstrainedTreeModel$Node)nodeRef2).setSubtreeNodeNumber(n2, SubtreeContext.IncludeTips);
                if (constrainedTreeModel2.isExternal(nodeRef2)) {
                    ((dr.evomodel.bigfasttree.thorney.ConstrainedTreeModel$Node)nodeRef2).setSubtreeNumber(n, SubtreeContext.IncludeRoot);
                    ((dr.evomodel.bigfasttree.thorney.ConstrainedTreeModel$Node)nodeRef2).setSubtreeNodeNumber(n2, SubtreeContext.IncludeRoot);
                }
                nArray[n2] = nodeRef2.getNumber();
                ++n2;
            }
            NodeRef nodeRef3 = TreeUtils.getCommonAncestor(constrainedTreeModel2, nArray);
            nodeRef2 = new Node(n2, nodeRef3.getNumber());
            this.nodes[n2] = nodeRef2;
            this.root = n2;
            ((dr.evomodel.bigfasttree.thorney.ConstrainedTreeModel$Node)nodeRef3).setSubtreeNumber(n, SubtreeContext.IncludeRoot);
            ((dr.evomodel.bigfasttree.thorney.ConstrainedTreeModel$Node)nodeRef3).setSubtreeNodeNumber(n2, SubtreeContext.IncludeRoot);
            ++n2;
            for (int i = 0; i < constrainedTreeModel2.getChildCount(nodeRef3); ++i) {
                NodeRef nodeRef4 = constrainedTreeModel2.getChild(nodeRef3, i);
                n2 = this.traverseAndSetup(constrainedTreeModel2, nodeRef4, set, n2);
            }
        }

        public WrappingSubtree(ConstrainedTreeModel constrainedTreeModel2, Set<NodeRef> set, int n) {
            this(WRAPPED_TREE_MODEL, constrainedTreeModel2, set, n);
        }

        private int traverseAndSetup(Tree tree, NodeRef nodeRef, Set<NodeRef> set, int n) {
            if (tree.isExternal(nodeRef) && !set.contains(nodeRef)) {
                throw new IllegalArgumentException("Wrapped paraphyletic wrapped trees are not supported");
            }
            if (!set.contains(nodeRef)) {
                this.nodes[n] = new Node(n, nodeRef.getNumber());
                ((dr.evomodel.bigfasttree.thorney.ConstrainedTreeModel$Node)nodeRef).setSubtreeNumber(this.number, SubtreeContext.IncludeTips);
                ((dr.evomodel.bigfasttree.thorney.ConstrainedTreeModel$Node)nodeRef).setSubtreeNodeNumber(n, SubtreeContext.IncludeTips);
                ((dr.evomodel.bigfasttree.thorney.ConstrainedTreeModel$Node)nodeRef).setSubtreeNumber(this.number, SubtreeContext.IncludeRoot);
                ((dr.evomodel.bigfasttree.thorney.ConstrainedTreeModel$Node)nodeRef).setSubtreeNodeNumber(n, SubtreeContext.IncludeRoot);
                ++n;
                for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
                    n = this.traverseAndSetup(tree, tree.getChild(nodeRef, i), set, n);
                }
            }
            return n;
        }

        public NodeRef getNodeInWrappedTree(NodeRef nodeRef) {
            return this.wrappedTree.getNode(((Node)nodeRef).baseNodeNumber);
        }

        protected NodeRef getWrappingNode(NodeRef nodeRef, SubtreeContext subtreeContext) {
            int n = ((dr.evomodel.bigfasttree.thorney.ConstrainedTreeModel$Node)nodeRef).getSubtreeNodeNumber(subtreeContext);
            return this.nodes[n];
        }

        @Override
        public void addChild(NodeRef nodeRef, NodeRef nodeRef2) {
            NodeRef nodeRef3 = this.getNodeInWrappedTree(nodeRef);
            NodeRef nodeRef4 = this.getNodeInWrappedTree(nodeRef2);
            if (this.isRoot(nodeRef2)) {
                NodeRef nodeRef5 = this.wrappedTree.getParent(nodeRef4);
                this.wrappedTree.removeChildByForce(nodeRef5, nodeRef4);
            }
            this.wrappedTree.addChildByForce(nodeRef3, nodeRef4);
        }

        public void addChildQuietly(NodeRef nodeRef, NodeRef nodeRef2) {
            NodeRef nodeRef3 = this.getNodeInWrappedTree(nodeRef);
            NodeRef nodeRef4 = this.getNodeInWrappedTree(nodeRef2);
            if (this.isRoot(nodeRef2)) {
                NodeRef nodeRef5 = this.wrappedTree.getParent(nodeRef4);
                this.wrappedTree.removeChildQuietlyByForce(nodeRef5, nodeRef4);
            }
            this.wrappedTree.addChildQuietlyByForce(nodeRef3, nodeRef4);
        }

        @Override
        public void removeChild(NodeRef nodeRef, NodeRef nodeRef2) {
            NodeRef nodeRef3 = this.getNodeInWrappedTree(nodeRef);
            NodeRef nodeRef4 = this.getNodeInWrappedTree(nodeRef2);
            this.wrappedTree.removeChildByForce(nodeRef3, nodeRef4);
        }

        public void removeChildQuietly(NodeRef nodeRef, NodeRef nodeRef2) {
            NodeRef nodeRef3 = this.getNodeInWrappedTree(nodeRef);
            NodeRef nodeRef4 = this.getNodeInWrappedTree(nodeRef2);
            this.wrappedTree.removeChildQuietlyByForce(nodeRef3, nodeRef4);
        }

        @Override
        public void replaceChild(NodeRef nodeRef, NodeRef nodeRef2, NodeRef nodeRef3) {
            NodeRef nodeRef4 = this.getNodeInWrappedTree(nodeRef);
            NodeRef nodeRef5 = this.getNodeInWrappedTree(nodeRef2);
            NodeRef nodeRef6 = this.getNodeInWrappedTree(nodeRef3);
            this.wrappedTree.replaceChild(nodeRef4, nodeRef5, nodeRef6);
        }

        @Override
        public void setNodeHeight(NodeRef nodeRef, double d) {
            NodeRef nodeRef2 = this.getNodeInWrappedTree(nodeRef);
            this.wrappedTree.setNodeHeight(nodeRef2, d);
        }

        @Override
        public void setNodeRate(NodeRef nodeRef, double d) {
            NodeRef nodeRef2 = this.getNodeInWrappedTree(nodeRef);
            this.wrappedTree.setNodeRate(nodeRef2, d);
        }

        @Override
        public void setNodeAttribute(NodeRef nodeRef, String string, Object object) {
            NodeRef nodeRef2 = this.getNodeInWrappedTree(nodeRef);
            this.wrappedTree.setNodeAttribute(nodeRef2, string, object);
        }

        @Override
        public void setMultivariateTrait(NodeRef nodeRef, String string, double[] dArray) {
            NodeRef nodeRef2 = this.getNodeInWrappedTree(nodeRef);
            this.wrappedTree.setMultivariateTrait(nodeRef2, string, dArray);
        }

        @Override
        public void adoptTreeStructure(int[] nArray, double[] dArray, int[] nArray2, String[] stringArray) {
        }

        @Override
        public boolean isTreeValid() {
            return this.wrappedTree.isTreeValid();
        }

        @Override
        public void setRoot(NodeRef nodeRef) {
            throw new UnsupportedOperationException("wrapped trees can not change roots, yet");
        }

        @Override
        public NodeRef getRoot() {
            return this.getNode(this.root);
        }

        @Override
        public boolean isRoot(NodeRef nodeRef) {
            return nodeRef.getNumber() == this.root;
        }

        @Override
        public void setNodeHeightQuietly(NodeRef nodeRef, double d) {
            NodeRef nodeRef2 = this.getNodeInWrappedTree(nodeRef);
            this.wrappedTree.setNodeHeightQuietly(nodeRef2, d);
        }

        @Override
        protected void handleModelChangedEvent(Model model, Object object, int n) {
        }

        @Override
        protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        }

        @Override
        protected void acceptState() {
        }

        @Override
        public void setBranchLength(NodeRef nodeRef, double d) {
            throw new UnsupportedOperationException("WrappedTreeModels cannot have branch lengths set");
        }

        @Override
        public double[] getMultivariateNodeTrait(NodeRef nodeRef, String string) {
            NodeRef nodeRef2 = this.getNodeInWrappedTree(nodeRef);
            return this.wrappedTree.getMultivariateNodeTrait(nodeRef2, string);
        }

        @Override
        public int getNodeCount() {
            return this.nodeCount;
        }

        @Override
        public NodeRef getNode(int n) {
            return this.nodes[n];
        }

        @Override
        public NodeRef getInternalNode(int n) {
            return this.nodes[this.externalNodeCount + n];
        }

        @Override
        public NodeRef getExternalNode(int n) {
            return this.nodes[n];
        }

        @Override
        public int getExternalNodeCount() {
            return this.externalNodeCount;
        }

        @Override
        public int getInternalNodeCount() {
            return this.internalNodeCount;
        }

        @Override
        public Taxon getNodeTaxon(NodeRef nodeRef) {
            NodeRef nodeRef2 = this.getNodeInWrappedTree(nodeRef);
            return this.wrappedTree.getNodeTaxon(nodeRef2);
        }

        @Override
        public double getNodeHeight(NodeRef nodeRef) {
            NodeRef nodeRef2 = this.getNodeInWrappedTree(nodeRef);
            return this.wrappedTree.getNodeHeight(nodeRef2);
        }

        @Override
        public double getNodeRate(NodeRef nodeRef) {
            NodeRef nodeRef2 = this.getNodeInWrappedTree((Node)nodeRef);
            return this.wrappedTree.getNodeRate(nodeRef2);
        }

        @Override
        public Object getNodeAttribute(NodeRef nodeRef, String string) {
            NodeRef nodeRef2 = this.getNodeInWrappedTree((Node)nodeRef);
            return this.wrappedTree.getNodeAttribute(nodeRef2, string);
        }

        @Override
        public Iterator getNodeAttributeNames(NodeRef nodeRef) {
            NodeRef nodeRef2 = this.getNodeInWrappedTree((Node)nodeRef);
            return this.wrappedTree.getNodeAttributeNames(nodeRef2);
        }

        @Override
        public boolean isExternal(NodeRef nodeRef) {
            return nodeRef.getNumber() < this.externalNodeCount;
        }

        @Override
        public int getChildCount(NodeRef nodeRef) {
            if (this.isExternal(nodeRef)) {
                return 0;
            }
            return this.wrappedTree.getChildCount(this.getNodeInWrappedTree(nodeRef));
        }

        @Override
        public NodeRef getChild(NodeRef nodeRef, int n) {
            if (this.isExternal(nodeRef)) {
                throw new IllegalArgumentException("Attempted to access a child of an external node in a wrapped tree");
            }
            NodeRef nodeRef2 = this.getNodeInWrappedTree(nodeRef);
            NodeRef nodeRef3 = this.wrappedTree.getChild(nodeRef2, n);
            return this.getWrappingNode(nodeRef3, SubtreeContext.IncludeTips);
        }

        @Override
        public NodeRef getParent(NodeRef nodeRef) {
            if (this.isRoot(nodeRef)) {
                return null;
            }
            NodeRef nodeRef2 = this.getNodeInWrappedTree(nodeRef);
            NodeRef nodeRef3 = this.wrappedTree.getParent(nodeRef2);
            return this.getWrappingNode(nodeRef3, SubtreeContext.IncludeRoot);
        }

        @Override
        public Taxon getTaxon(int n) {
            int n2 = this.nodes[n].baseNodeNumber;
            return this.wrappedTree.getTaxon(n2);
        }

        @Override
        public NodeRef[] getNodes() {
            return this.nodes;
        }

        @Override
        public boolean beginTreeEdit() {
            this.wrappedTree.beginTreeEdit();
            return super.beginTreeEdit();
        }

        @Override
        public void endTreeEdit() {
            this.wrappedTree.endTreeEdit();
            super.endTreeEdit();
        }

        @Override
        protected void storeState() {
        }

        @Override
        protected void restoreState() {
        }

        private class Node
        implements NodeRef {
            public final int number;
            public final int baseNodeNumber;

            private Node(int n, int n2) {
                this.number = n;
                this.baseNodeNumber = n2;
            }

            @Override
            public int getNumber() {
                return this.number;
            }

            @Override
            public void setNumber(int n) {
                throw new UnsupportedOperationException("Node is immutable");
            }

            public int getBaseNodeNumber() {
                return this.baseNodeNumber;
            }
        }
    }

    protected static enum SubtreeContext {
        IncludeRoot,
        IncludeTips;

    }
}

