/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.ExponentialGrowth;
import dr.evolution.util.Units;
import dr.evomodel.epidemiology.LambertW;

public class LogisticGrowthN0
extends ExponentialGrowth {
    private double t50;

    public LogisticGrowthN0(Units.Type type) {
        super(type);
    }

    public void setT50(double d) {
        this.t50 = d;
    }

    public double getT50() {
        return this.t50;
    }

    @Override
    public double getDemographic(double d) {
        double d2 = this.getN0();
        double d3 = this.getGrowthRate();
        double d4 = this.getT50();
        return d2 * (1.0 + Math.exp(-d3 * d4)) / (1.0 + Math.exp(-d3 * (d4 - d)));
    }

    @Override
    public double getLogDemographic(double d) {
        return Math.log(this.getDemographic(d));
    }

    @Override
    public double getIntensity(double d) {
        double d2 = this.getN0();
        double d3 = this.getGrowthRate();
        double d4 = this.getT50();
        double d5 = Math.exp(-d3 * d4);
        return (d + d5 * (Math.exp(d3 * d) - 1.0) / d3) / (d2 * (1.0 + d5));
    }

    @Override
    public double getInverseIntensity(double d) {
        double d2;
        double d3 = -this.getGrowthRate();
        double d4 = this.getT50();
        double d5 = this.getN0();
        double d6 = d3 / Math.exp(d3 * d4);
        double d7 = d5 * (1.0 + Math.exp(d3 * d4)) * d - 1.0 / d3 * Math.exp(d3 * d4);
        double d8 = d3 * Math.exp(-d3 * d7) / d6;
        if (d8 == Double.POSITIVE_INFINITY) {
            double d9 = d3 * d4 - d3 * d7;
            d2 = d9 - Math.log(d9);
        } else {
            d2 = LambertW.branch0(d8);
        }
        return d7 + 1.0 / d3 * d2;
    }

    @Override
    public double getIntegral(double d, double d2) {
        return this.getIntensity(d2) - this.getIntensity(d);
    }

    @Override
    public int getNumArguments() {
        return 3;
    }

    @Override
    public String getArgumentName(int n) {
        switch (n) {
            case 0: {
                return "N0";
            }
            case 1: {
                return "r";
            }
            case 2: {
                return "t50";
            }
        }
        throw new IllegalArgumentException("Argument " + n + " does not exist");
    }

    @Override
    public double getArgument(int n) {
        switch (n) {
            case 0: {
                return this.getN0();
            }
            case 1: {
                return this.getGrowthRate();
            }
            case 2: {
                return this.getT50();
            }
        }
        throw new IllegalArgumentException("Argument " + n + " does not exist");
    }

    @Override
    public void setArgument(int n, double d) {
        switch (n) {
            case 0: {
                this.setN0(d);
                break;
            }
            case 1: {
                this.setGrowthRate(d);
                break;
            }
            case 2: {
                this.setT50(d);
                break;
            }
            default: {
                throw new IllegalArgumentException("Argument " + n + " does not exist");
            }
        }
    }

    @Override
    public double getLowerBound(int n) {
        return 0.0;
    }

    @Override
    public double getUpperBound(int n) {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public DemographicFunction getCopy() {
        LogisticGrowthN0 logisticGrowthN0 = new LogisticGrowthN0(this.getUnits());
        logisticGrowthN0.setN0(this.getN0());
        logisticGrowthN0.setGrowthRate(this.getGrowthRate());
        logisticGrowthN0.setT50(this.getT50());
        return logisticGrowthN0;
    }
}

