/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.trace;

import dr.inference.trace.LogFileTraces;
import dr.inference.trace.MarginalLikelihoodAnalysis;
import dr.inference.trace.TraceCorrelation;
import dr.inference.trace.TraceDistribution;
import dr.inference.trace.TraceException;
import dr.inference.trace.TraceList;
import dr.inference.trace.TraceTypeUtils;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;

public class TraceAnalysis {
    static final String[] colNamesNumeric = new String[]{"mean", "stderr_of_mean", "stdev", "variance", "median", "min", "max", "quantile1", "quantile3", "95_hpd_lower", "95_hpd_upper", "ACT", "ESS", "num_samples", "geometric_mean"};
    static final String[] colNamesCategorical = new String[]{"mode", "mode_frequency", "mode_probability", "unique_values", "95_credible_set"};

    public static LogFileTraces analyzeLogFile(String string, long l) throws IOException, TraceException {
        File file = new File(string);
        LogFileTraces logFileTraces = new LogFileTraces(string, file);
        logFileTraces.loadTraces();
        logFileTraces.setBurnIn(l);
        for (int i = 0; i < logFileTraces.getTraceCount(); ++i) {
            logFileTraces.analyseTrace(i);
        }
        return logFileTraces;
    }

    public static TraceList report(String string) throws IOException, TraceException {
        return TraceAnalysis.report(string, -1, null);
    }

    public static TraceList report(String string, int n, String string2) throws IOException, TraceException {
        return TraceAnalysis.report(string, n, string2, true);
    }

    public static TraceList report(String string, int n, String string2, boolean bl) throws IOException, TraceException {
        int n2;
        File file = new File(string);
        LogFileTraces logFileTraces = new LogFileTraces(string, file);
        logFileTraces.loadTraces();
        int n3 = n;
        if (n3 == -1) {
            n3 = (int)(logFileTraces.getMaxState() / 10L);
        }
        logFileTraces.setBurnIn(n3);
        System.out.println("burnIn   <= " + n3 + ",   maxState  = " + logFileTraces.getMaxState());
        System.out.print("statistic");
        String[] stringArray = !bl ? new String[]{"mean", "hpdLower", "hpdUpper", "ESS"} : new String[]{"mean", "stdErr", "median", "hpdLower", "hpdUpper", "ESS", "50hpdLower", "50hpdUpper"};
        String[] stringArray2 = stringArray;
        int n4 = stringArray2.length;
        for (n2 = 0; n2 < n4; ++n2) {
            String string3 = stringArray2[n2];
            System.out.print("\t" + string3);
        }
        System.out.println();
        int n5 = 0;
        for (n4 = 0; n4 < logFileTraces.getTraceCount(); ++n4) {
            logFileTraces.analyseTrace(n4);
            TraceCorrelation traceCorrelation = logFileTraces.getCorrelationStatistics(n4);
            double d = traceCorrelation.getESS();
            System.out.print(logFileTraces.getTraceName(n4));
            System.out.print("\t" + TraceAnalysis.formattedNumber(traceCorrelation.getMean()));
            if (bl) {
                System.out.print("\t" + TraceAnalysis.formattedNumber(traceCorrelation.getStdError()));
                System.out.print("\t" + TraceAnalysis.formattedNumber(traceCorrelation.getMedian()));
            }
            System.out.print("\t" + TraceAnalysis.formattedNumber(traceCorrelation.getLowerHPD()));
            System.out.print("\t" + TraceAnalysis.formattedNumber(traceCorrelation.getUpperHPD()));
            System.out.print("\t" + TraceAnalysis.formattedNumber(d));
            if (bl) {
                System.out.print("\t" + TraceAnalysis.formattedNumber(traceCorrelation.getHpdLowerCustom()));
                System.out.print("\t" + TraceAnalysis.formattedNumber(traceCorrelation.getHpdUpperCustom()));
            }
            if (d < 100.0) {
                ++n5;
                System.out.println("\t*");
                continue;
            }
            System.out.println("\t");
        }
        System.out.println();
        if (n5 > 0) {
            System.out.println(" * WARNING: The results of this MCMC analysis may be invalid as ");
            System.out.println("            one or more statistics had very low effective sample sizes (ESS)");
        }
        if (string2 != null) {
            System.out.println();
            n4 = -1;
            for (n2 = 0; n2 < logFileTraces.getTraceCount(); ++n2) {
                String string4 = logFileTraces.getTraceName(n2);
                if (!string4.equals(string2)) continue;
                n4 = n2;
                break;
            }
            if (n4 == -1) {
                throw new TraceException("Column '" + string2 + "' can not be found for marginal likelihood analysis.");
            }
            String string5 = "aicm";
            int n6 = 1000;
            List<Double> list = logFileTraces.getValues(n4);
            MarginalLikelihoodAnalysis marginalLikelihoodAnalysis = new MarginalLikelihoodAnalysis(list, logFileTraces.getTraceName(n4), n3, string5, n6);
            System.out.println(marginalLikelihoodAnalysis.toString());
        }
        System.out.flush();
        return logFileTraces;
    }

    public static void reportTrace(String string, long l, String string2) throws IOException, TraceException {
        File file = new File(string);
        LogFileTraces logFileTraces = new LogFileTraces(string, file);
        logFileTraces.loadTraces();
        long l2 = l;
        if (l2 == -1L) {
            l2 = logFileTraces.getMaxState() / 10L;
        }
        logFileTraces.setBurnIn(l2);
        int n = logFileTraces.getTraceIndex(string2);
        logFileTraces.analyseTrace(n);
        TraceCorrelation traceCorrelation = logFileTraces.getCorrelationStatistics(n);
        double d = traceCorrelation.getESS();
        System.out.print(TraceAnalysis.formattedNumber(traceCorrelation.getMean()) + "\t");
        System.out.print(TraceAnalysis.formattedNumber(traceCorrelation.getStdError()) + "\t");
        System.out.print(TraceAnalysis.formattedNumber(traceCorrelation.getMedian()) + "\t");
        System.out.print(TraceAnalysis.formattedNumber(traceCorrelation.getLowerHPD()) + "\t");
        System.out.print(TraceAnalysis.formattedNumber(traceCorrelation.getUpperHPD()) + "\t");
        System.out.print(TraceAnalysis.formattedNumber(traceCorrelation.getHpdLowerCustom()) + "\t");
        System.out.print(TraceAnalysis.formattedNumber(traceCorrelation.getHpdUpperCustom()) + "\t");
        System.out.println();
    }

    public static TraceList shortReport(String string, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string2) throws IOException, TraceException {
        Object object;
        int n2;
        LogFileTraces logFileTraces = TraceAnalysis.analyzeLogFile(string, n);
        long l = logFileTraces.getMaxState();
        double d = Double.MAX_VALUE;
        if (bl) {
            System.out.print("file\t");
            for (n2 = 0; n2 < logFileTraces.getTraceCount(); ++n2) {
                object = logFileTraces.getTraceName(n2);
                System.out.print((String)object + "\t");
                if (bl4) {
                    System.out.print((String)object + " stdErr\t");
                }
                if (bl2) {
                    System.out.print((String)object + " hpdLower\t");
                    System.out.print((String)object + " hpdUpper\t");
                }
                if (!bl3) continue;
                System.out.print((String)object + " ESS\t");
            }
            System.out.print("minESS\t");
            if (string2 != null) {
                System.out.print("marginal likelihood\t");
                System.out.print("stdErr\t");
            }
            System.out.println("chainLength");
        }
        System.out.print(string + "\t");
        for (n2 = 0; n2 < logFileTraces.getTraceCount(); ++n2) {
            double d2;
            object = logFileTraces.getCorrelationStatistics(n2);
            System.out.print(((TraceDistribution)object).getMean() + "\t");
            if (bl4) {
                System.out.print(((TraceCorrelation)object).getStdErrorOfMean() + "\t");
            }
            if (bl2) {
                System.out.print(((TraceDistribution)object).getLowerHPD() + "\t");
                System.out.print(((TraceDistribution)object).getUpperHPD() + "\t");
            }
            if (bl3) {
                System.out.print(((TraceCorrelation)object).getESS() + "\t");
            }
            if (!((d2 = ((TraceCorrelation)object).getESS()) < d)) continue;
            d = d2;
        }
        System.out.print(d + "\t");
        if (string2 != null) {
            n2 = -1;
            for (int i = 0; i < logFileTraces.getTraceCount(); ++i) {
                String string3 = logFileTraces.getTraceName(i);
                if (!string3.equals(string2)) continue;
                n2 = i;
                break;
            }
            if (n2 == -1) {
                throw new TraceException("Column '" + string2 + "' can not be found in file " + string + ".");
            }
            String string4 = "aicm";
            int n3 = 1000;
            List<Double> list = logFileTraces.getValues(n2);
            MarginalLikelihoodAnalysis marginalLikelihoodAnalysis = new MarginalLikelihoodAnalysis(list, logFileTraces.getTraceName(n2), n, string4, n3);
            System.out.print(marginalLikelihoodAnalysis.getLogMarginalLikelihood() + "\t");
            System.out.print(marginalLikelihoodAnalysis.getBootstrappedSE() + "\t");
        }
        System.out.println(l);
        return logFileTraces;
    }

    public static String formattedNumber(double d) {
        DecimalFormat decimalFormat = new DecimalFormat("0.####E0");
        DecimalFormat decimalFormat2 = new DecimalFormat("####0.####");
        if (d > 0.0 && (Math.abs(d) < 0.01 || Math.abs(d) >= 100000.0)) {
            return decimalFormat.format(d);
        }
        return decimalFormat2.format(d);
    }

    public static String formattedNumber(double d, int n) {
        String string = "####0.";
        for (int i = 0; i < n; ++i) {
            string = string + "#";
        }
        return new DecimalFormat(string).format(d);
    }

    public static String getStatisticSummary(List<TraceList> list) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = colNamesNumeric;
        if (TraceTypeUtils.anyCategorical(list, null)) {
            stringArray = new String[colNamesNumeric.length + colNamesCategorical.length];
            System.arraycopy(colNamesNumeric, 0, stringArray, 0, colNamesNumeric.length);
            System.arraycopy(colNamesCategorical, 0, stringArray, colNamesNumeric.length, colNamesCategorical.length);
        }
        for (int i = 0; i < list.size(); ++i) {
            String string;
            int n;
            TraceList traceList = list.get(i);
            String string2 = "";
            if (list.size() > 1) {
                string2 = traceList.getName() + ".";
                if ((string2 = string2.replaceAll("\\s+", "")).contains(".txt") || string2.contains(".log")) {
                    string2 = string2.replaceAll("\\.txt|\\.log", "");
                }
            }
            if (i == 0) {
                String[] stringArray2 = stringArray;
                int n2 = stringArray2.length;
                for (n = 0; n < n2; ++n) {
                    string = stringArray2[n];
                    stringBuffer.append("\t");
                    stringBuffer.append(string);
                }
                stringBuffer.append("\n");
            }
            for (int j = 0; j < traceList.getTraceCount(); ++j) {
                stringBuffer.append(string2 + traceList.getTrace(j).getName());
                TraceCorrelation traceCorrelation = traceList.getCorrelationStatistics(j);
                for (n = 0; n < stringArray.length; ++n) {
                    stringBuffer.append("\t");
                    string = TraceAnalysis.getStatistic(n, traceCorrelation);
                    stringBuffer.append(string);
                }
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    private static String getStatistic(int n, TraceCorrelation traceCorrelation) {
        if (traceCorrelation == null) {
            return "";
        }
        if (traceCorrelation.getTraceType().isContinuous() && n >= colNamesNumeric.length) {
            return "";
        }
        if (traceCorrelation.getTraceType().isCategorical() && n < colNamesNumeric.length) {
            return "";
        }
        Object object = null;
        switch (n) {
            case 0: {
                object = traceCorrelation.getMean();
                break;
            }
            case 1: {
                object = traceCorrelation.getStdErrorOfMean();
                break;
            }
            case 2: {
                object = traceCorrelation.getStdError();
                break;
            }
            case 3: {
                object = traceCorrelation.getVariance();
                break;
            }
            case 4: {
                object = traceCorrelation.getMedian();
                break;
            }
            case 5: {
                object = traceCorrelation.getMinimum();
                break;
            }
            case 6: {
                object = traceCorrelation.getMaximum();
                break;
            }
            case 7: {
                object = traceCorrelation.getQ1();
                break;
            }
            case 8: {
                object = traceCorrelation.getQ3();
                break;
            }
            case 9: {
                object = traceCorrelation.getLowerHPD();
                break;
            }
            case 10: {
                object = traceCorrelation.getUpperHPD();
                break;
            }
            case 11: {
                object = traceCorrelation.getACT();
                break;
            }
            case 12: {
                object = traceCorrelation.getESS();
                break;
            }
            case 13: {
                object = traceCorrelation.getSize();
                break;
            }
            case 14: {
                if (!traceCorrelation.hasGeometricMean()) {
                    return "";
                }
                object = traceCorrelation.getGeometricMean();
                break;
            }
            case 15: {
                object = Integer.toString(traceCorrelation.getMode());
                break;
            }
            case 16: {
                object = traceCorrelation.getFrequencyOfMode();
                break;
            }
            case 17: {
                object = traceCorrelation.getProbabilityOfMode();
                break;
            }
            case 18: {
                object = traceCorrelation.getCredibleSet().toString();
                break;
            }
            case 19: {
                object = traceCorrelation.getCredibleSet().toString();
            }
        }
        if (object == null) {
            return "";
        }
        if (object instanceof Double && Double.isNaN((Double)object)) {
            return "";
        }
        return object.toString();
    }
}

