/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.utilities;

import ec.tstoolkit.BaseException;
import ec.tstoolkit.information.Information;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetSerializable;
import ec.tstoolkit.utilities.IModifiable;
import ec.tstoolkit.utilities.INameValidator;
import ec.tstoolkit.utilities.NameKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class NameManager<T>
implements InformationSetSerializable,
IModifiable {
    private final String prefix_;
    private boolean dirty_;
    private final HashMap<String, T> tdic_ = new HashMap();
    private final HashMap<T, NameKey> ndic_ = new HashMap();
    private final HashMap<String, Integer> locks_ = new HashMap();
    private final Class<T> tclass_;
    private final INameValidator validator_;

    public NameManager(Class<T> tclass, String prefix, INameValidator validator) {
        this.tclass_ = tclass;
        this.prefix_ = prefix;
        this.validator_ = validator;
    }

    public String getLastNameError() {
        return this.validator_ == null ? null : this.validator_.getLastError();
    }

    public INameValidator getNameValidator() {
        return this.validator_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        HashMap<String, T> hashMap = this.tdic_;
        synchronized (hashMap) {
            if (this.tdic_.isEmpty()) {
                return;
            }
            if (this.locks_.isEmpty()) {
                this.tdic_.clear();
                this.ndic_.clear();
            } else {
                String[] names;
                for (String n : names = this.unlockedNames()) {
                    T obj = this.tdic_.get(n);
                    this.ndic_.remove(obj);
                    this.tdic_.remove(n);
                }
            }
            this.dirty_ = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(String name) {
        HashMap<String, T> hashMap = this.tdic_;
        synchronized (hashMap) {
            if (!this.tdic_.containsKey(name)) {
                throw new BaseException("Unknown name");
            }
            Integer n = this.locks_.get(name);
            if (n == null) {
                this.locks_.put(name, 1);
            } else {
                this.locks_.put(name, n + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(String name) {
        HashMap<String, T> hashMap = this.tdic_;
        synchronized (hashMap) {
            if (!this.tdic_.containsKey(name)) {
                throw new BaseException("Unknown name");
            }
            Integer n = this.locks_.get(name);
            if (n != null) {
                if (n == 1) {
                    this.locks_.remove(name);
                } else {
                    this.locks_.put(name, n - 1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        HashMap<String, T> hashMap = this.tdic_;
        synchronized (hashMap) {
            this.locks_.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked(String name) {
        HashMap<String, T> hashMap = this.tdic_;
        synchronized (hashMap) {
            return this.locks_.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> variables() {
        HashMap<String, T> hashMap = this.tdic_;
        synchronized (hashMap) {
            return this.tdic_.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        HashMap<String, T> hashMap = this.tdic_;
        synchronized (hashMap) {
            return this.tdic_.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(String name) {
        HashMap<String, T> hashMap = this.tdic_;
        synchronized (hashMap) {
            return this.tdic_.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(T obj) {
        HashMap<String, T> hashMap = this.tdic_;
        synchronized (hashMap) {
            NameKey nk = this.ndic_.get(obj);
            if (nk != null) {
                return nk.name;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rename(String item, String newname) {
        if (this.validator_ != null && !this.validator_.accept(newname)) {
            throw new BaseException(this.validator_.getLastError());
        }
        HashMap<String, T> hashMap = this.tdic_;
        synchronized (hashMap) {
            if (this.tdic_.containsKey(newname)) {
                return false;
            }
            if (this.locks_.containsKey(item)) {
                return false;
            }
            T var = this.tdic_.get(item);
            if (var == null) {
                return false;
            }
            this.tdic_.remove(item);
            this.tdic_.put(newname, var);
            NameKey nk = this.ndic_.get(var);
            nk.name = newname;
            this.dirty_ = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String name, T var) {
        if (this.validator_ != null && !this.validator_.accept(name)) {
            throw new BaseException(this.validator_.getLastError());
        }
        HashMap<String, T> hashMap = this.tdic_;
        synchronized (hashMap) {
            T cur = this.tdic_.get(name);
            if (cur != null) {
                if (var == cur) {
                    return;
                }
                throw new BaseException("Name already in use");
            }
            NameKey curname = this.ndic_.get(var);
            if (curname != null) {
                if (this.locks_.containsKey(curname.name)) {
                    throw new BaseException("Locked object");
                }
                this.tdic_.remove(curname.name);
                this.tdic_.put(name, var);
                curname.name = name;
                this.dirty_ = true;
            } else {
                this.tdic_.put(name, var);
                this.ndic_.put(var, new NameKey(name));
                this.dirty_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String nextName() {
        String name;
        int id = 1;
        HashMap<String, T> hashMap = this.tdic_;
        synchronized (hashMap) {
            do {
                name = this.prefix_ + Integer.toString(id);
                ++id;
            } while (this.tdic_.containsKey(name));
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String name) {
        HashMap<String, T> hashMap = this.tdic_;
        synchronized (hashMap) {
            return this.tdic_.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(T obj) {
        HashMap<String, T> hashMap = this.tdic_;
        synchronized (hashMap) {
            return this.ndic_.containsKey(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String name) {
        HashMap<String, T> hashMap = this.tdic_;
        synchronized (hashMap) {
            if (this.locks_.containsKey(name)) {
                return false;
            }
            T obj = this.tdic_.get(name);
            if (obj == null) {
                return false;
            }
            this.tdic_.remove(name);
            this.ndic_.remove(obj);
            this.dirty_ = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T obj) {
        HashMap<String, T> hashMap = this.tdic_;
        synchronized (hashMap) {
            NameKey nk = this.ndic_.get(obj);
            if (nk == null) {
                return false;
            }
            if (this.locks_.containsKey(nk.name)) {
                return false;
            }
            this.tdic_.remove(nk.name);
            this.ndic_.remove(obj);
            this.dirty_ = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getNames() {
        HashMap<String, T> hashMap = this.tdic_;
        synchronized (hashMap) {
            return NameKey.sort(this.ndic_.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] unlockedNames() {
        HashMap<String, T> hashMap = this.tdic_;
        synchronized (hashMap) {
            ArrayList<NameKey> names = new ArrayList<NameKey>();
            for (NameKey n : this.ndic_.values()) {
                if (this.locks_.containsKey(n.name)) continue;
                names.add(n);
            }
            return NameKey.sort(names);
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty_;
    }

    @Override
    public void resetDirty() {
        this.dirty_ = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InformationSet write(boolean verbose) {
        HashMap<String, T> hashMap = this.tdic_;
        synchronized (hashMap) {
            InformationSet info = new InformationSet();
            String[] names = this.getNames();
            for (int i = 0; i < names.length; ++i) {
                info.set(names[i], this.tdic_.get(names[i]));
            }
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean read(InformationSet info) {
        HashMap<String, T> hashMap = this.tdic_;
        synchronized (hashMap) {
            List<Information<T>> sel = info.select(this.tclass_);
            for (Information<T> item : sel) {
                this.tdic_.put(item.name, item.value);
                this.ndic_.put(item.value, new NameKey(item.name));
            }
            return true;
        }
    }
}

