/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.text;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Array;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Taxonomy;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.text.PMMLElements;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="TextDictionary", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "taxonomy", "array"})
@JsonRootName(value="TextDictionary")
@JsonPropertyOrder(value={"extensions", "taxonomy", "array"})
public class TextDictionary
extends PMMLObject
implements HasExtensions<TextDictionary> {
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    @XmlElement(name="Taxonomy", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Taxonomy")
    private Taxonomy taxonomy;
    @XmlElement(name="Array", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Array")
    private Array array;
    private static final long serialVersionUID = 67371275L;

    public TextDictionary() {
    }

    @ValueConstructor
    public TextDictionary(@Property(value="array") Array array) {
        this.array = array;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public TextDictionary addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public Taxonomy getTaxonomy() {
        return this.taxonomy;
    }

    public TextDictionary setTaxonomy(@Property(value="taxonomy") Taxonomy taxonomy) {
        this.taxonomy = taxonomy;
        return this;
    }

    public Array requireArray() {
        if (this.array == null) {
            throw new MissingElementException(this, PMMLElements.TEXTDICTIONARY_ARRAY);
        }
        return this.array;
    }

    public Array getArray() {
        return this.array;
    }

    public TextDictionary setArray(@Property(value="array") Array array) {
        this.array = array;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getTaxonomy(), (Visitable)this.getArray());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

