/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x13;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import jdplus.sa.base.api.DecompositionMode;
import jdplus.sa.base.api.EstimationPolicyType;
import jdplus.sa.base.api.SaDiagnosticsFactory;
import jdplus.sa.base.api.SaManager;
import jdplus.sa.base.api.SaProcessingFactory;
import jdplus.sa.base.api.SaProcessor;
import jdplus.sa.base.api.SaSpecification;
import jdplus.sa.base.core.diagnostics.AdvancedResidualSeasonalityDiagnosticsConfiguration;
import jdplus.sa.base.core.diagnostics.AdvancedResidualSeasonalityDiagnosticsFactory;
import jdplus.sa.base.core.diagnostics.CoherenceDiagnostics;
import jdplus.sa.base.core.diagnostics.CoherenceDiagnosticsConfiguration;
import jdplus.sa.base.core.diagnostics.CoherenceDiagnosticsFactory;
import jdplus.sa.base.core.diagnostics.CombinedSeasonalityDiagnosticsConfiguration;
import jdplus.sa.base.core.diagnostics.CombinedSeasonalityDiagnosticsFactory;
import jdplus.sa.base.core.diagnostics.ResidualTradingDaysDiagnostics;
import jdplus.sa.base.core.diagnostics.ResidualTradingDaysDiagnosticsConfiguration;
import jdplus.sa.base.core.diagnostics.ResidualTradingDaysDiagnosticsFactory;
import jdplus.sa.base.core.diagnostics.SaOutOfSampleDiagnosticsFactory;
import jdplus.sa.base.core.diagnostics.SaOutliersDiagnosticsFactory;
import jdplus.sa.base.core.diagnostics.SaResidualsDiagnosticsFactory;
import jdplus.sa.base.core.diagnostics.SpectralDiagnostics;
import jdplus.sa.base.core.diagnostics.SpectralDiagnosticsConfiguration;
import jdplus.sa.base.core.diagnostics.SpectralDiagnosticsFactory;
import jdplus.toolkit.base.api.arima.SarimaSpec;
import jdplus.toolkit.base.api.dictionaries.Dictionary;
import jdplus.toolkit.base.api.information.Explorable;
import jdplus.toolkit.base.api.modelling.TransformationType;
import jdplus.toolkit.base.api.processing.AlgorithmDescriptor;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.regression.ITradingDaysVariable;
import jdplus.toolkit.base.core.modelling.GeneralLinearModel;
import jdplus.toolkit.base.core.regarima.diagnostics.OutOfSampleDiagnosticsConfiguration;
import jdplus.toolkit.base.core.regarima.diagnostics.OutliersDiagnosticsConfiguration;
import jdplus.toolkit.base.core.regarima.diagnostics.ResidualsDiagnosticsConfiguration;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModel;
import jdplus.x13.base.api.regarima.RegArimaSpec;
import jdplus.x13.base.api.x11.X11Spec;
import jdplus.x13.base.api.x13.X13Dictionaries;
import jdplus.x13.base.api.x13.X13Spec;
import jdplus.x13.base.core.x11.X11Results;
import jdplus.x13.base.core.x13.X13Kernel;
import jdplus.x13.base.core.x13.X13Results;
import jdplus.x13.base.core.x13.diagnostics.MDiagnosticsConfiguration;
import jdplus.x13.base.core.x13.diagnostics.MDiagnosticsFactory;
import jdplus.x13.base.core.x13.regarima.RegArimaFactory;

public class X13Factory
implements SaProcessingFactory<X13Spec, X13Results> {
    private final List<SaDiagnosticsFactory<?, X13Results>> diagnostics = new CopyOnWriteArrayList();

    public static X13Factory getInstance() {
        return (X13Factory)SaManager.processors().stream().filter(x -> x instanceof X13Factory).findAny().orElse(new X13Factory());
    }

    public static List<SaDiagnosticsFactory<?, X13Results>> defaultDiagnostics() {
        CoherenceDiagnosticsFactory coherence = new CoherenceDiagnosticsFactory(CoherenceDiagnosticsConfiguration.getDefault(), r -> r.getDecomposition() == null ? null : new CoherenceDiagnostics.Input(r.getDecomposition().getMode(), (Explorable)r));
        SaOutOfSampleDiagnosticsFactory outofsample = new SaOutOfSampleDiagnosticsFactory(OutOfSampleDiagnosticsConfiguration.getDefault(), r -> r.getDiagnostics() == null ? null : r.getDiagnostics().getGenericDiagnostics().forecastingTest());
        SaResidualsDiagnosticsFactory residuals = new SaResidualsDiagnosticsFactory(ResidualsDiagnosticsConfiguration.getDefault(), r -> r.getPreprocessing());
        SaOutliersDiagnosticsFactory outliers = new SaOutliersDiagnosticsFactory(OutliersDiagnosticsConfiguration.getDefault(), r -> r.getPreprocessing());
        SpectralDiagnosticsFactory spectral = new SpectralDiagnosticsFactory(SpectralDiagnosticsConfiguration.getDefault(), r -> {
            X11Results x11 = r.getDecomposition();
            if (x11 == null) {
                return null;
            }
            return new SpectralDiagnostics.Input(x11.getMode(), x11.getB1(), x11.getD11());
        });
        MDiagnosticsFactory mstats = new MDiagnosticsFactory(MDiagnosticsConfiguration.getDefault());
        AdvancedResidualSeasonalityDiagnosticsFactory advancedResidualSeasonality = new AdvancedResidualSeasonalityDiagnosticsFactory(AdvancedResidualSeasonalityDiagnosticsConfiguration.getDefault(), r -> r.getDiagnostics() == null ? null : r.getDiagnostics().getGenericDiagnostics());
        CombinedSeasonalityDiagnosticsFactory combinedSeasonality = new CombinedSeasonalityDiagnosticsFactory(CombinedSeasonalityDiagnosticsConfiguration.getDefault(), r -> r.getDiagnostics() == null ? null : r.getDiagnostics().getGenericDiagnostics());
        ResidualTradingDaysDiagnosticsFactory residualTradingDays = new ResidualTradingDaysDiagnosticsFactory(ResidualTradingDaysDiagnosticsConfiguration.getDefault(), r -> {
            RegSarimaModel preprocessing = r.getPreprocessing();
            boolean td = false;
            if (preprocessing != null) {
                td = Arrays.stream(preprocessing.getDescription().getVariables()).anyMatch(v -> v.getCore() instanceof ITradingDaysVariable);
            }
            return r.getDiagnostics() == null ? null : new ResidualTradingDaysDiagnostics.Input(r.getDiagnostics().getGenericDiagnostics().residualTradingDaysTests(), td);
        });
        ArrayList all = new ArrayList();
        all.add((SaDiagnosticsFactory<?, X13Results>)coherence);
        all.add((SaDiagnosticsFactory<?, X13Results>)residuals);
        all.add((SaDiagnosticsFactory<?, X13Results>)outofsample);
        all.add((SaDiagnosticsFactory<?, X13Results>)outliers);
        all.add((SaDiagnosticsFactory<?, X13Results>)spectral);
        all.add(mstats);
        all.add((SaDiagnosticsFactory<?, X13Results>)combinedSeasonality);
        all.add((SaDiagnosticsFactory<?, X13Results>)advancedResidualSeasonality);
        all.add((SaDiagnosticsFactory<?, X13Results>)residualTradingDays);
        return all;
    }

    public X13Factory() {
        this.diagnostics.addAll(X13Factory.defaultDiagnostics());
    }

    public AlgorithmDescriptor descriptor() {
        return X13Spec.DESCRIPTOR_V3;
    }

    public X13Spec generateSpec(X13Spec spec, X13Results estimation) {
        if (!estimation.isValid()) {
            return null;
        }
        X11Spec nxspec = this.update(spec.getX11(), estimation.getDecomposition());
        X13Spec.Builder builder = spec.toBuilder().x11(nxspec);
        RegArimaSpec nrspec = spec.getRegArima().getBasic().isPreprocessing() ? RegArimaFactory.getInstance().generateSpec(spec.getRegArima(), (GeneralLinearModel.Description<SarimaSpec>)estimation.getPreprocessing().getDescription()) : spec.getRegArima();
        builder.regArima(nrspec);
        return (X13Spec)builder.build();
    }

    public X13Spec refreshSpec(X13Spec currentSpec, X13Spec domainSpec, EstimationPolicyType policy, TsDomain frozen) {
        if (policy == EstimationPolicyType.Complete) {
            return domainSpec;
        }
        if (policy == EstimationPolicyType.None || !currentSpec.getRegArima().getBasic().isPreprocessing()) {
            return currentSpec;
        }
        RegArimaSpec nrspec = RegArimaFactory.getInstance().refreshSpec(currentSpec.getRegArima(), domainSpec.getRegArima(), policy, frozen);
        X11Spec x11 = currentSpec.getX11();
        if (nrspec.getTransform().getFunction() == TransformationType.Auto) {
            x11 = (X11Spec)x11.toBuilder().mode(DecompositionMode.Undefined).build();
        }
        return (X13Spec)currentSpec.toBuilder().regArima(nrspec).x11(x11).build();
    }

    private X11Spec update(X11Spec x11, X11Results rslts) {
        return x11;
    }

    public boolean canHandle(SaSpecification spec) {
        return spec instanceof X13Spec;
    }

    public SaProcessor processor(X13Spec spec) {
        return (s, cxt, log) -> X13Kernel.of(spec, cxt).process(s, log);
    }

    public X13Spec decode(SaSpecification spec) {
        if (spec instanceof X13Spec) {
            return (X13Spec)spec;
        }
        return null;
    }

    public List<SaDiagnosticsFactory<?, X13Results>> diagnosticFactories() {
        return Collections.unmodifiableList(this.diagnostics);
    }

    public void addDiagnostics(SaDiagnosticsFactory<?, X13Results> diag) {
        this.diagnostics.add(diag);
    }

    public void replaceDiagnostics(SaDiagnosticsFactory<?, X13Results> olddiag, SaDiagnosticsFactory<?, X13Results> newdiag) {
        int idx = this.diagnostics.indexOf(olddiag);
        if (idx < 0) {
            this.diagnostics.add(newdiag);
        } else {
            this.diagnostics.set(idx, newdiag);
        }
    }

    public void resetDiagnosticFactories(List<SaDiagnosticsFactory<?, X13Results>> factories) {
        this.diagnostics.clear();
        this.diagnostics.addAll(factories);
    }

    public Dictionary outputDictionary() {
        return X13Dictionaries.X13DICTIONARY;
    }
}

