## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = ""
)

## ----message=F, warning=F-----------------------------------------------------
library(CSCNet)

library(riskRegression)

set.seed(123)

d <- sampleData(n = 500,outcome = 'competing.risks')

knitr::kable(head(d),digits=3)

table(d$event)

## -----------------------------------------------------------------------------
vl <- list('1'=~X1+X3+X7+X9+X10,

           '2'=c('X1','X2','X6','X10'))

penfit <- penCSC(time = 'time',status = 'event',vars.list = vl,data = d,
                 
                 alpha.list = list('1'=0,'2'=.5),lambda.list = list('1'=.01,'2'=.02))

penfit

## -----------------------------------------------------------------------------
predict(penfit,d[1:3,],type='lp',event=1) %>% as.data.frame

## -----------------------------------------------------------------------------
predict(penfit,d[1:3,],type='response') %>% as.data.frame

## -----------------------------------------------------------------------------
predict(penfit,d[1:3,],type='absRisk',event=1,time=summary(d$time)[c(3,5)]) %>% as.data.frame

## ----eval=F-------------------------------------------------------------------
# #Function to standardize numerical predictors using functions from recipes package
# 
# library(recipes)
# 
# pp.fun <- function(data){
# 
#   recipe(time+event~.,data=data) %>%
# 
#     step_center(all_numeric_predictors()) %>%
# 
#     step_scale(all_numeric_predictors()) %>%
# 
#     prep(training=data) %>%
# 
#     bake(new_data=NULL)
# 
# }
# 
# set.seed(123)
# 
# tri.l <- caret::createFolds(as.factor(d$event),k=5,list=T,returnTrain=T)
# 
# tune_obj <- tune_penCSC(time = 'time',status = 'event',vars.list = vl,data = d,
# 
#                         horizons = median(d$time),event = 1,tri.list = tri.l,metrics = 'AUC',
# 
#                         alpha.grid = list('1'=0,'2'=c(.5,1)),preProc.fun = pp.fun,
# 
#                         standardize = F,parallel = T,preProc.pkgs = 'recipes')
# 
# tune_obj$validation_result %>% arrange(desc(mean.AUC)) %>% head
# 
# tune_obj$final_params
# 
# tune_obj$final_fits
# 

