## ----eval=FALSE---------------------------------------------------------------
# require(link2GI)
# require(curl)
# 
# # Create project folder structure
# dirs <- link2GI::createFolders(
#   root_folder = file.path(tempdir(), "link2GI_examples"),
#   folders     = c("run/")
# )
# 
# # Download census data
# url <- "https://www.zensus2011.de/SharedDocs/Downloads/DE/Pressemitteilung/DemografischeGrunddaten/csv_Bevoelkerung_100m_Gitter.zip?__blob=publicationFile&v=3"
# zipfile <- file.path(dirs$path_run, "testdata.zip")
# curl::curl_download(url, zipfile)
# 
# # Extract CSV file
# unzip(
#   zipfile,
#   files = grep("[.]csv$", unzip(zipfile, list = TRUE)$Name, value = TRUE),
#   exdir = dirs$path_run,
#   junkpaths = TRUE,
#   overwrite = TRUE
# )

## ----eval=FALSE---------------------------------------------------------------
# # Fast CSV import
# xyz <- data.table::fread(
#   file.path(dirs$path_run, "Zensus_Bevoelkerung_100m-Gitter.csv")
# )
# 
# head(xyz)

