/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.picocsv;

import internal.io.text.LegacyFiles;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.Resource;
import nbbrd.io.function.IOSupplier;
import nbbrd.io.net.MediaType;
import nbbrd.io.text.TextBuffers;
import nbbrd.io.text.TextFormatter;
import nbbrd.io.text.TextParser;
import nbbrd.io.text.TextResource;
import nbbrd.picocsv.Csv;

public final class Picocsv {
    public static final MediaType CSV_UTF_8 = MediaType.builder().type("text").subtype("csv").build().withCharset(StandardCharsets.UTF_8);

    private static void checkIsFile(@NonNull Path source) throws FileSystemException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (Files.isDirectory(source, new LinkOption[0])) {
            throw new AccessDeniedException(source.toString());
        }
    }

    @Generated
    private Picocsv() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class Formatter<T>
    implements TextFormatter<T> {
        @NonNull
        private final Csv.Format format;
        @NonNull
        private final Csv.WriterOptions options;
        @NonNull
        private final OutputHandler<T> handler;

        @NonNull
        public static <T> Formatter<T> of(@NonNull OutputHandler<T> handler) {
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            return Formatter.builder(handler).build();
        }

        @NonNull
        public static <T> Builder<T> builder(@NonNull OutputHandler<T> handler) {
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            return new Builder<T>().handler(handler);
        }

        public void formatFile(@NonNull T value, @NonNull File target, @NonNull Charset encoding) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            try (OutputStream resource = LegacyFiles.newOutputStream((File)target);){
                CharsetEncoder encoder = encoding.newEncoder();
                this.format(value, TextResource.newBufferedWriter((OutputStream)resource, (CharsetEncoder)encoder), TextBuffers.of((Path)target.toPath(), (CharsetEncoder)encoder));
            }
        }

        public void formatPath(@NonNull T value, @NonNull Path target, @NonNull Charset encoding) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            Picocsv.checkIsFile(target);
            try (OutputStream resource = Files.newOutputStream(target, new OpenOption[0]);){
                CharsetEncoder encoder = encoding.newEncoder();
                this.format(value, TextResource.newBufferedWriter((OutputStream)resource, (CharsetEncoder)encoder), TextBuffers.of((Path)target, (CharsetEncoder)encoder));
            }
        }

        public void formatWriter(@NonNull T value, @NonNull Writer resource) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            this.format(value, TextResource.uncloseableWriter((Writer)resource), TextBuffers.UNKNOWN);
        }

        public void formatStream(@NonNull T value, @NonNull OutputStream resource, @NonNull Charset encoding) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            CharsetEncoder encoder = encoding.newEncoder();
            this.format(value, TextResource.newBufferedWriter((OutputStream)Resource.uncloseableOutputStream((OutputStream)resource), (CharsetEncoder)encoder), TextBuffers.of((OutputStream)resource, (CharsetEncoder)encoder));
        }

        public void formatCsv(@NonNull T value, IOSupplier<// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull Csv.Writer> source) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            try (Csv.Writer resource = (Csv.Writer)source.getWithIO();){
                this.formatCsv(value, resource);
            }
        }

        public void formatCsv(@NonNull T value, // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull Csv.Writer resource) throws IOException {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            this.handler.format(value, resource);
        }

        private void format(T value, Writer charWriter, TextBuffers buffers) throws IOException {
            try (Csv.Writer csv = Csv.Writer.of((Csv.Format)this.format, (Csv.WriterOptions)this.options, (Writer)charWriter, (int)buffers.getCharBufferSize());){
                this.handler.format(value, csv);
            }
        }

        @Generated
        private static <T> Csv.Format $default$format() {
            return Csv.Format.DEFAULT;
        }

        @Generated
        private static <T> Csv.WriterOptions $default$options() {
            return Csv.WriterOptions.DEFAULT;
        }

        @Generated
        Formatter(@NonNull Csv.Format format, @NonNull Csv.WriterOptions options, @NonNull OutputHandler<T> handler) {
            if (format == null) {
                throw new NullPointerException("format is marked non-null but is null");
            }
            if (options == null) {
                throw new NullPointerException("options is marked non-null but is null");
            }
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            this.format = format;
            this.options = options;
            this.handler = handler;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder<T> toBuilder() {
            return new Builder().format(this.format).options(this.options).handler(this.handler);
        }

        @NonNull
        @Generated
        public Csv.Format getFormat() {
            return this.format;
        }

        @NonNull
        @Generated
        public Csv.WriterOptions getOptions() {
            return this.options;
        }

        public static final class Builder<T> {
            @Generated
            private boolean format$set;
            @Generated
            private Csv.Format format$value;
            @Generated
            private boolean options$set;
            @Generated
            private Csv.WriterOptions options$value;
            @Generated
            private OutputHandler<T> handler;

            @Generated
            Builder() {
            }

            @Generated
            public @org.jspecify.annotations.NonNull Builder<T> format(@NonNull Csv.Format format) {
                if (format == null) {
                    throw new NullPointerException("format is marked non-null but is null");
                }
                this.format$value = format;
                this.format$set = true;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull Builder<T> options(@NonNull Csv.WriterOptions options) {
                if (options == null) {
                    throw new NullPointerException("options is marked non-null but is null");
                }
                this.options$value = options;
                this.options$set = true;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull Builder<T> handler(@NonNull OutputHandler<T> handler) {
                if (handler == null) {
                    throw new NullPointerException("handler is marked non-null but is null");
                }
                this.handler = handler;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull Formatter<T> build() {
                Csv.Format format$value = this.format$value;
                if (!this.format$set) {
                    format$value = Formatter.$default$format();
                }
                Csv.WriterOptions options$value = this.options$value;
                if (!this.options$set) {
                    options$value = Formatter.$default$options();
                }
                return new Formatter<T>(format$value, options$value, this.handler);
            }

            @Generated
            public @org.jspecify.annotations.NonNull String toString() {
                return "Picocsv.Formatter.Builder(format$value=" + this.format$value + ", options$value=" + this.options$value + ", handler=" + this.handler + ")";
            }
        }
    }

    @FunctionalInterface
    public static interface OutputHandler<T> {
        public void format(@NonNull T var1, // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull Csv.Writer var2) throws IOException;
    }

    public static final class Parser<T>
    implements TextParser<T> {
        @NonNull
        private final Csv.Format format;
        @NonNull
        private final Csv.ReaderOptions options;
        @NonNull
        private final InputHandler<T> handler;

        @NonNull
        public static <T> Parser<T> of(@NonNull InputHandler<T> handler) {
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            return Parser.builder(handler).build();
        }

        @NonNull
        public static <T> Builder<T> builder(@NonNull InputHandler<T> handler) {
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            return new Builder<T>().handler(handler);
        }

        @NonNull
        public T parseFile(@NonNull File source, @NonNull Charset encoding) throws IOException {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            try (InputStream resource = LegacyFiles.newInputStream((File)source);){
                CharsetDecoder decoder = encoding.newDecoder();
                T t = this.parse(TextResource.newBufferedReader((InputStream)resource, (CharsetDecoder)decoder), TextBuffers.of((Path)source.toPath(), (CharsetDecoder)decoder));
                return t;
            }
        }

        @NonNull
        public T parsePath(@NonNull Path source, @NonNull Charset encoding) throws IOException {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            Picocsv.checkIsFile(source);
            try (InputStream resource = Files.newInputStream(source, new OpenOption[0]);){
                CharsetDecoder decoder = encoding.newDecoder();
                T t = this.parse(TextResource.newBufferedReader((InputStream)resource, (CharsetDecoder)decoder), TextBuffers.of((Path)source, (CharsetDecoder)decoder));
                return t;
            }
        }

        @NonNull
        public T parseReader(@NonNull Reader resource) throws IOException {
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            return this.parse(TextResource.uncloseableReader((Reader)resource), TextBuffers.UNKNOWN);
        }

        @NonNull
        public T parseStream(@NonNull InputStream resource, @NonNull Charset encoding) throws IOException {
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            if (encoding == null) {
                throw new NullPointerException("encoding is marked non-null but is null");
            }
            CharsetDecoder decoder = encoding.newDecoder();
            return this.parse(TextResource.newBufferedReader((InputStream)Resource.uncloseableInputStream((InputStream)resource), (CharsetDecoder)decoder), TextBuffers.of((InputStream)resource, (CharsetDecoder)decoder));
        }

        @NonNull
        public T parseCsv(IOSupplier<// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull Csv.Reader> source) throws IOException {
            try (Csv.Reader resource = (Csv.Reader)source.getWithIO();){
                T t = this.parseCsv(resource);
                return t;
            }
        }

        @NonNull
        public T parseCsv(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull Csv.Reader resource) throws IOException {
            if (resource == null) {
                throw new NullPointerException("resource is marked non-null but is null");
            }
            return this.handler.parse(resource);
        }

        private T parse(Reader charReader, TextBuffers buffers) throws IOException {
            try (Csv.Reader csv = Csv.Reader.of((Csv.Format)this.format, (Csv.ReaderOptions)this.options, (Reader)charReader, (int)buffers.getCharBufferSize());){
                T t = this.handler.parse(csv);
                return t;
            }
        }

        @Generated
        private static <T> Csv.Format $default$format() {
            return Csv.Format.DEFAULT;
        }

        @Generated
        private static <T> Csv.ReaderOptions $default$options() {
            return Csv.ReaderOptions.DEFAULT;
        }

        @Generated
        Parser(@NonNull Csv.Format format, @NonNull Csv.ReaderOptions options, @NonNull InputHandler<T> handler) {
            if (format == null) {
                throw new NullPointerException("format is marked non-null but is null");
            }
            if (options == null) {
                throw new NullPointerException("options is marked non-null but is null");
            }
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            this.format = format;
            this.options = options;
            this.handler = handler;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder<T> toBuilder() {
            return new Builder().format(this.format).options(this.options).handler(this.handler);
        }

        @NonNull
        @Generated
        public Csv.Format getFormat() {
            return this.format;
        }

        @NonNull
        @Generated
        public Csv.ReaderOptions getOptions() {
            return this.options;
        }

        public static final class Builder<T> {
            @Generated
            private boolean format$set;
            @Generated
            private Csv.Format format$value;
            @Generated
            private boolean options$set;
            @Generated
            private Csv.ReaderOptions options$value;
            @Generated
            private InputHandler<T> handler;

            @Generated
            Builder() {
            }

            @Generated
            public @org.jspecify.annotations.NonNull Builder<T> format(@NonNull Csv.Format format) {
                if (format == null) {
                    throw new NullPointerException("format is marked non-null but is null");
                }
                this.format$value = format;
                this.format$set = true;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull Builder<T> options(@NonNull Csv.ReaderOptions options) {
                if (options == null) {
                    throw new NullPointerException("options is marked non-null but is null");
                }
                this.options$value = options;
                this.options$set = true;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull Builder<T> handler(@NonNull InputHandler<T> handler) {
                if (handler == null) {
                    throw new NullPointerException("handler is marked non-null but is null");
                }
                this.handler = handler;
                return this;
            }

            @Generated
            public @org.jspecify.annotations.NonNull Parser<T> build() {
                Csv.Format format$value = this.format$value;
                if (!this.format$set) {
                    format$value = Parser.$default$format();
                }
                Csv.ReaderOptions options$value = this.options$value;
                if (!this.options$set) {
                    options$value = Parser.$default$options();
                }
                return new Parser<T>(format$value, options$value, this.handler);
            }

            @Generated
            public @org.jspecify.annotations.NonNull String toString() {
                return "Picocsv.Parser.Builder(format$value=" + this.format$value + ", options$value=" + this.options$value + ", handler=" + this.handler + ")";
            }
        }
    }

    @FunctionalInterface
    public static interface InputHandler<T> {
        @NonNull
        public T parse(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull Csv.Reader var1) throws IOException;
    }
}

