/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.spi;

import jdplus.sa.base.api.diagnostics.CombinedSeasonalityTest;
import jdplus.sa.base.api.diagnostics.SeasonalityTests;
import jdplus.sa.base.core.tests.CombinedSeasonality;
import jdplus.sa.base.core.tests.EvolutiveSeasonality;
import jdplus.sa.base.core.tests.FTest;
import jdplus.sa.base.core.tests.Friedman;
import jdplus.sa.base.core.tests.KruskalWallis;
import jdplus.sa.base.core.tests.Qs;
import jdplus.sa.base.core.tests.StableSeasonality;
import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.OneWayAnova;
import jdplus.toolkit.base.api.stats.StatisticalTest;

public class SeasonalityTestsFactory
implements SeasonalityTests.Factory {
    public OneWayAnova stableSeasonalityTest(DoubleSeq x, int period) {
        return StableSeasonality.of(x, period);
    }

    public OneWayAnova evolutiveSeasonalityTest(DoubleSeq x, int period, int startPos, double xbar) {
        return EvolutiveSeasonality.of(x, period, startPos, xbar);
    }

    public CombinedSeasonalityTest combinedTest(DoubleSeq x, int period, int startPos, double xbar) {
        CombinedSeasonality cs = new CombinedSeasonality(x, period, startPos, xbar);
        return new CombinedSeasonalityTest(cs.getSummary(), cs.getStableSeasonalityTest(), cs.getEvolutiveSeasonalityTest(), cs.getNonParametricTestForStableSeasonality().build());
    }

    public StatisticalTest friedmanTest(DoubleSeq data, int period) {
        return new Friedman(data, period).build();
    }

    public StatisticalTest kruskalWallisTest(DoubleSeq data, int period) {
        return new KruskalWallis(data, period).build();
    }

    public StatisticalTest qsTest(DoubleSeq data, int period, int nlags) {
        return new Qs(data, period).autoCorrelationsCount(nlags).build();
    }

    public StatisticalTest fTest(DoubleSeq data, int period, SarimaOrders.Prespecified model) {
        return new FTest(data, period).model(model).build();
    }
}

