/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.math.functions.gsl.roots;

import internal.toolkit.base.core.math.functions.gsl.roots.FDFSolver;
import internal.toolkit.base.core.math.functions.gsl.roots.GslRootException;
import java.util.function.DoubleUnaryOperator;

public class SecantSolver
extends FDFSolver {
    public SecantSolver(DoubleUnaryOperator fn, DoubleUnaryOperator dfn, double root) {
        this.function = fn;
        this.functionDf = dfn;
        this.root = root;
        this.f = fn.applyAsDouble(root);
        this.df = dfn.applyAsDouble(root);
    }

    @Override
    public void iterate() {
        double x = this.root;
        double f = this.f;
        double df = this.df;
        if (f == 0.0) {
            return;
        }
        if (df == 0.0) {
            throw new GslRootException("Derivative is zero");
        }
        double x_new = x - f / df;
        double f_new = this.function.applyAsDouble(x_new);
        double df_new = df * ((f - f_new) / f);
        this.root = x_new;
        this.f = f_new;
        this.df = df_new;
        if (!Double.isFinite(f_new)) {
            throw new GslRootException("Function value is not finite");
        }
        if (!Double.isFinite(df_new)) {
            throw new GslRootException("Derivative value is not finite");
        }
    }
}

