/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.linearfilters;

import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.api.util.TableOfLong;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.Simplifying;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.linearfilters.IFiniteFilter;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;
import jdplus.toolkit.base.core.math.matrices.UpperTriangularMatrix;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.math.polynomials.RootsSolver;

public final class SymmetricFrequencyResponse {
    public static final double TwoPi = Math.PI * 2;
    private static FastMatrix g_u;
    private final Polynomial m_p;

    private static synchronized FastMatrix _transform(int r) {
        if (g_u == null || g_u.getRowsCount() < r) {
            g_u = SymmetricFrequencyResponse.transform(r);
        }
        return g_u;
    }

    public static SymmetricFrequencyResponse createFromFilter(IFiniteFilter f) {
        return new SymmetricFrequencyResponse(SymmetricFilter.convolutionOf(f));
    }

    private static void D2SFR(double[] c) {
        int q = c.length;
        int i = 1;
        while (i < q) {
            int n = i++;
            c[n] = c[n] * 2.0;
        }
        if (q > 2) {
            FastMatrix u = SymmetricFrequencyResponse._transform(q);
            UpperTriangularMatrix.Ux(u.extract(0, q, 0, q), DataBlock.of(c));
        }
    }

    private static void SFR2D(double[] c) throws MatrixException {
        int q = c.length;
        if (q > 2) {
            FastMatrix u = SymmetricFrequencyResponse._transform(q);
            UpperTriangularMatrix.solveUx(u, DataBlock.of(c));
        }
        int i = 1;
        while (i < q) {
            int n = i++;
            c[n] = c[n] / 2.0;
        }
    }

    private static Polynomial sfrur(Complex ur) {
        double a = ur.getRe();
        if (ur.getIm() == 0.0) {
            return Polynomial.valueOf(2.0, -2.0 / a);
        }
        double[] s = new double[]{2.0 + 4.0 * a * a, -4.0 * a, 1.0};
        SymmetricFrequencyResponse.D2SFR(s);
        return Polynomial.of(s);
    }

    static FastMatrix transform(int rank) {
        if (rank <= 53) {
            return SymmetricFrequencyResponse.ltransform(rank);
        }
        return SymmetricFrequencyResponse.dtransform(rank);
    }

    static FastMatrix dtransform(int rank) {
        FastMatrix U = FastMatrix.square(rank);
        U.set(0, 0, 1.0);
        U.set(1, 1, 1.0);
        for (int c = 2; c < rank; ++c) {
            U.set(0, c, -U.get(0, c - 2));
            for (int r = 1; r < c - 1; ++r) {
                U.set(r, c, -U.get(r, c - 2) + 2.0 * U.get(r - 1, c - 1));
            }
            U.set(c - 1, c, 2.0 * U.get(c - 2, c - 1));
            U.set(c, c, 2.0 * U.get(c - 1, c - 1));
        }
        return U;
    }

    static FastMatrix ltransform(int rank) {
        FastMatrix U = FastMatrix.square(rank);
        TableOfLong V = new TableOfLong(rank, rank);
        V.set(0, 0, 1L);
        V.set(1, 1, 1L);
        for (int c = 2; c < rank; ++c) {
            V.set(0, c, -V.get(0, c - 2));
            for (int r = 1; r < c - 1; ++r) {
                V.set(r, c, -V.get(r, c - 2) + (V.get(r - 1, c - 1) << 1));
            }
            V.set(c - 1, c, V.get(c - 2, c - 1) << 1);
            V.set(c, c, V.get(c - 1, c - 1) << 1);
        }
        double[] pm = U.getStorage();
        long[] pv = V.internalStorage();
        for (int i = 0; i < pv.length; ++i) {
            pm[i] = pv[i];
        }
        return U;
    }

    public SymmetricFrequencyResponse(Polynomial p) {
        this.m_p = p;
    }

    public SymmetricFrequencyResponse(SymmetricFilter sf) {
        double[] n = sf.coefficientsAsPolynomial().toArray();
        SymmetricFrequencyResponse.D2SFR(n);
        this.m_p = Polynomial.of(n);
    }

    public SymmetricFrequencyResponse divide(SymmetricFrequencyResponse r) {
        Polynomial p = this.m_p.divide(r.m_p);
        return new SymmetricFrequencyResponse(p);
    }

    public double evaluateAt(double freq) {
        return this.evaluateAtCos(Math.cos(freq));
    }

    public double evaluateAtCos(double cos) {
        return this.m_p.evaluateAt(cos);
    }

    public double get(int idx) {
        return this.m_p.get(idx);
    }

    public Polynomial getPolynomial() {
        return this.m_p;
    }

    public int getDegree() {
        return this.m_p.degree();
    }

    public double getIntegral() {
        double var = this.m_p.get(0);
        double icos = 1.0;
        for (int i = 2; i <= this.m_p.degree(); i += 2) {
            icos *= (double)(i - 1);
            var += this.m_p.get(i) * (icos /= (double)i);
        }
        return var;
    }

    public SymmetricFrequencyResponse minus(double d) {
        Polynomial p = this.m_p.minus(d);
        return new SymmetricFrequencyResponse(p);
    }

    public SymmetricFrequencyResponse minus(SymmetricFrequencyResponse r) {
        Polynomial p = this.m_p.minus(r.m_p);
        return new SymmetricFrequencyResponse(p);
    }

    public SymmetricFrequencyResponse negate() {
        Polynomial p = this.m_p.negate();
        return new SymmetricFrequencyResponse(p);
    }

    public SymmetricFrequencyResponse plus(double d) {
        Polynomial p = this.m_p.plus(d);
        return new SymmetricFrequencyResponse(p);
    }

    public SymmetricFrequencyResponse plus(SymmetricFrequencyResponse r) {
        Polynomial p = this.m_p.plus(r.m_p);
        return new SymmetricFrequencyResponse(p);
    }

    public Complex[] roots() {
        return this.m_p.roots();
    }

    public Complex[] roots(RootsSolver searcher) {
        return this.m_p.roots(searcher);
    }

    public SymmetricFrequencyResponse times(double d) {
        Polynomial p = this.m_p.times(d);
        return new SymmetricFrequencyResponse(p);
    }

    public SymmetricFrequencyResponse times(SymmetricFrequencyResponse r) {
        Polynomial p = this.m_p.times(r.m_p);
        return new SymmetricFrequencyResponse(p);
    }

    public SymmetricFilter toSymmetricFilter() throws MatrixException {
        double[] c = this.m_p.toArray();
        SymmetricFrequencyResponse.SFR2D(c);
        return SymmetricFilter.ofInternal(c);
    }

    public static class SimplifyingTool
    extends Simplifying<SymmetricFrequencyResponse> {
        @Override
        public boolean simplify(SymmetricFrequencyResponse left, BackFilter urb) {
            this.clear();
            if (left.m_p.degree() == 0) {
                return false;
            }
            Complex[] roots = urb.roots();
            if (roots == null) {
                return false;
            }
            Polynomial P = left.m_p;
            Polynomial Q = null;
            Polynomial R = null;
            for (int i = 0; i < roots.length; ++i) {
                if (!(roots[i].getIm() >= 0.0)) continue;
                Polynomial D = SymmetricFrequencyResponse.sfrur(roots[i]);
                Polynomial.Division div = Polynomial.divide(P, D);
                if (div.isExact()) {
                    P = div.getQuotient();
                    if (Q == null) {
                        Q = D;
                        continue;
                    }
                    Q = Q.times(D);
                    continue;
                }
                R = R == null ? D : R.times(D);
            }
            if (Q == null) {
                return false;
            }
            this.simplifiedLeft = new SymmetricFrequencyResponse(P);
            this.simplifiedRight = R == null ? new SymmetricFrequencyResponse(Polynomial.ONE) : new SymmetricFrequencyResponse(R);
            this.common = new SymmetricFrequencyResponse(Q);
            return true;
        }

        @Override
        public boolean simplify(SymmetricFrequencyResponse left, SymmetricFrequencyResponse right) {
            this.clear();
            if (left.m_p.degree() == 0 || right.m_p.degree() == 0) {
                return false;
            }
            Polynomial.SimplifyingTool psimp = new Polynomial.SimplifyingTool();
            Polynomial lp = left.m_p;
            Polynomial rp = right.m_p;
            if (psimp.simplify(lp, rp)) {
                lp = (Polynomial)psimp.getLeft();
                rp = (Polynomial)psimp.getRight();
                Polynomial p = (Polynomial)psimp.getCommon();
                this.common = new SymmetricFrequencyResponse(p);
                this.simplifiedLeft = new SymmetricFrequencyResponse(lp);
                this.simplifiedRight = new SymmetricFrequencyResponse(rp);
                return true;
            }
            return false;
        }
    }
}

