/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.lapack;

import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import lombok.Generated;

public final class TRMV {
    public static void Ux(FastMatrix U, double[] px, int startx, int incx) {
        int n = U.getColumnsCount();
        int lda = U.getColumnIncrement();
        int start = U.getStartPosition();
        double[] pu = U.getStorage();
        if (incx == 1) {
            int xend = startx + n;
            int ixj = startx;
            int u0 = start;
            while (ixj < xend) {
                double xcur = px[ixj];
                if (xcur != 0.0) {
                    int iu = u0;
                    int ix = startx;
                    while (ix < ixj) {
                        int n2 = ix++;
                        px[n2] = px[n2] + xcur * pu[iu++];
                    }
                    px[ixj] = xcur * pu[iu];
                }
                ++ixj;
                u0 += lda;
            }
        } else {
            int xend = startx + n * incx;
            int ixj = startx;
            int u0 = start;
            while (ixj != xend) {
                double xcur = px[ixj];
                if (xcur != 0.0) {
                    int iu = u0;
                    for (int ix = startx; ix != ixj; ix += incx) {
                        int n3 = ix;
                        px[n3] = px[n3] + xcur * pu[iu++];
                    }
                    px[ixj] = xcur * pu[iu];
                }
                ixj += incx;
                u0 += lda;
            }
        }
    }

    public static void Lx(FastMatrix L, double[] px, int startx, int incx) {
        int n = L.getColumnsCount();
        int lda = L.getColumnIncrement();
        int start = L.getStartPosition();
        double[] pl = L.getStorage();
        if (incx == 1) {
            int xend = startx + n;
            int li = start + (n - 1) * (lda + 1);
            int xi = xend - 1;
            while (li >= start) {
                double z = px[xi];
                if (z != 0.0) {
                    px[xi] = pl[li] * z;
                    int xj = xi + 1;
                    int lj = li + 1;
                    while (xj < xend) {
                        int n2 = xj++;
                        px[n2] = px[n2] + pl[lj] * z;
                        ++lj;
                    }
                }
                li -= lda + 1;
                --xi;
            }
        } else {
            int xend = startx + incx * n;
            int li = start + (n - 1) * (lda + 1);
            int xi = xend - incx;
            while (li >= start) {
                double z = px[xi];
                if (z != 0.0) {
                    px[xi] = pl[li] * z;
                    int xj = xi + incx;
                    int idx = li + 1;
                    while (xj != xend) {
                        int n3 = xj;
                        px[n3] = px[n3] + pl[idx] * z;
                        xj += incx;
                        ++idx;
                    }
                }
                li -= lda + 1;
                xi -= incx;
            }
        }
    }

    public static void xU(FastMatrix U, double[] px, int startx, int incx) {
        TRMV.Utx(U, px, startx, incx);
    }

    public static void xL(FastMatrix L, double[] px, int startx, int incx) {
        TRMV.Ltx(L, px, startx, incx);
    }

    public static void Utx(FastMatrix U, double[] px, int startx, int incx) {
        int n = U.getColumnsCount();
        int lda = U.getColumnIncrement();
        int start = U.getStartPosition();
        double[] pu = U.getStorage();
        if (incx == 1) {
            int xend = startx + n - 1;
            int uend = start + (n - 1) * (lda + 1);
            int u0 = uend;
            for (int ixj = xend; ixj >= startx; --ixj) {
                double tmp = px[ixj] * pu[u0--];
                int ix = ixj - 1;
                int iu = u0;
                while (ix >= startx) {
                    tmp += px[ix] * pu[iu];
                    --ix;
                    --iu;
                }
                px[ixj] = tmp;
                u0 -= lda;
            }
        } else {
            int xend = startx + n * incx;
            int uend = start + (n - 1) * (lda + 1);
            int ixj = xend;
            int u0 = uend;
            while (ixj != startx) {
                double tmp = px[ixj -= incx] * pu[u0--];
                int iu = u0;
                int ix = ixj;
                while (ix != startx) {
                    tmp += px[ix -= incx] * pu[iu--];
                }
                px[ixj] = tmp;
                u0 -= lda;
            }
        }
    }

    public static void Ltx(FastMatrix L, double[] px, int startx, int incx) {
        int n = L.getColumnsCount();
        int lda = L.getColumnIncrement();
        int start = L.getStartPosition();
        double[] pl = L.getStorage();
        if (incx == 1) {
            int xend = startx + n;
            int ixj = startx;
            int u0 = start;
            while (ixj < xend) {
                double tmp = px[ixj] * pl[u0];
                int ix = ixj + 1;
                int iu = u0 + 1;
                while (ix < xend) {
                    tmp += px[ix] * pl[iu];
                    ++ix;
                    ++iu;
                }
                px[ixj] = tmp;
                ++ixj;
                u0 += lda + 1;
            }
        } else {
            int xend = startx + n * incx;
            int ixj = startx;
            int u0 = start;
            while (ixj != xend) {
                double tmp = px[ixj] * pl[u0];
                int ix = ixj + incx;
                int iu = u0 + 1;
                while (ix != xend) {
                    tmp += px[ix] * pl[iu];
                    ix += incx;
                    ++iu;
                }
                px[ixj] = tmp;
                ixj += incx;
                u0 += lda + 1;
            }
        }
    }

    @Generated
    private TRMV() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

