/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.polynomials;

import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.api.math.ComplexType;
import jdplus.toolkit.base.api.util.Ref;
import jdplus.toolkit.base.core.math.ComplexComputer;
import jdplus.toolkit.base.core.math.ComplexMath;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.math.polynomials.RootsSolver;

public class MullerNewtonSolver
implements RootsSolver {
    private double[] polynomial;
    private double[] reducedPolynomial;
    private Complex[] roots;
    private Polynomial remainder;
    private int startIdx;
    private int degree;
    private double maxError;
    private static final int MITERMAX = 150;
    private static final int MCONVERGENCE = 100;
    private static final double MMAXDIST = 1000.0;
    private static final double MFACTOR = 100000.0;
    private static final double MKITERMAX = 1000.0;
    private static final double MFVALUE = 1.0E36;
    private static final double MBOUND1 = 1.01;
    private static final double MBOUND2 = 0.99;
    private static final double MBOUND3 = 0.01;
    private final double MBOUND4 = Math.sqrt(Double.MAX_VALUE) / 10000.0;
    private final double MBOUND6 = Math.log10(this.MBOUND4) - 4.0;
    private static final double MBOUND7 = 1.0E-5;
    private final double MNOISESTART;
    private static final double MNOISEMAX = 5.0;
    private static final int NITERMAX = 20;
    private static final double NFACTOR = 5.0;
    private static final double NFVALUE = 1.0E36;
    private static final double ISQRT2 = 1.0 / Math.sqrt(2.0);
    private final double NBOUND = Math.sqrt(2.220446049250313E-16);
    private static final int NNOISEMAX = 5;
    private static final double DBL_EPSILON = 2.220446049250313E-16;
    Complex x0 = Complex.ZERO;
    Complex x1 = Complex.ZERO;
    Complex x2 = Complex.ZERO;
    Complex h1 = Complex.ZERO;
    Complex h2 = Complex.ZERO;
    Complex q2 = Complex.ZERO;
    final Ref<Complex> f0 = new Ref((Object)Complex.ZERO);
    final Ref<Complex> f1 = new Ref((Object)Complex.ZERO);
    final Ref<Complex> f2 = new Ref((Object)Complex.ZERO);
    int iter;
    private static final Complex[] COMPLEX_FOR_ITER = MullerNewtonSolver.initComplexForIter(150);

    private static void fdvalue(double[] p, int i0, Ref<Complex> f, Complex x) {
        int n = p.length - 1;
        double re = p[n];
        double im = 0.0;
        double xr = x.getRe();
        double xi = x.getIm();
        for (int i = n - 1; i >= i0; --i) {
            double rtmp = xr * re - xi * im + p[i];
            double itmp = xr * im + re * xi;
            re = rtmp;
            im = itmp;
        }
        f.val = Complex.cart((double)re, (double)im);
    }

    private static void fdvalue(double[] p, int i0, Ref<Complex> f, Ref<Complex> df, Complex x) {
        int n = p.length - 1;
        double xr = x.getRe();
        double xi = x.getIm();
        double fr2 = p[n];
        double fi = 0.0;
        double dfr2 = 0.0;
        double dfi = 0.0;
        for (int i = n - 1; i >= i0; --i) {
            double tr = xr * dfr2 - xi * dfi + fr2;
            double ti = xr * dfi + dfr2 * xi + fi;
            dfr2 = tr;
            dfi = ti;
            tr = xr * fr2 - xi * fi + p[i];
            ti = xr * fi + fr2 * xi;
            fr2 = tr;
            fi = ti;
        }
        df.val = Complex.cart((double)dfr2, (double)dfi);
        f.val = Complex.cart((double)fr2, (double)fi);
    }

    public MullerNewtonSolver() {
        this.MNOISESTART = 2.220446049250313E-14;
    }

    private void check_x_value(Ref<Complex> xb, Ref.DoubleRef f2absqb, Ref.BooleanRef rootd, double f1absq, double f2absq, double epsilon, Ref.IntRef noise) {
        if (f2absq <= 1.01 * f1absq && f2absq >= 0.99 * f1absq) {
            if (this.h2.abs() < 0.01) {
                this.q2 = this.q2.times(2.0);
                this.h2 = this.h2.times(2.0);
            } else {
                this.q2 = MullerNewtonSolver.getComplexForIterationCounter(this.iter);
                this.h2 = this.h2.times(this.q2);
            }
        } else if (f2absq < f2absqb.val) {
            f2absqb.val = f2absq;
            xb.val = this.x2;
            noise.val = 0;
            if (Math.sqrt(f2absq) < epsilon && this.x2.minus(this.x1).div(this.x2).abs() < epsilon) {
                rootd.val = true;
            }
        }
    }

    public void clear() {
        this.roots = null;
        this.remainder = null;
    }

    private void compute_function(double f1absq, Ref.DoubleRef f2absq, double epsilon) {
        Ref.IntRef overflow = new Ref.IntRef(0);
        do {
            overflow.val = 0;
            this.suppress_overflow();
            MullerNewtonSolver.fdvalue(this.reducedPolynomial, this.startIdx, this.f2, this.x2);
            this.too_big_functionvalues(f2absq);
            ++this.iter;
            this.convergence_check(overflow, f1absq, f2absq.val, epsilon);
        } while (overflow.val != 0);
    }

    private void convergence_check(Ref.IntRef overflow, double f1absq, double f2absq, double epsilon) {
        if (f2absq > 100.0 * f1absq && this.q2.abs() > epsilon && this.iter < 150) {
            this.q2 = this.q2.times(0.5);
            this.h2 = this.h2.times(0.5);
            this.x2 = this.x2.minus(this.h2);
            overflow.val = 1;
        }
    }

    @Override
    public boolean factorize(Polynomial p) {
        this.startIdx = 0;
        this.degree = p.degree();
        while (this.degree > 0 && p.get(this.degree) == 0.0) {
            --this.degree;
        }
        if (this.degree == 0) {
            return false;
        }
        this.roots = new Complex[this.degree];
        this.polynomial = p.toArray();
        this.reducedPolynomial = (double[])this.polynomial.clone();
        if (!this.newtonnull()) {
            return false;
        }
        for (int j = 1; j < this.degree; ++j) {
            Complex tmp = this.roots[j];
            for (int i = j - 1; i >= 0 && !(this.roots[i].getRe() <= tmp.getRe()); --i) {
                this.roots[i + 1] = this.roots[i];
            }
            this.roots[i + 1] = tmp;
        }
        this.remainder = Polynomial.valueOf(p.get(p.degree()), new double[0]);
        return true;
    }

    private void initialize(Ref<Complex> xb, Ref.DoubleRef epsilon) {
        this.x0 = Complex.ZERO;
        this.x1 = Complex.cart((double)(-ISQRT2), (double)(-ISQRT2));
        this.x2 = Complex.cart((double)ISQRT2, (double)ISQRT2);
        this.h1 = this.x1.minus(this.x0);
        this.h2 = this.x2.minus(this.x1);
        this.q2 = this.h2.div(this.h1);
        xb.val = this.x2;
        epsilon.val = 2.220446049250313E-11;
        this.iter = 0;
    }

    private void iteration_equation(Ref.DoubleRef h2abs) {
        this.h2 = this.h2.times(this.q2);
        double h2absnew = this.h2.abs();
        if (h2absnew > h2abs.val * 1000.0) {
            double help = 1000.0 / h2absnew;
            this.h2 = this.h2.times(help);
            this.q2 = this.q2.times(help);
        }
        h2abs.val = h2absnew;
        this.x2 = this.x2.plus(this.h2);
    }

    private boolean lin_or_quad() {
        int nred = this.reducedPolynomial.length - this.startIdx - 1;
        if (nred == 1) {
            this.roots[this.startIdx] = Complex.cart((double)(-this.reducedPolynomial[this.startIdx] / this.reducedPolynomial[this.startIdx + 1]));
            return true;
        }
        if (nred == 2) {
            this.quadratic();
            return true;
        }
        return false;
    }

    private void monic() {
        int n = this.polynomial.length - 1;
        double factor = Math.abs(1.0 / this.polynomial[n]);
        if (factor != 1.0) {
            int i = 0;
            while (i <= n) {
                int n2 = i++;
                this.polynomial[n2] = this.polynomial[n2] * factor;
            }
        }
    }

    private Complex muller() {
        double f1absq = 1.0E36;
        Ref.DoubleRef f2absq = new Ref.DoubleRef(1.0E36);
        Ref.DoubleRef f2absqb = new Ref.DoubleRef(1.0E36);
        Ref.DoubleRef h2abs = new Ref.DoubleRef(0.0);
        Ref.DoubleRef epsilon = new Ref.DoubleRef(0.0);
        Ref.IntRef seconditer = new Ref.IntRef(0);
        Ref.IntRef noise = new Ref.IntRef(0);
        Ref.BooleanRef rootd = new Ref.BooleanRef(false);
        Ref xb = new Ref((Object)Complex.ZERO);
        this.initialize((Ref<Complex>)xb, epsilon);
        MullerNewtonSolver.fdvalue(this.reducedPolynomial, this.startIdx, this.f0, this.x0);
        MullerNewtonSolver.fdvalue(this.reducedPolynomial, this.startIdx, this.f1, this.x1);
        MullerNewtonSolver.fdvalue(this.reducedPolynomial, this.startIdx, this.f2, this.x2);
        while (true) {
            this.root_of_parabola();
            this.x0 = this.x1;
            this.x1 = this.x2;
            h2abs.val = this.h2.abs();
            this.iteration_equation(h2abs);
            this.f0.val = this.f1.val;
            this.f1.val = this.f2.val;
            f1absq = f2absq.val;
            this.compute_function(f1absq, f2absq, epsilon.val);
            this.check_x_value((Ref<Complex>)xb, f2absqb, rootd, f1absq, f2absq.val, epsilon.val, noise);
            double xb_abs = ((Complex)xb.val).abs();
            if (Math.abs(xb_abs - this.x2.abs()) / xb_abs < this.MNOISESTART) {
                ++noise.val;
            }
            if (this.iter < 150 && !rootd.val && (double)noise.val <= 5.0) continue;
            ++seconditer.val;
            this.root_check(f2absqb.val, seconditer, rootd, noise, (Complex)xb.val);
            if (seconditer.val != 2) break;
        }
        return (Complex)xb.val;
    }

    private Complex newton(Complex ns, Ref.DoubleRef dxabs) {
        double axmin2;
        Complex xcur;
        double fabsmin = 1.0E36;
        double eps = 2.220446049250313E-16;
        int noise = 0;
        Complex xmin = xcur = ns;
        Complex dx = Complex.ONE;
        dxabs.val = dx.abs();
        for (int i = 0; i < 20; ++i) {
            double axmin;
            Complex dxh;
            Ref f = new Ref((Object)Complex.ZERO);
            Ref df = new Ref((Object)Complex.ZERO);
            MullerNewtonSolver.fdvalue(this.polynomial, 0, (Ref<Complex>)f, (Ref<Complex>)df, xcur);
            if (((Complex)f.val).abs() < fabsmin) {
                xmin = xcur;
                fabsmin = ((Complex)f.val).abs();
                noise = 0;
            }
            if (((Complex)df.val).abs() > eps && (dxh = ((Complex)f.val).div((Complex)df.val)).abs() < dxabs.val * 5.0) {
                dx = dxh;
                dxabs.val = dx.abs();
            }
            if ((axmin = xmin.abs()) != 0.0 && (dxabs.val / axmin < eps || noise == 5)) {
                if (Math.abs(xmin.getIm()) < this.NBOUND) {
                    xmin = Complex.cart((double)xmin.getRe(), (double)0.0);
                }
                dxabs.val /= axmin;
                return xmin;
            }
            xcur = xcur.minus(dx);
            ++noise;
        }
        if (Math.abs(xmin.getIm()) < this.NBOUND) {
            xmin = Complex.cart((double)xmin.getRe(), (double)0.0);
        }
        if ((axmin2 = xmin.abs()) != 0.0) {
            dxabs.val /= axmin2;
        }
        return xmin;
    }

    private boolean newtonnull() {
        Ref.DoubleRef newerr = new Ref.DoubleRef(0.0);
        this.maxError = 0.0;
        this.roots_at_zero();
        if (this.startIdx == this.polynomial.length - 1) {
            return true;
        }
        if (this.lin_or_quad()) {
            this.maxError = 2.220446049250313E-16;
            return true;
        }
        this.monic();
        do {
            Complex ns = this.muller();
            Complex nroot = this.newton(ns, newerr);
            if (newerr.val > this.maxError) {
                this.maxError = newerr.val;
            }
            if (nroot.getIm() == 0.0) {
                this.update(nroot.getRe());
                continue;
            }
            this.update(nroot);
        } while (this.polynomial.length - this.startIdx > 3);
        this.lin_or_quad();
        return true;
    }

    private void quadratic() {
        double a = this.reducedPolynomial[this.startIdx + 2];
        double b = this.reducedPolynomial[this.startIdx + 1];
        double c = this.reducedPolynomial[this.startIdx];
        double aa = 2.0 * a;
        double rdiscr = b * b - 4.0 * a * c;
        if (rdiscr < 0.0) {
            Complex r;
            double z = Math.sqrt(-rdiscr);
            this.roots[this.startIdx] = r = Complex.cart((double)(-b / aa), (double)(z / aa));
            this.roots[this.startIdx + 1] = r.conj();
        } else {
            double z = Math.sqrt(rdiscr);
            this.roots[this.startIdx] = Complex.cart((double)((-b + z) / aa));
            this.roots[this.startIdx + 1] = Complex.cart((double)((-b - z) / aa));
        }
    }

    @Override
    public Polynomial remainder() {
        return this.remainder;
    }

    private void root_check(double f2absqb, Ref.IntRef seconditer, Ref.BooleanRef rootd, Ref.IntRef noise, Complex xb) {
        Ref df = new Ref((Object)Complex.ZERO);
        if (seconditer.val == 1 && f2absqb > 0.0) {
            MullerNewtonSolver.fdvalue(this.reducedPolynomial, this.startIdx, this.f2, (Ref<Complex>)df, xb);
            if (((Complex)this.f2.val).abs() / (((Complex)df.val).abs() * xb.abs()) > 1.0E-5) {
                this.x0 = Complex.ONE;
                this.x1 = Complex.NEG_ONE;
                this.x2 = Complex.ZERO;
                MullerNewtonSolver.fdvalue(this.reducedPolynomial, this.startIdx, this.f0, this.x0);
                MullerNewtonSolver.fdvalue(this.reducedPolynomial, this.startIdx, this.f1, this.x1);
                MullerNewtonSolver.fdvalue(this.reducedPolynomial, this.startIdx, this.f2, this.x2);
                this.iter = 0;
                ++seconditer.val;
                rootd.val = false;
                noise.val = 0;
            }
        }
    }

    private void root_of_parabola() {
        double N2_abs;
        Complex A2 = MullerNewtonSolver.computeA2(this.q2, (Complex)this.f2.val, (Complex)this.f0.val, (Complex)this.f1.val);
        Complex B2 = MullerNewtonSolver.computeB2((Complex)this.f2.val, (Complex)this.f1.val, this.q2, (Complex)this.f0.val);
        Complex C2 = MullerNewtonSolver.computeC2(this.q2, (Complex)this.f2.val);
        Complex rdiscr = ComplexMath.sqrt((ComplexType)MullerNewtonSolver.computeDiscr(B2, A2, C2));
        Complex N1 = B2.minus(rdiscr);
        Complex N2 = B2.plus(rdiscr);
        double N1_abs = N1.abs();
        this.q2 = N1_abs > (N2_abs = N2.abs()) && N1_abs > 2.220446049250313E-16 ? new ComplexComputer((ComplexType)C2).mul(-2.0).div((ComplexType)N1).result() : (N2_abs > 2.220446049250313E-16 ? new ComplexComputer((ComplexType)C2).mul(-2.0).div((ComplexType)N2).result() : MullerNewtonSolver.getComplexForIterationCounter(this.iter));
    }

    static Complex computeA2(Complex q2, Complex f2, Complex f0, Complex f1) {
        double re0 = q2.getRe();
        double im0 = q2.getIm();
        double re1 = f2.getRe();
        double im1 = f2.getIm();
        double re2 = q2.getRe() * f0.getRe() - q2.getIm() * f0.getIm();
        double im2 = q2.getRe() * f0.getIm() + q2.getIm() * f0.getRe();
        re1 += re2;
        im1 += im2;
        re2 = 1.0 + q2.getRe();
        im2 = q2.getIm();
        double tmp = re2 * f1.getRe() - im2 * f1.getIm();
        im2 = re2 * f1.getIm() + im2 * f1.getRe();
        re2 = tmp;
        tmp = re0 * (re1 -= re2) - im0 * (im1 -= im2);
        im0 = re0 * im1 + im0 * re1;
        re0 = tmp;
        return Complex.cart((double)re0, (double)im0);
    }

    static Complex computeB2(Complex f2, Complex f1, Complex q2, Complex f0) {
        double re0 = f2.getRe() - f1.getRe();
        double im0 = f2.getIm() - f1.getIm();
        double re1 = q2.getRe();
        double im1 = q2.getIm();
        double re2 = q2.getRe();
        double im2 = q2.getIm();
        double re3 = f0.getRe() - f1.getRe();
        double im3 = f0.getIm() - f1.getIm();
        double tmp = re2 * re3 - im2 * im3;
        im2 = re2 * im3 + im2 * re3;
        re2 = tmp;
        re3 = f2.getRe() - f1.getRe();
        im3 = f2.getIm() - f1.getIm();
        tmp = re1 * (re2 += (re3 *= 2.0)) - im1 * (im2 += (im3 *= 2.0));
        im1 = re1 * im2 + im1 * re2;
        re1 = tmp;
        return Complex.cart((double)(re0 += re1), (double)(im0 += im1));
    }

    static Complex computeC2(Complex q2, Complex f2) {
        double re0 = 1.0 + q2.getRe();
        double im0 = q2.getIm();
        double tmp = re0 * f2.getRe() - im0 * f2.getIm();
        im0 = re0 * f2.getIm() + im0 * f2.getRe();
        re0 = tmp;
        return Complex.cart((double)re0, (double)im0);
    }

    static Complex computeDiscr(Complex B2, Complex A2, Complex C2) {
        double re0 = B2.getRe() * B2.getRe() - B2.getIm() * B2.getIm();
        double im0 = B2.getRe() * B2.getIm() + B2.getIm() * B2.getRe();
        double re1 = A2.getRe() * C2.getRe() - A2.getIm() * C2.getIm();
        double im1 = A2.getRe() * C2.getIm() + A2.getIm() * C2.getRe();
        return Complex.cart((double)(re0 -= (re1 *= 4.0)), (double)(im0 -= (im1 *= 4.0)));
    }

    @Override
    public Complex[] roots() {
        return this.roots;
    }

    private void roots_at_zero() {
        this.startIdx = 0;
        while (this.startIdx < this.polynomial.length && this.polynomial[this.startIdx] == 0.0) {
            this.roots[this.startIdx++] = Complex.ZERO;
        }
    }

    private void suppress_overflow() {
        int nred = this.reducedPolynomial.length - 1 - this.startIdx;
        boolean loop = false;
        int kiter = 0;
        do {
            loop = false;
            double help = this.x2.abs();
            if (!(help > 1.0) || !(Math.abs((double)nred * Math.log10(help)) > this.MBOUND6)) continue;
            if ((double)(++kiter) < 1000.0) {
                this.h2 = this.h2.times(0.5);
                this.q2 = this.q2.times(0.5);
                this.x2 = this.x2.minus(this.h2);
                loop = true;
                continue;
            }
            kiter = 0;
        } while (loop);
    }

    private void too_big_functionvalues(Ref.DoubleRef f2absq) {
        f2absq.val = Math.abs(((Complex)this.f2.val).getRe()) + Math.abs(((Complex)this.f2.val).getIm()) > this.MBOUND4 ? Math.abs(((Complex)this.f2.val).getRe()) + Math.abs(((Complex)this.f2.val).getIm()) : ((Complex)this.f2.val).absSquare();
    }

    private void update(Complex r0) {
        double a = 2.0 * r0.getRe();
        double b = -r0.absSquare();
        this.roots[this.startIdx++] = r0;
        this.roots[this.startIdx++] = r0.conj();
        int n = this.degree - 1;
        this.reducedPolynomial[n] = this.reducedPolynomial[n] + this.reducedPolynomial[this.degree] * a;
        for (int i = this.degree; i > this.startIdx; --i) {
            int n2 = i - 2;
            this.reducedPolynomial[n2] = this.reducedPolynomial[n2] + (a * this.reducedPolynomial[i - 1] + b * this.reducedPolynomial[i]);
        }
    }

    private void update(double r0) {
        this.roots[this.startIdx++] = Complex.cart((double)r0);
        for (int i = this.degree; i > this.startIdx; --i) {
            int n = i - 1;
            this.reducedPolynomial[n] = this.reducedPolynomial[n] + this.reducedPolynomial[i] * r0;
        }
    }

    private static Complex getComplexForIterationCounter(int iter) {
        return COMPLEX_FOR_ITER[iter];
    }

    private static Complex newComplexForIterationCounter(int iter) {
        return Complex.cart((double)Math.cos(iter), (double)Math.sin(iter));
    }

    private static Complex[] initComplexForIter(int maxIter) {
        Complex[] result = new Complex[maxIter + 1];
        for (int i = 0; i < result.length; ++i) {
            result[i] = MullerNewtonSolver.newComplexForIterationCounter(i);
        }
        return result;
    }
}

