/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling;

import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.AutoCovariances;
import lombok.Generated;

public class DifferencingResult {
    private final DoubleSeq original;
    private final DoubleSeq differenced;
    private final boolean meanCorrection;

    private static boolean checkStationarity(DoubleSeq data, int period) {
        IntToDoubleFunction cov = AutoCovariances.autoCovarianceFunction((DoubleSeq)data, (double)0.0);
        if (period <= 4) {
            double var = cov.applyAsDouble(0);
            for (int i = 1; i <= period; ++i) {
                if (!(cov.applyAsDouble(i) / var <= 0.2)) continue;
                return true;
            }
        } else {
            if (cov.applyAsDouble(period) <= 0.0) {
                return true;
            }
            for (int i = 1; i <= 4; ++i) {
                if (!(cov.applyAsDouble(i) <= 0.0)) continue;
                return true;
            }
        }
        return false;
    }

    public static DifferencingResult of(DoubleSeq input, int period, int delta, boolean mean) {
        if (delta < 0) {
            DoubleSeq del = input.delta(1, 1);
            if (!DifferencingResult.checkStationarity(del = del.removeMean(), period)) {
                del = del.delta(1, 1);
                return new DifferencingResult(input, del, false);
            }
            return new DifferencingResult(input, del, true);
        }
        DoubleSeq del = input.delta(1, delta);
        if (mean) {
            del = del.removeMean();
        }
        return new DifferencingResult(input, del, mean);
    }

    public int getDifferencingOrder() {
        return this.original.length() - this.differenced.length();
    }

    public DoubleSeq getRestrictedOriginal() {
        return this.original.drop(this.getDifferencingOrder(), 0);
    }

    @Generated
    public DoubleSeq getOriginal() {
        return this.original;
    }

    @Generated
    public DoubleSeq getDifferenced() {
        return this.differenced;
    }

    @Generated
    public boolean isMeanCorrection() {
        return this.meanCorrection;
    }

    @Generated
    private DifferencingResult(DoubleSeq original, DoubleSeq differenced, boolean meanCorrection) {
        this.original = original;
        this.differenced = differenced;
        this.meanCorrection = meanCorrection;
    }
}

