/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.extractors;

import jdplus.toolkit.base.api.information.DynamicMapping;
import jdplus.toolkit.base.api.information.InformationMapping;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsResiduals;
import lombok.Generated;

public final class TsResidualsExtractors {
    @Generated
    private TsResidualsExtractors() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class Dynamic
    extends DynamicMapping<TsResiduals, StatisticalTest> {
        public Dynamic() {
            super(null, v -> v.getTests());
        }

        public Class<TsResiduals> getSourceClass() {
            return TsResiduals.class;
        }

        public int getPriority() {
            return 0;
        }
    }

    public static class Specific
    extends InformationMapping<TsResiduals> {
        public Specific() {
            this.set("type", String.class, source -> source.getType().name());
            this.set("res", double[].class, source -> source.getRes().toArray());
            this.set("tsres", TsData.class, source -> source.getTsres());
            this.set("n", Integer.class, source -> source.getN());
            this.set("df", Integer.class, source -> source.getDf());
            this.set("dfc", Integer.class, source -> source.getDfc());
            this.set("ser", Double.class, source -> {
                int df = source.getDfc();
                return df == 0 ? Double.NaN : Math.sqrt(source.getSsq() / (double)df);
            });
            this.set("ser_ml", Double.class, source -> {
                int df = source.getN();
                return df == 0 ? Double.NaN : Math.sqrt(source.getSsq() / (double)df);
            });
            this.addTest("mean");
            this.addTest("doornikhansen");
            this.addTest("skewness");
            this.addTest("kurtosis");
            this.addTest("lb");
            this.addTest("bp");
            this.addTest("seaslb");
            this.addTest("seasbp");
            this.addTest("lb2");
            this.addTest("bp2");
            this.addTest("nruns");
            this.addTest("lruns");
            this.addTest("nudruns");
            this.addTest("ludruns");
        }

        private void addTest(String k) {
            this.set(k, StatisticalTest.class, source -> (StatisticalTest)source.getTests().get(k));
        }

        public Class<TsResiduals> getSourceClass() {
            return TsResiduals.class;
        }

        public int getPriority() {
            return 1;
        }
    }
}

