/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TimeSeriesInterval;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import jdplus.toolkit.base.api.timeseries.calendars.Easter;
import jdplus.toolkit.base.api.timeseries.regression.JulianEasterVariable;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.RegressionVariableFactory;

class JulianEasterFactory
implements RegressionVariableFactory<JulianEasterVariable> {
    private static final int CYCLE = 532;
    private static final int[] C_MAR = new int[]{0, 0, 0, 4, 16, 36, 68, 116, 180, 264, 364, 480, 616, 768, 936, 1124, 1328, 1552, 1796, 2056, 2336, 2632, 2944, 3276, 3624, 3988, 4372, 4772};
    private static final int[] C_APR = new int[]{452, 924, 1412, 1908, 2408, 2908, 3404, 3888, 4356, 4804, 5236, 5652, 6048, 6428, 6792, 7136, 7464, 7772, 8060, 8332, 8584, 8820, 9040, 9240, 9424, 9592, 9740, 9872};
    private static final int[] C_MAY = new int[]{80, 140, 184, 216, 236, 248, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252};
    private static final int TWOCYCLE = 1064;
    private static final int[] C_MAR2 = new int[]{1, 3, 8, 22, 51, 91, 145, 226, 343, 488, 657, 858, 1099, 1379, 1692, 2036, 2414, 2828, 3284, 3779, 4307, 4866, 5458, 6092, 6764, 7469, 8204, 8971};
    private static final int[] C_APR2 = new int[]{878, 1784, 2713, 3664, 4633, 5613, 6586, 7547, 8484, 9400, 10293, 11155, 11978, 12762, 13513, 14233, 14919, 15569, 16177, 16746, 17282, 17787, 18259, 18689, 19081, 19440, 19769, 20066};
    private static final int[] C_MAY2 = new int[]{185, 341, 471, 570, 636, 680, 717, 739, 749, 752, 754, 755, 755, 755, 755, 755, 755, 755, 755, 755, 755, 755, 755, 755, 755, 755, 755, 755};
    static JulianEasterFactory FACTORY = new JulianEasterFactory();

    private JulianEasterFactory() {
    }

    @Override
    public boolean fill(JulianEasterVariable var, TsPeriod start, FastMatrix buffer, ProcessingLog log) {
        if (start.getUnit().getAnnualFrequency() <= 2) {
            return false;
        }
        DataBlock data = buffer.column(0);
        int freq = start.getUnit().getAnnualFrequency();
        if (freq < 3) {
            return false;
        }
        int duration = var.getDuration();
        double q = 1064 * duration;
        int n = data.length();
        int y = start.year();
        TsPeriod march = TsPeriod.monthly((int)y, (int)3);
        TsPeriod april = TsPeriod.monthly((int)y, (int)4);
        TsPeriod may = TsPeriod.monthly((int)y, (int)5);
        LocalDate beg = start.start().toLocalDate();
        LocalDate end = start.plus((long)n).start().toLocalDate();
        while (true) {
            LocalDate easter;
            if (beg.isBefore(easter = Easter.julianEaster((int)y, (boolean)var.isGregorianDates()))) {
                int n2;
                LocalDate pbeg = easter.minusDays(duration);
                int n0 = (int)pbeg.until(march.end().toLocalDate(), ChronoUnit.DAYS);
                if (n0 < 0) {
                    n0 = 0;
                }
                if ((n2 = (int)may.start().toLocalDate().until(easter, ChronoUnit.DAYS)) < 0) {
                    n2 = 0;
                } else if (n2 > duration) {
                    n2 = duration;
                }
                int n1 = duration - n0 - n2;
                double dur = duration;
                TsPeriod cur = TsPeriod.of((TsUnit)start.getUnit(), (LocalDate)march.start().toLocalDate());
                int ipos = start.until(cur);
                if (ipos >= 0 && ipos < n) {
                    data.add(ipos, (double)n0 / dur - (double)C_MAR2[duration - 1] / q);
                }
                if ((ipos = start.until(cur = TsPeriod.of((TsUnit)start.getUnit(), (LocalDate)april.start().toLocalDate()))) >= 0 && ipos < n) {
                    data.add(ipos, (double)n1 / dur - (double)C_APR2[duration - 1] / q);
                }
                if ((ipos = start.until(cur = TsPeriod.of((TsUnit)start.getUnit(), (LocalDate)may.start().toLocalDate()))) >= 0 && ipos < n) {
                    data.add(ipos, (double)n2 / dur - (double)C_MAY2[duration - 1] / q);
                }
            }
            if ((march = march.plus(12L)).isAfter(TsPeriod.of((TsUnit)TsUnit.P1M, (LocalDate)end))) break;
            april = april.plus(12L);
            may = may.plus(12L);
            ++y;
        }
        return true;
    }

    @Override
    public <P extends TimeSeriesInterval<?>, D extends TimeSeriesDomain<P>> boolean fill(JulianEasterVariable var, D domain, FastMatrix buffer, ProcessingLog log) {
        throw new UnsupportedOperationException("Not supported.");
    }
}

