/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.basic;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.ssf.multivariate.ISsfErrors;
import lombok.Generated;

public final class MeasurementsError {
    public static ISsfErrors of(FastMatrix H, FastMatrix R) {
        return new Errors(H, R);
    }

    public static ISsfErrors of(DoubleSeq var) {
        double[] v = var.toArray();
        for (int i = 0; i < v.length; ++i) {
            if (!(v[i] > 0.0)) continue;
            return new IndependentErrors(v);
        }
        return null;
    }

    public static ISsfErrors of(double var) {
        return new IndependentErrors2(var);
    }

    @Generated
    private MeasurementsError() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class Errors
    implements ISsfErrors {
        private final FastMatrix H;
        private final FastMatrix R;

        private Errors(FastMatrix H, FastMatrix R) {
            this.H = H != null ? H : SymmetricMatrix.LLt(R);
            if (R != null) {
                this.R = R;
            } else {
                this.R = H.deepClone();
                SymmetricMatrix.lcholesky(this.R, 1.0E-9);
            }
        }

        @Override
        public boolean areIndependent() {
            return false;
        }

        @Override
        public void H(int pos, FastMatrix h) {
            h.copy(this.H);
        }

        @Override
        public void R(int pos, FastMatrix r) {
            r.copy(this.R);
        }

        @Override
        public void addH(int pos, FastMatrix V) {
            V.add(this.H);
        }

        @Override
        public boolean isTimeInvariant() {
            return true;
        }
    }

    private static class IndependentErrors
    implements ISsfErrors {
        private final double[] v;
        private final double[] e;

        private IndependentErrors(double[] v) {
            this.v = v;
            this.e = (double[])this.v.clone();
            for (int i = 0; i < this.e.length; ++i) {
                this.e[i] = v[i] <= 0.0 ? 0.0 : Math.sqrt(v[i]);
            }
        }

        @Override
        public boolean areIndependent() {
            return true;
        }

        @Override
        public void H(int pos, FastMatrix h) {
            h.diagonal().copyFrom(this.v, 0);
        }

        @Override
        public void R(int pos, FastMatrix r) {
            r.diagonal().copyFrom(this.e, 0);
        }

        @Override
        public void addH(int pos, FastMatrix V) {
            V.diagonal().add(t -> this.v[t]);
        }

        @Override
        public boolean isTimeInvariant() {
            return true;
        }
    }

    private static class IndependentErrors2
    implements ISsfErrors {
        private final double v;
        private final double e;

        private IndependentErrors2(double v) {
            this.v = v;
            this.e = Math.sqrt(v);
        }

        @Override
        public boolean areIndependent() {
            return true;
        }

        @Override
        public void H(int pos, FastMatrix h) {
            h.diagonal().set(this.v);
        }

        @Override
        public void R(int pos, FastMatrix r) {
            r.diagonal().set(this.e);
        }

        @Override
        public void addH(int pos, FastMatrix V) {
            V.diagonal().add(this.v);
        }

        @Override
        public boolean isTimeInvariant() {
            return true;
        }
    }
}

