/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.benchmarking;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.ssf.DiffuseInitialization;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.StateComponent;
import jdplus.toolkit.base.core.ssf.basic.Loading;
import lombok.Generated;

public final class SsfSpline {
    public static ISsfLoading defaultLoading() {
        return Loading.fromPosition(0);
    }

    public static StateComponent of(double d) {
        return new StateComponent(new DiffuseInitialization(2), new SimpleDynamics(d));
    }

    public static StateComponent of(double[] d) {
        return new StateComponent(new DiffuseInitialization(2), new Dynamics(d));
    }

    @Generated
    private SsfSpline() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class SimpleDynamics
    implements ISsfDynamics {
        private final double d;
        private final FastMatrix vm;
        private final FastMatrix sm;

        SimpleDynamics(double d) {
            this.d = d;
            double d2 = d * d;
            double d3 = d2 * d;
            this.vm = FastMatrix.square(2);
            this.vm.set(0, 0, d3 / 3.0);
            this.vm.set(0, 1, d2 / 2.0);
            this.vm.set(1, 0, d2 / 2.0);
            this.vm.set(1, 1, d);
            this.sm = FastMatrix.square(2);
            this.sm.copy(this.vm);
            SymmetricMatrix.lcholesky(this.sm);
        }

        @Override
        public int getInnovationsDim() {
            return 2;
        }

        @Override
        public void V(int pos, FastMatrix qm) {
            qm.copy(this.vm);
        }

        @Override
        public void S(int pos, FastMatrix m) {
            m.copy(this.sm);
        }

        @Override
        public boolean hasInnovations(int pos) {
            return true;
        }

        @Override
        public boolean areInnovationsTimeInvariant() {
            return true;
        }

        @Override
        public void T(int pos, FastMatrix tr) {
            tr.diagonal().set(1.0);
            tr.set(0, 1, this.d);
        }

        @Override
        public void TX(int pos, DataBlock x) {
            x.add(0, this.d * x.get(1));
        }

        @Override
        public void addSU(int pos, DataBlock x, DataBlock u) {
            x.addProduct(this.sm.rowsIterator(), u);
        }

        @Override
        public void addV(int pos, FastMatrix p) {
            p.add(this.vm);
        }

        @Override
        public void XT(int pos, DataBlock x) {
            x.add(1, this.d * x.get(0));
        }

        @Override
        public void XS(int pos, DataBlock x, DataBlock xs) {
            xs.set(0, x.dot(this.sm.column(0)));
            xs.set(1, x.dot(this.sm.column(1)));
        }

        @Override
        public boolean isTimeInvariant() {
            return true;
        }
    }

    static class Dynamics
    implements ISsfDynamics {
        private final double[] d;

        Dynamics(double[] d) {
            this.d = d;
        }

        @Override
        public int getInnovationsDim() {
            return 2;
        }

        @Override
        public void V(int pos, FastMatrix vm) {
            double d1 = this.d[pos];
            double d2 = d1 * d1;
            double d3 = d2 * d1;
            vm.set(0, 0, d3 / 3.0);
            vm.set(0, 1, d2 / 2.0);
            vm.set(1, 0, d2 / 2.0);
            vm.set(1, 1, d1);
        }

        @Override
        public boolean hasInnovations(int pos) {
            return true;
        }

        @Override
        public boolean areInnovationsTimeInvariant() {
            return false;
        }

        @Override
        public void T(int pos, FastMatrix tr) {
            tr.diagonal().set(1.0);
            tr.set(0, 1, this.d[pos]);
        }

        @Override
        public void TX(int pos, DataBlock x) {
            x.add(0, this.d[pos] * x.get(1));
        }

        @Override
        public void addV(int pos, FastMatrix p) {
            double d1 = this.d[pos];
            double d2 = d1 * d1;
            double d3 = d2 * d1;
            p.add(0, 0, d3 / 3.0);
            p.add(0, 1, d2 / 2.0);
            p.add(1, 0, d2 / 2.0);
            p.add(1, 1, d1);
        }

        @Override
        public void XT(int pos, DataBlock x) {
            x.add(1, this.d[pos] * x.get(0));
        }

        @Override
        public boolean isTimeInvariant() {
            return false;
        }

        @Override
        public void S(int pos, FastMatrix cm) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void addSU(int pos, DataBlock x, DataBlock u) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void XS(int pos, DataBlock x, DataBlock xs) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

