/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.sts;

import internal.toolkit.base.core.math.functions.gsl.interpolation.CubicSplines;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.StateComponent;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class RegularSplineComponent {
    public static ISsfLoading loading(Data data, int startPos) {
        return new Loading(data.getZ(), data.getPeriod(), startPos);
    }

    public static StateComponent stateComponent(int[] xi, double var) {
        Data data = Data.of(xi);
        Dynamics dynamics = new Dynamics(data.getQ(), var);
        Initialization initialization = new Initialization(data.getDim());
        return new StateComponent(initialization, dynamics);
    }

    public static StateComponent stateComponent(Data data, double var) {
        Dynamics dynamics = new Dynamics(data.getQ(), var);
        Initialization initialization = new Initialization(data.getDim());
        return new StateComponent(initialization, dynamics);
    }

    @Generated
    private RegularSplineComponent() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class Loading
    implements ISsfLoading {
        private final int startpos;
        private final int period;
        private final FastMatrix Z;

        public Loading(FastMatrix Z, int period, int startpos) {
            this.Z = Z;
            this.period = period;
            this.startpos = startpos;
        }

        private DataBlock z(int pos) {
            return this.Z.row((pos + this.startpos) % this.period);
        }

        @Override
        public boolean isTimeInvariant() {
            return false;
        }

        @Override
        public void Z(int pos, DataBlock z) {
            z.copy(this.z(pos));
        }

        @Override
        public double ZX(int pos, DataBlock m) {
            return this.z(pos).dot(m);
        }

        @Override
        public void ZM(int pos, FastMatrix m, DataBlock zm) {
            DataBlock row = this.z(pos);
            zm.set(m.columnsIterator(), x -> row.dot(x));
        }

        @Override
        public void MZt(int pos, FastMatrix m, DataBlock zm) {
            DataBlock row = this.z(pos);
            zm.set(m.rowsIterator(), x -> row.dot(x));
        }

        @Override
        public double ZVZ(int pos, FastMatrix V) {
            DataBlock row = this.z(pos);
            DataBlock zv = DataBlock.make(V.getColumnsCount());
            zv.product(row, V.columnsIterator());
            return zv.dot(row);
        }

        @Override
        public void VpZdZ(int pos, FastMatrix V, double d) {
            if (d == 0.0) {
                return;
            }
            DataBlockIterator cols = V.columnsIterator();
            DataBlock row = this.z(pos);
            DoubleSeqCursor.OnMutable z = row.cursor();
            while (cols.hasNext()) {
                cols.next().addAY(d * z.getAndNext(), row);
            }
        }

        @Override
        public void XpZd(int pos, DataBlock x, double d) {
            x.addAY(d, this.z(pos));
        }
    }

    public static final class Data {
        private final FastMatrix Q;
        private final FastMatrix Z;
        private final int period;
        private final int dim;

        public static Data of(int[] xi) {
            DoubleSeq X = DoubleSeq.onMapping((int)xi.length, k -> xi[k]);
            int dim = xi.length - 1;
            int period = xi[dim];
            double[] wstar = new double[dim];
            FastMatrix Z = FastMatrix.make(period, dim);
            for (int i = 0; i < dim; ++i) {
                double[] f = new double[dim + 1];
                if (i == 0) {
                    f[0] = 1.0;
                    f[dim] = 1.0;
                } else {
                    f[i] = 1.0;
                }
                CubicSplines.Spline node = CubicSplines.periodic(X, DoubleSeq.of((double[])f));
                DoubleSeqCursor.OnMutable cursor = Z.column(i).cursor();
                double s = 0.0;
                for (int j = 0; j < period; ++j) {
                    double w = node.applyAsDouble(j);
                    cursor.setAndNext(w);
                    s += w;
                }
                wstar[i] = s;
            }
            DataBlock zh = Z.column(dim - 1);
            double wh = wstar[dim - 1];
            for (int i = 0; i < dim - 1; ++i) {
                Z.column(i).addAY(-wstar[i] / wh, zh);
            }
            DataBlock W = DataBlock.of(wstar, 0, dim);
            FastMatrix Q = FastMatrix.identity(dim - 1);
            Q.addXaXt(-1.0 / W.ssq(), W.drop(0, 1));
            return new Data(Q, Z.dropBottomRight(0, 1), period, dim - 1);
        }

        @Generated
        public FastMatrix getQ() {
            return this.Q;
        }

        @Generated
        public FastMatrix getZ() {
            return this.Z;
        }

        @Generated
        public int getPeriod() {
            return this.period;
        }

        @Generated
        public int getDim() {
            return this.dim;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Data)) {
                return false;
            }
            Data other = (Data)o;
            if (this.getPeriod() != other.getPeriod()) {
                return false;
            }
            if (this.getDim() != other.getDim()) {
                return false;
            }
            FastMatrix this$Q = this.getQ();
            FastMatrix other$Q = other.getQ();
            if (this$Q == null ? other$Q != null : !this$Q.equals(other$Q)) {
                return false;
            }
            FastMatrix this$Z = this.getZ();
            FastMatrix other$Z = other.getZ();
            return !(this$Z == null ? other$Z != null : !this$Z.equals(other$Z));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPeriod();
            result = result * 59 + this.getDim();
            FastMatrix $Q = this.getQ();
            result = result * 59 + ($Q == null ? 43 : $Q.hashCode());
            FastMatrix $Z = this.getZ();
            result = result * 59 + ($Z == null ? 43 : $Z.hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "RegularSplineComponent.Data(Q=" + String.valueOf(this.getQ()) + ", Z=" + String.valueOf(this.getZ()) + ", period=" + this.getPeriod() + ", dim=" + this.getDim() + ")";
        }

        @Generated
        private Data(FastMatrix Q, FastMatrix Z, int period, int dim) {
            this.Q = Q;
            this.Z = Z;
            this.period = period;
            this.dim = dim;
        }
    }

    static class Dynamics
    implements ISsfDynamics {
        private final FastMatrix var;
        private final FastMatrix s;

        Dynamics(FastMatrix Q, double var) {
            this.var = Q.times(var);
            this.s = this.var.deepClone();
            SymmetricMatrix.lcholesky(this.s, 1.0E-9);
            LowerTriangularMatrix.toLower(this.s);
        }

        @Override
        public boolean isTimeInvariant() {
            return true;
        }

        @Override
        public boolean areInnovationsTimeInvariant() {
            return true;
        }

        @Override
        public int getInnovationsDim() {
            return this.var.getColumnsCount();
        }

        @Override
        public void V(int pos, FastMatrix qm) {
            qm.copy(this.var);
        }

        @Override
        public boolean hasInnovations(int pos) {
            return true;
        }

        @Override
        public void S(int pos, FastMatrix sm) {
            sm.copy(this.s);
        }

        @Override
        public void addSU(int pos, DataBlock x, DataBlock u) {
            x.addProduct(this.s.rowsIterator(), u);
        }

        @Override
        public void XS(int pos, DataBlock x, DataBlock xs) {
            xs.product(x, this.s.columnsIterator());
        }

        @Override
        public void T(int pos, FastMatrix tr) {
            tr.diagonal().set(1.0);
        }

        @Override
        public void TX(int pos, DataBlock x) {
        }

        @Override
        public void XT(int pos, DataBlock x) {
        }

        @Override
        public void TVT(int pos, FastMatrix v) {
        }

        @Override
        public void addV(int pos, FastMatrix p) {
            p.add(this.var);
        }
    }

    static class Initialization
    implements ISsfInitialization {
        private final int dim;

        Initialization(int dim) {
            this.dim = dim;
        }

        @Override
        public int getStateDim() {
            return this.dim;
        }

        @Override
        public boolean isDiffuse() {
            return true;
        }

        @Override
        public int getDiffuseDim() {
            return this.dim;
        }

        @Override
        public void diffuseConstraints(FastMatrix b) {
            b.diagonal().set(1.0);
        }

        @Override
        public void a0(DataBlock a0) {
        }

        @Override
        public void Pf0(FastMatrix pf0) {
        }

        @Override
        public void Pi0(FastMatrix pi0) {
            pi0.diagonal().set(1.0);
        }
    }
}

