/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.likelihood;

import jdplus.toolkit.base.api.eco.EcoException;

public class DeterminantalTerm {
    private static final double LOG2 = Math.log(2.0);
    private double detcar;
    private double detman = 1.0;

    public void add(double var) {
        this.update(var);
    }

    public void clear() {
        this.detman = 1.0;
        this.detcar = 0.0;
    }

    public double factor(int n) {
        double det = Math.pow(this.detman, 1.0 / (double)n);
        return det *= Math.pow(2.0, this.detcar / (double)n);
    }

    public double getLogDeterminant() {
        return Math.log(this.detman) + this.detcar * LOG2;
    }

    public void remove(double var) {
        this.update(1.0 / var);
    }

    private void update(double var) {
        if (!Double.isFinite(var)) {
            throw new EcoException("Invalid variance");
        }
        if (var <= 0.0) {
            throw new EcoException("Negative variance");
        }
        this.detman *= var;
        while (this.detman >= 1.0) {
            this.detman *= 0.0625;
            this.detcar += 4.0;
        }
        while (this.detman != 0.0 && this.detman <= 0.0625) {
            this.detman *= 16.0;
            this.detcar -= 4.0;
        }
    }
}

