/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.likelihood;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihood;
import jdplus.toolkit.base.core.stats.likelihood.DiffuseLikelihoodStatistics;
import jdplus.toolkit.base.core.stats.likelihood.InternalDiffuseConcentratedLikelihood;

public interface DiffuseConcentratedLikelihood
extends ConcentratedLikelihood {
    public static Builder builder(int n, int nd, int nxd) {
        return new Builder(n, nd, nxd);
    }

    public int ndiffuse();

    public int ndiffuseRegressors();

    public double diffuseCorrection();

    public DiffuseConcentratedLikelihood rescale(double var1, double[] var3);

    @Override
    default public int degreesOfFreedom() {
        return this.dim() - (this.nx() - this.ndiffuseRegressors()) - this.ndiffuse();
    }

    default public DiffuseLikelihoodStatistics stats(double llcorrection, int nparams) {
        return DiffuseLikelihoodStatistics.builder().logLikelihood(this.logLikelihood()).logDeterminant(this.logDeterminant()).diffuseCorrection(this.diffuseCorrection()).transformationAdjustment(llcorrection).observationsCount(this.dim()).ssqErr(this.ssq()).diffuseCount(this.ndiffuse()).estimatedParametersCount(nparams + (this.nx() - this.ndiffuseRegressors())).build();
    }

    public static class Builder {
        private final int n;
        private final int nd;
        private final int nxd;
        private double ssqerr;
        private double ldet;
        private double lddet;
        private double[] res;
        private boolean legacy;
        private double[] b;
        private FastMatrix bvar;
        private boolean scalingFactor = true;

        Builder(int n, int nd, int nxd) {
            this.n = n;
            this.nd = nd;
            this.nxd = nxd;
        }

        public Builder scalingFactor(boolean scalingFactor) {
            this.scalingFactor = scalingFactor;
            return this;
        }

        public Builder logDeterminant(double ldet) {
            this.ldet = ldet;
            return this;
        }

        public Builder logDiffuseDeterminant(double lddet) {
            this.lddet = lddet;
            return this;
        }

        public Builder ssqErr(double ssq) {
            this.ssqerr = ssq;
            return this;
        }

        public Builder legacy(boolean legacy) {
            this.legacy = legacy;
            return this;
        }

        public Builder residuals(DoubleSeq residuals) {
            if (residuals == null) {
                return this;
            }
            if (this.ssqerr == 0.0) {
                this.ssqerr = residuals.ssq();
            }
            this.res = residuals.toArray();
            return this;
        }

        public Builder coefficients(DoubleSeq coeff) {
            if (coeff != null) {
                this.b = coeff.toArray();
            }
            return this;
        }

        public Builder unscaledCovariance(FastMatrix var) {
            this.bvar = var;
            return this;
        }

        public DiffuseConcentratedLikelihood build() {
            return new InternalDiffuseConcentratedLikelihood(this.n, this.nd, this.nxd, this.ssqerr, this.ldet, this.lddet, this.b, this.bvar, this.res, this.legacy, this.scalingFactor);
        }
    }
}

