/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.tests;

import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.dstats.DStatException;
import jdplus.toolkit.base.api.stats.AutoCovariances;
import jdplus.toolkit.base.api.stats.StatException;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.core.stats.DescriptiveStatistics;
import jdplus.toolkit.base.core.stats.tests.BoxPierce;
import jdplus.toolkit.base.core.stats.tests.DoornikHansen;
import jdplus.toolkit.base.core.stats.tests.Kurtosis;
import jdplus.toolkit.base.core.stats.tests.LjungBox;
import jdplus.toolkit.base.core.stats.tests.Mean;
import jdplus.toolkit.base.core.stats.tests.Skewness;
import jdplus.toolkit.base.core.stats.tests.TestOfRuns;
import jdplus.toolkit.base.core.stats.tests.TestOfUpDownRuns;

public class NiidTests {
    private double[] ac;
    private double[] ac2;
    private StatisticalTest ljungBox;
    private StatisticalTest ljungBoxOnSquares;
    private StatisticalTest seasonalLjungBox;
    private StatisticalTest boxPierce;
    private StatisticalTest boxPierceOnSquares;
    private StatisticalTest seasonalBoxPierce;
    private StatisticalTest mean;
    private StatisticalTest doornikHansen;
    private StatisticalTest skewness;
    private StatisticalTest kurtosis;
    private StatisticalTest runsNumber;
    private StatisticalTest runsLength;
    private StatisticalTest upAndDownRunsNumber;
    private StatisticalTest upAndDownRunsLength;
    private final DoubleSeq data;
    private final DoubleSeq data2;
    private final DescriptiveStatistics stat;
    private final DescriptiveStatistics stat2;
    private final int period;
    private final int hyperParameters;
    private final int k;
    private final int ks;
    private final boolean seasonal;

    public static Builder builder() {
        return new Builder();
    }

    private NiidTests(DoubleSeq data, int period, int nhp, int k, int ks, boolean seas) {
        this.data = data;
        this.stat = DescriptiveStatistics.of(data);
        this.period = period;
        this.seasonal = seas;
        this.hyperParameters = nhp;
        this.k = k;
        this.ks = ks;
        double[] d2 = data.toArray();
        for (int i = 0; i < d2.length; ++i) {
            double cur = d2[i];
            d2[i] = Double.isFinite(cur) ? cur * cur : Double.NaN;
        }
        this.data2 = DoubleSeq.of((double[])d2);
        this.stat2 = DescriptiveStatistics.of(this.data2);
    }

    public DoubleSeq data() {
        return this.data;
    }

    public int getPeriod() {
        return this.period;
    }

    public int getK() {
        return this.k;
    }

    public int getKs() {
        return this.ks;
    }

    public int getHyperParametersCount() {
        return this.hyperParameters;
    }

    public boolean isSeasonal() {
        return this.seasonal;
    }

    public IntToDoubleFunction autoCorrelations() {
        if (this.ac == null) {
            int kmax = this.k;
            if (this.seasonal) {
                kmax = Math.max(this.k, this.ks * this.period);
            }
            this.ac = new double[kmax];
            IntToDoubleFunction acf = AutoCovariances.autoCorrelationFunction((DoubleSeq)this.data, (double)0.0);
            for (int i = 0; i < this.ac.length; ++i) {
                this.ac[i] = acf.applyAsDouble(i + 1);
            }
        }
        return k -> this.ac[k - 1];
    }

    public IntToDoubleFunction autoCorrelationsOnSquares() {
        if (this.ac2 == null) {
            this.ac2 = new double[this.k];
            double mu = this.data2.averageWithMissing();
            IntToDoubleFunction acf = AutoCovariances.autoCorrelationFunction((DoubleSeq)this.data2, (double)mu);
            for (int i = 0; i < this.ac2.length; ++i) {
                this.ac2[i] = acf.applyAsDouble(i + 1);
            }
        }
        return k -> this.ac2[k - 1];
    }

    public StatisticalTest boxPierce() {
        if (this.boxPierce == null) {
            try {
                this.boxPierce = new BoxPierce(this.autoCorrelations(), this.stat.getObservationsCount()).autoCorrelationsCount(this.k).lag(1).hyperParametersCount(this.hyperParameters).build();
            }
            catch (DStatException | StatException ex) {
                this.boxPierce = null;
                return null;
            }
        }
        return this.boxPierce;
    }

    public StatisticalTest boxPierce(int lk) {
        try {
            return new BoxPierce(this.autoCorrelations(), this.stat.getObservationsCount()).autoCorrelationsCount(lk).lag(1).hyperParametersCount(this.hyperParameters).build();
        }
        catch (DStatException | StatException ex) {
            return null;
        }
    }

    public StatisticalTest boxPierceOnSquare() {
        if (this.boxPierceOnSquares == null) {
            try {
                this.boxPierceOnSquares = new BoxPierce(this.autoCorrelationsOnSquares(), this.stat.getObservationsCount()).autoCorrelationsCount(this.k).lag(1).hyperParametersCount(this.hyperParameters).build();
            }
            catch (DStatException | StatException ex) {
                this.boxPierceOnSquares = null;
                return null;
            }
        }
        return this.boxPierceOnSquares;
    }

    public StatisticalTest boxPierceOnSquare(int lk) {
        try {
            return new BoxPierce(this.autoCorrelationsOnSquares(), this.stat.getObservationsCount()).autoCorrelationsCount(lk).lag(1).hyperParametersCount(this.hyperParameters).build();
        }
        catch (DStatException | StatException ex) {
            return null;
        }
    }

    public StatisticalTest ljungBox() {
        if (this.ljungBox == null) {
            try {
                this.ljungBox = new LjungBox(this.autoCorrelations(), this.stat.getObservationsCount()).autoCorrelationsCount(this.k).lag(1).hyperParametersCount(this.hyperParameters).build();
            }
            catch (DStatException | StatException ex) {
                this.ljungBox = null;
                return null;
            }
        }
        return this.ljungBox;
    }

    public StatisticalTest ljungBox(int lk) {
        try {
            return new LjungBox(this.autoCorrelations(), this.stat.getObservationsCount()).autoCorrelationsCount(lk).lag(1).hyperParametersCount(this.hyperParameters).build();
        }
        catch (DStatException | StatException ex) {
            return null;
        }
    }

    public StatisticalTest ljungBoxOnSquare() {
        if (this.ljungBoxOnSquares == null) {
            try {
                this.ljungBoxOnSquares = new LjungBox(this.autoCorrelationsOnSquares(), this.stat.getObservationsCount()).autoCorrelationsCount(this.k).lag(1).hyperParametersCount(this.hyperParameters).build();
            }
            catch (DStatException | StatException ex) {
                this.ljungBoxOnSquares = null;
                return null;
            }
        }
        return this.ljungBoxOnSquares;
    }

    public StatisticalTest ljungBoxOnSquare(int lk) {
        try {
            return new LjungBox(this.autoCorrelationsOnSquares(), this.stat.getObservationsCount()).autoCorrelationsCount(lk).lag(1).hyperParametersCount(this.hyperParameters).build();
        }
        catch (DStatException | StatException ex) {
            return null;
        }
    }

    public StatisticalTest meanTest() {
        if (this.mean == null) {
            try {
                this.mean = Mean.zeroMean(this.data).build();
            }
            catch (DStatException | StatException ex) {
                this.mean = null;
                return null;
            }
        }
        return this.mean;
    }

    public StatisticalTest normalityTest() {
        if (this.doornikHansen == null) {
            try {
                this.doornikHansen = new DoornikHansen(this.stat).build();
            }
            catch (DStatException | StatException ex) {
                this.doornikHansen = null;
                return null;
            }
        }
        return this.doornikHansen;
    }

    public StatisticalTest skewness() {
        if (this.skewness == null) {
            try {
                this.skewness = new Skewness(this.stat).build();
            }
            catch (DStatException | StatException ex) {
                this.skewness = null;
                return null;
            }
        }
        return this.skewness;
    }

    public StatisticalTest kurtosis() {
        if (this.kurtosis == null) {
            try {
                this.kurtosis = new Kurtosis(this.stat).build();
            }
            catch (DStatException | StatException ex) {
                this.kurtosis = null;
                return null;
            }
        }
        return this.kurtosis;
    }

    public StatisticalTest runsNumber() {
        if (this.runsNumber == null) {
            try {
                this.runsNumber = new TestOfRuns(this.stat).testNumber();
            }
            catch (DStatException | StatException ex) {
                this.runsNumber = null;
                return null;
            }
        }
        return this.runsNumber;
    }

    public StatisticalTest runsLength() {
        if (this.runsLength == null) {
            try {
                this.runsLength = new TestOfRuns(this.stat).testLength();
            }
            catch (DStatException | StatException ex) {
                this.runsLength = null;
                return null;
            }
        }
        return this.runsLength;
    }

    public StatisticalTest upAndDownRunsNumbber() {
        if (this.upAndDownRunsNumber == null) {
            try {
                this.upAndDownRunsNumber = new TestOfUpDownRuns(this.data).testNumber();
            }
            catch (DStatException | StatException ex) {
                this.upAndDownRunsNumber = null;
                return null;
            }
        }
        return this.upAndDownRunsNumber;
    }

    public StatisticalTest upAndDownRunsLength() {
        if (this.upAndDownRunsLength == null) {
            try {
                this.upAndDownRunsLength = new TestOfUpDownRuns(this.data).testLength();
            }
            catch (DStatException | StatException ex) {
                this.upAndDownRunsLength = null;
                return null;
            }
        }
        return this.upAndDownRunsLength;
    }

    public StatisticalTest seasonalBoxPierce() {
        if (!this.seasonal) {
            return null;
        }
        if (this.seasonalBoxPierce == null) {
            try {
                this.seasonalBoxPierce = new BoxPierce(this.autoCorrelations(), this.stat.getObservationsCount()).hyperParametersCount(this.hyperParameters).lag(this.period).autoCorrelationsCount(this.ks).usePositiveAutoCorrelations().build();
            }
            catch (DStatException | StatException ex) {
                this.seasonalBoxPierce = null;
                return null;
            }
        }
        return this.seasonalBoxPierce;
    }

    public StatisticalTest seasonalBoxPierce(int lk) {
        if (!this.seasonal) {
            return null;
        }
        try {
            return new BoxPierce(this.autoCorrelations(), this.stat.getObservationsCount()).hyperParametersCount(this.hyperParameters).lag(this.period).autoCorrelationsCount(lk).usePositiveAutoCorrelations().build();
        }
        catch (DStatException | StatException ex) {
            return null;
        }
    }

    public StatisticalTest seasonalLjungBox() {
        if (!this.seasonal) {
            return null;
        }
        if (this.seasonalLjungBox == null) {
            try {
                this.seasonalLjungBox = new LjungBox(this.autoCorrelations(), this.stat.getObservationsCount()).hyperParametersCount(this.hyperParameters).lag(this.period).autoCorrelationsCount(this.ks).usePositiveAutoCorrelations().build();
            }
            catch (DStatException | StatException ex) {
                this.seasonalLjungBox = null;
                return null;
            }
        }
        return this.seasonalLjungBox;
    }

    public StatisticalTest seasonalLjungBox(int lk) {
        if (!this.seasonal) {
            return null;
        }
        try {
            return new LjungBox(this.autoCorrelations(), this.stat.getObservationsCount()).hyperParametersCount(this.hyperParameters).lag(this.period).autoCorrelationsCount(lk).usePositiveAutoCorrelations().build();
        }
        catch (DStatException | StatException ex) {
            return null;
        }
    }

    public static class Builder {
        private DoubleSeq data;
        private int period;
        private int hyperParameters = 0;
        private int k = 24;
        private int ks = 2;
        private boolean seasonal = true;
        private boolean defaultTestsLength = true;

        public static int acTestsLength(int period) {
            return switch (period) {
                case 12 -> 24;
                case 1 -> 8;
                default -> 4 * period;
            };
        }

        public Builder data(DoubleSeq data) {
            this.data = data;
            return this;
        }

        public Builder period(int period) {
            this.period = period;
            if (period == 1) {
                this.seasonal = false;
            }
            return this;
        }

        public Builder hyperParametersCount(int n) {
            this.hyperParameters = n;
            return this;
        }

        public Builder seasonal(boolean seasonal) {
            this.seasonal = seasonal;
            return this;
        }

        public Builder defaultTestsLength() {
            this.defaultTestsLength = true;
            return this;
        }

        public Builder k(int k) {
            this.k = k;
            return this;
        }

        public Builder ks(int ks) {
            this.ks = ks;
            return this;
        }

        public NiidTests build() {
            if (this.period == 0) {
                throw new IllegalArgumentException();
            }
            int nk = this.k;
            if (this.defaultTestsLength) {
                nk = Builder.acTestsLength(this.period);
            }
            return new NiidTests(this.data, this.period, this.hyperParameters, nk, this.ks, this.seasonal);
        }
    }
}

