/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.information.formatters;

import java.text.NumberFormat;
import java.util.Locale;
import jdplus.toolkit.base.api.information.formatters.InformationFormatter;
import jdplus.toolkit.base.api.math.Complex;

public final class ComplexFormatter
implements InformationFormatter {
    @Override
    public int getDefaultRepresentationLength() {
        return 2;
    }

    @Override
    public String format(Object obj, int item, Locale locale) {
        Complex c = (Complex)obj;
        if (item == 0) {
            return c.toString();
        }
        NumberFormat fmt = InformationFormatter.df4(locale);
        switch (Math.abs(item)) {
            case 1: {
                return fmt.format(c.abs());
            }
            case 2: {
                double arg = c.arg();
                if (arg == 0.0) {
                    return null;
                }
                double period = Math.PI * 2 / arg;
                if (period < -1.999999 && period > -2.000001) {
                    return "2";
                }
                return fmt.format(period);
            }
        }
        return null;
    }
}

