/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.processing;

public enum ProcQuality {
    Accepted(-1),
    Undefined(0),
    Error(1),
    Severe(2),
    Bad(3),
    Uncertain(4),
    Good(5);

    private final int value;

    public static ProcQuality valueOf(int value) {
        ProcQuality[] values = ProcQuality.values();
        for (int i = 0; i < values.length; ++i) {
            if (values[i].value != value) continue;
            return values[i];
        }
        return null;
    }

    public boolean isAtLeast(ProcQuality quality) {
        return this.value > 0 && this.value >= quality.value;
    }

    public boolean isLower(ProcQuality quality) {
        return this.value > 0 && this.value < quality.value;
    }

    private ProcQuality(int value) {
        this.value = value;
    }

    public int intValue() {
        return this.value;
    }
}

