/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import jdplus.toolkit.base.api.information.Explorable;
import jdplus.toolkit.base.api.processing.ProcSpecification;
import jdplus.toolkit.base.api.processing.ProcessingStatus;
import jdplus.toolkit.base.api.timeseries.MultiTsDocument;
import jdplus.toolkit.base.api.timeseries.Ts;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsFactory;
import jdplus.toolkit.base.api.timeseries.TsInformationType;
import lombok.NonNull;

public abstract class AbstractMultiTsDocument<S extends ProcSpecification, R extends Explorable>
implements MultiTsDocument<S, R> {
    private final UUID uuid;
    private Map<String, String> metadata = Collections.emptyMap();
    @NonNull
    private S specification;
    private List<Ts> input;
    private R result;
    private volatile ProcessingStatus status = ProcessingStatus.Unprocessed;

    protected AbstractMultiTsDocument(S spec) {
        this.specification = spec;
        this.uuid = UUID.randomUUID();
        this.input = Collections.emptyList();
    }

    private void clear() {
        this.result = null;
        this.status = ProcessingStatus.Unprocessed;
    }

    @Override
    public List<Ts> getInput() {
        return this.input;
    }

    @Override
    public S getSpecification() {
        return this.specification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(S newSpec, List<Ts> newInput) {
        AbstractMultiTsDocument abstractMultiTsDocument = this;
        synchronized (abstractMultiTsDocument) {
            this.specification = newSpec;
            this.input = Collections.unmodifiableList(newInput);
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(S newSpec) {
        AbstractMultiTsDocument abstractMultiTsDocument = this;
        synchronized (abstractMultiTsDocument) {
            this.specification = newSpec;
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(List<Ts> newInput) {
        AbstractMultiTsDocument abstractMultiTsDocument = this;
        synchronized (abstractMultiTsDocument) {
            this.input = Collections.unmodifiableList(newInput);
            this.clear();
        }
    }

    @Override
    public void setMetadata(Map<String, String> newMetadata) {
        this.metadata = Collections.unmodifiableMap(newMetadata);
    }

    @Override
    public void updateMetadata(Map<String, String> update) {
        HashMap<String, String> md = new HashMap<String, String>(this.metadata);
        md.putAll(update);
        this.metadata = Collections.unmodifiableMap(md);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessingStatus process() {
        ProcessingStatus cur = this.status;
        if (cur == ProcessingStatus.Unprocessed) {
            AbstractMultiTsDocument abstractMultiTsDocument = this;
            synchronized (abstractMultiTsDocument) {
                if (this.status == ProcessingStatus.Unprocessed) {
                    this.rawProcess();
                }
                cur = this.status;
            }
        }
        return cur;
    }

    private boolean hasData() {
        for (Ts cur : this.input) {
            if (!cur.getData().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private boolean check() {
        if (this.input == null) {
            return false;
        }
        if (this.hasData()) {
            return true;
        }
        ArrayList<Ts> ninput = new ArrayList<Ts>(this.input);
        int j = 0;
        for (Ts cur : ninput) {
            if (!cur.getData().isEmpty()) continue;
            Ts s = TsFactory.getDefault().makeTs(cur.getMoniker(), TsInformationType.Data);
            if (s.getData().isEmpty()) {
                throw new IllegalArgumentException("No data");
            }
            ninput.set(j, s);
        }
        this.input = Collections.unmodifiableList(ninput);
        return true;
    }

    private List<TsData> data() {
        return this.input.stream().map(s -> s.getData()).toList();
    }

    private void rawProcess() {
        if (this.check()) {
            try {
                this.result = this.internalProcess(this.specification, this.data());
                this.status = this.result == null ? ProcessingStatus.Invalid : ProcessingStatus.Valid;
            }
            catch (Exception err) {
                HashMap<String, String> md = new HashMap<String, String>(this.metadata);
                md.put("@error", err.getLocalizedMessage());
                this.result = null;
                this.status = ProcessingStatus.Invalid;
            }
        } else {
            this.result = null;
            this.status = ProcessingStatus.Unprocessed;
        }
    }

    protected abstract R internalProcess(S var1, List<TsData> var2);

    @Override
    public UUID getKey() {
        return this.uuid;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R getResult() {
        ProcessingStatus cur = this.status;
        if (cur == ProcessingStatus.Unprocessed) {
            AbstractMultiTsDocument abstractMultiTsDocument = this;
            synchronized (abstractMultiTsDocument) {
                if (this.status == ProcessingStatus.Unprocessed) {
                    this.rawProcess();
                }
            }
        }
        return this.result;
    }

    @Override
    public ProcessingStatus getStatus() {
        return this.status;
    }

    @Override
    public void setAll(S spec, List<Ts> input, R result) {
        this.input = Collections.unmodifiableList(input);
        this.specification = spec;
        this.result = result;
        this.status = result != null ? ProcessingStatus.Valid : ProcessingStatus.Invalid;
    }
}

