/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries;

import java.util.List;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.timeseries.CalendarPeriod;
import jdplus.toolkit.base.api.timeseries.CalendarPeriodObs;
import jdplus.toolkit.base.api.timeseries.CalendarPeriods;
import jdplus.toolkit.base.api.timeseries.TimeSeriesData;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;

public class CalendarTimeSeries
implements TimeSeriesData<CalendarPeriod, CalendarPeriodObs> {
    private final CalendarPeriods domain;
    private final DoubleSeq values;

    public static CalendarTimeSeries of(List<CalendarPeriodObs> data) {
        int n = data.size();
        CalendarPeriod[] periods = new CalendarPeriod[n];
        double[] v = new double[n];
        int pos = 0;
        for (CalendarPeriodObs obs : data) {
            periods[pos] = obs.getPeriod();
            v[pos++] = obs.getValue();
        }
        return new CalendarTimeSeries(CalendarPeriods.of(periods), DoubleSeq.of(v));
    }

    private CalendarTimeSeries(CalendarPeriods domain, DoubleSeq values) {
        this.domain = domain;
        this.values = values;
    }

    @Override
    public TimeSeriesDomain<CalendarPeriod> getDomain() {
        return this.domain;
    }

    @Override
    public DoubleSeq getValues() {
        return this.values;
    }

    @Override
    public CalendarPeriodObs get(int index) throws IndexOutOfBoundsException {
        return CalendarPeriodObs.of(this.domain.get(index), this.values.get(index));
    }

    @Override
    public int length() {
        return this.values.length();
    }
}

