/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries.calendars;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import jdplus.toolkit.base.api.timeseries.ValidityPeriod;
import jdplus.toolkit.base.api.timeseries.calendars.Easter;
import jdplus.toolkit.base.api.timeseries.calendars.Holiday;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class EasterRelatedDay
implements Holiday {
    private static final Map<Integer, LocalDate> DIC = new HashMap<Integer, LocalDate>();
    private static final Map<Integer, LocalDate> JDIC = new HashMap<Integer, LocalDate>();
    private final int offset;
    private final double weight;
    private final ValidityPeriod validityPeriod;
    private final boolean julian;
    public static final EasterRelatedDay SHROVEMONDAY = EasterRelatedDay.gregorian(-48);
    public static final EasterRelatedDay SHROVETUESDAY = EasterRelatedDay.gregorian(-47);
    public static final EasterRelatedDay ASHWEDNESDAY = EasterRelatedDay.gregorian(-46);
    public static final EasterRelatedDay EASTER = EasterRelatedDay.gregorian(0);
    public static final EasterRelatedDay EASTERMONDAY = EasterRelatedDay.gregorian(1);
    public static final EasterRelatedDay EASTERFRIDAY = EasterRelatedDay.gregorian(-2);
    public static final EasterRelatedDay EASTERTHURSDAY = EasterRelatedDay.gregorian(-3);
    public static final EasterRelatedDay ASCENSION = EasterRelatedDay.gregorian(39);
    public static final EasterRelatedDay PENTECOST = EasterRelatedDay.gregorian(49);
    public static final EasterRelatedDay WHITMONDAY = EasterRelatedDay.gregorian(50);
    public static final EasterRelatedDay CORPUSCHRISTI = EasterRelatedDay.gregorian(60);
    public static final EasterRelatedDay JULIAN_SHROVEMONDAY = EasterRelatedDay.julian(-48);
    public static final EasterRelatedDay JULIAN_SHROVETUESDAY = EasterRelatedDay.julian(-47);
    public static final EasterRelatedDay JULIAN_ASHWEDNESDAY = EasterRelatedDay.julian(-46);
    public static final EasterRelatedDay JULIAN_EASTER = EasterRelatedDay.julian(0);
    public static final EasterRelatedDay JULIAN_EASTERMONDAY = EasterRelatedDay.julian(1);
    public static final EasterRelatedDay JULIAN_EASTERFRIDAY = EasterRelatedDay.julian(-2);
    public static final EasterRelatedDay JULIAN_EASTERTHURSDAY = EasterRelatedDay.julian(-3);
    public static final EasterRelatedDay JULIAN_ASCENSION = EasterRelatedDay.julian(39);
    public static final EasterRelatedDay JULIAN_PENTECOST = EasterRelatedDay.julian(49);
    public static final EasterRelatedDay JULIAN_WHITMONDAY = EasterRelatedDay.julian(50);
    public static final EasterRelatedDay JULIAN_CORPUSCHRISTI = EasterRelatedDay.julian(60);

    public static EasterRelatedDay gregorian(int offset, double weight, ValidityPeriod validityPeriod) {
        return new EasterRelatedDay(offset, weight, validityPeriod, false);
    }

    public static EasterRelatedDay gregorian(int offset) {
        return new EasterRelatedDay(offset, 1.0, ValidityPeriod.ALWAYS, false);
    }

    public static EasterRelatedDay julian(int offset, double weight, ValidityPeriod validityPeriod) {
        return new EasterRelatedDay(offset, weight, validityPeriod, true);
    }

    public static EasterRelatedDay julian(int offset) {
        return new EasterRelatedDay(offset, 1.0, ValidityPeriod.ALWAYS, true);
    }

    private EasterRelatedDay(int offset, double weight, ValidityPeriod validityPeriod, boolean julian) {
        this.weight = weight;
        this.offset = offset;
        this.validityPeriod = validityPeriod;
        this.julian = julian;
    }

    @Override
    public EasterRelatedDay reweight(double nweight) {
        if (nweight == this.weight) {
            return this;
        }
        return new EasterRelatedDay(this.offset, nweight, this.validityPeriod, this.julian);
    }

    @Override
    public EasterRelatedDay forPeriod(LocalDate start, LocalDate end) {
        if (this.validityPeriod.getStart().equals(start) && this.validityPeriod.getEnd().equals(end)) {
            return this;
        }
        return new EasterRelatedDay(this.offset, this.weight, ValidityPeriod.between(start, end), this.julian);
    }

    public EasterRelatedDay plus(int ndays) {
        return new EasterRelatedDay(this.offset + ndays, this.weight, this.validityPeriod, this.julian);
    }

    public LocalDate calcDay(int year) {
        LocalDate d = this.easter(year);
        if (this.offset != 0) {
            d = d.plusDays(this.offset);
        }
        return d;
    }

    private LocalDate easter(int year) {
        return EasterRelatedDay.easter(year, this.julian);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocalDate easter(int year, boolean jul) {
        if (jul) {
            Map<Integer, LocalDate> map = JDIC;
            synchronized (map) {
                LocalDate e = JDIC.get(year);
                if (e == null) {
                    e = Easter.julianEaster(year, true);
                    JDIC.put(year, e);
                }
                return e;
            }
        }
        Map<Integer, LocalDate> map = DIC;
        synchronized (map) {
            LocalDate e = DIC.get(year);
            if (e == null) {
                e = Easter.easter(year);
                DIC.put(year, e);
            }
            return e;
        }
    }

    @Override
    public String display() {
        if (this.offset == 0) {
            return "easter";
        }
        if (this.offset < 0) {
            return "easter-" + -this.offset;
        }
        return "easter+" + this.offset;
    }

    @Generated
    public int getOffset() {
        return this.offset;
    }

    @Override
    @Generated
    public double getWeight() {
        return this.weight;
    }

    @Override
    @Generated
    public ValidityPeriod getValidityPeriod() {
        return this.validityPeriod;
    }

    @Generated
    public boolean isJulian() {
        return this.julian;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EasterRelatedDay)) {
            return false;
        }
        EasterRelatedDay other = (EasterRelatedDay)o;
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        if (Double.compare(this.getWeight(), other.getWeight()) != 0) {
            return false;
        }
        if (this.isJulian() != other.isJulian()) {
            return false;
        }
        ValidityPeriod this$validityPeriod = this.getValidityPeriod();
        ValidityPeriod other$validityPeriod = other.getValidityPeriod();
        return !(this$validityPeriod == null ? other$validityPeriod != null : !((Object)this$validityPeriod).equals(other$validityPeriod));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOffset();
        long $weight = Double.doubleToLongBits(this.getWeight());
        result = result * 59 + (int)($weight >>> 32 ^ $weight);
        result = result * 59 + (this.isJulian() ? 79 : 97);
        ValidityPeriod $validityPeriod = this.getValidityPeriod();
        result = result * 59 + ($validityPeriod == null ? 43 : ((Object)$validityPeriod).hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "EasterRelatedDay(offset=" + this.getOffset() + ", weight=" + this.getWeight() + ", validityPeriod=" + String.valueOf(this.getValidityPeriod()) + ", julian=" + this.isJulian() + ")";
    }
}

