/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.api.diagnostics;

import jdplus.sa.base.api.diagnostics.CombinedSeasonalityTest;
import jdplus.sa.base.api.diagnostics.SeasonalityTestsLoader;
import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.design.InterchangeableProcessor;
import jdplus.toolkit.base.api.stats.OneWayAnova;
import jdplus.toolkit.base.api.stats.StatisticalTest;

public class SeasonalityTests {
    private final SeasonalityTestsLoader.Factory FACTORY = new SeasonalityTestsLoader.Factory();

    public void seFactory(Factory factory) {
        this.FACTORY.set(factory);
    }

    public Factory getFactory() {
        return this.FACTORY.get();
    }

    public OneWayAnova stableSeasonalityTest(DoubleSeq x, int period) {
        return this.getFactory().stableSeasonalityTest(x, period);
    }

    public OneWayAnova evolutiveSeasonalityTest(DoubleSeq x, int period, int startPos, double xbar) {
        return this.getFactory().evolutiveSeasonalityTest(x, period, startPos, xbar);
    }

    public CombinedSeasonalityTest combinedTest(DoubleSeq x, int period, int startperiod, double xbar) {
        return this.getFactory().combinedTest(x, period, startperiod, xbar);
    }

    public StatisticalTest friedmanTest(DoubleSeq data, int period) {
        return this.getFactory().qsTest(data, period, period);
    }

    public StatisticalTest kruskalWallisTest(DoubleSeq data, int period) {
        return this.getFactory().kruskalWallisTest(data, period);
    }

    public StatisticalTest qsTest(DoubleSeq data, int period, int nlags) {
        return this.getFactory().qsTest(data, period, nlags);
    }

    public StatisticalTest fTest(DoubleSeq data, int period, SarimaOrders.Prespecified model) {
        return this.getFactory().fTest(data, period, model);
    }

    @InterchangeableProcessor
    public static interface Factory {
        public OneWayAnova stableSeasonalityTest(DoubleSeq var1, int var2);

        public OneWayAnova evolutiveSeasonalityTest(DoubleSeq var1, int var2, int var3, double var4);

        public CombinedSeasonalityTest combinedTest(DoubleSeq var1, int var2, int var3, double var4);

        public StatisticalTest friedmanTest(DoubleSeq var1, int var2);

        public StatisticalTest kruskalWallisTest(DoubleSeq var1, int var2);

        public StatisticalTest qsTest(DoubleSeq var1, int var2, int var3);

        public StatisticalTest fTest(DoubleSeq var1, int var2, SarimaOrders.Prespecified var3);
    }
}

