/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r.Network;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Agency;
import com.conveyal.gtfs.model.Route;
import com.conveyal.gtfs.model.Service;
import com.conveyal.gtfs.model.Shape;
import com.conveyal.gtfs.model.Stop;
import com.conveyal.gtfs.model.StopTime;
import com.conveyal.gtfs.model.Trip;
import com.conveyal.r5.transit.DuplicateFeedException;
import com.conveyal.r5.transit.RouteInfo;
import com.conveyal.r5.transit.TransitLayer;
import com.conveyal.r5.transit.TripPattern;
import com.conveyal.r5.transit.TripSchedule;
import com.conveyal.r5.util.LocationIndexedLineInLocalCoordinateSystem;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.zone.ZoneRulesException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.stream.DoubleStream;
import java.util.stream.StreamSupport;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.linearref.LinearLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitLayerWithShapes
extends TransitLayer {
    public static final boolean SAVE_SHAPES = true;
    private static final Logger LOG = LoggerFactory.getLogger(TransitLayerWithShapes.class);

    public void loadFromGtfs(GTFSFeed gtfs, TransitLayer.LoadLevel level) throws DuplicateFeedException {
        if (this.feedChecksums.containsKey(gtfs.feedId)) {
            throw new DuplicateFeedException(gtfs.feedId);
        }
        this.feedChecksums.put(gtfs.feedId, gtfs.checksum);
        TObjectIntHashMap indexForUnscopedStopId = new TObjectIntHashMap();
        this.stopsWheelchair = new BitSet(gtfs.stops.size());
        for (Stop stop : gtfs.stops.values()) {
            int stopIndex = this.stopIdForIndex.size();
            String scopedStopId = String.join((CharSequence)":", stop.feed_id, stop.stop_id);
            indexForUnscopedStopId.put((Object)stop.stop_id, stopIndex);
            this.stopIdForIndex.add(scopedStopId);
            this.fareZoneForStop.add(stop.zone_id);
            this.parentStationIdForStop.add(stop.parent_station);
            this.stopForIndex.add(stop);
            if (stop.wheelchair_boarding != null && stop.wheelchair_boarding.trim().equals("1")) {
                this.stopsWheelchair.set(stopIndex);
            }
            if (level != TransitLayer.LoadLevel.FULL) continue;
            this.stopNames.add(stop.stop_name);
        }
        TObjectIntHashMap serviceCodeNumber = new TObjectIntHashMap(20, 0.5f, -1);
        gtfs.services.forEach((arg_0, arg_1) -> this.lambda$loadFromGtfs$0((TObjectIntMap)serviceCodeNumber, arg_0, arg_1));
        LOG.info("Creating trip patterns and schedules.");
        HashMap<String, TripPattern> tripPatternForPatternId = new HashMap<String, TripPattern>();
        HashMultimap tripsForBlock = HashMultimap.create();
        TObjectIntHashMap routeIndexForRoute = new TObjectIntHashMap();
        int nTripsAdded = 0;
        int nZeroDurationHops = 0;
        block6: for (String tripId : gtfs.trips.keySet()) {
            Iterable stopTimes;
            Trip trip = (Trip)gtfs.trips.get((Object)tripId);
            Route route = (Route)gtfs.routes.get(trip.route_id);
            String scopedRouteId = String.join((CharSequence)":", gtfs.feedId, trip.route_id);
            TIntArrayList arrivals = new TIntArrayList(30);
            TIntArrayList departures = new TIntArrayList(30);
            TIntArrayList stopSequences = new TIntArrayList(30);
            int previousDeparture = Integer.MIN_VALUE;
            int nStops = 0;
            try {
                stopTimes = gtfs.getInterpolatedStopTimesForTrip(tripId);
            }
            catch (GTFSFeed.FirstAndLastStopsDoNotHaveTimes e) {
                LOG.warn("First and last stops do not both have times specified on trip {} on route {}, skipping this as interpolation is impossible", (Object)trip.trip_id, (Object)trip.route_id);
                continue;
            }
            for (StopTime st2 : stopTimes) {
                arrivals.add(st2.arrival_time);
                departures.add(st2.departure_time);
                stopSequences.add(st2.stop_sequence);
                if (previousDeparture > st2.arrival_time || st2.arrival_time > st2.departure_time) {
                    LOG.warn("Negative-time travel at stop {} on trip {} on route {}, skipping this trip as it will wreak havoc with routing", new Object[]{st2.stop_id, trip.trip_id, trip.route_id});
                    continue block6;
                }
                if (previousDeparture == st2.arrival_time) {
                    ++nZeroDurationHops;
                }
                previousDeparture = st2.departure_time;
                ++nStops;
            }
            if (nStops == 0) {
                LOG.warn("Trip {} on route {} {} has no stops, it will not be used", new Object[]{trip.trip_id, trip.route_id, route.route_short_name});
                continue;
            }
            String patternId = (String)gtfs.patternForTrip.get(tripId);
            TripPattern tripPattern = (TripPattern)tripPatternForPatternId.get(patternId);
            if (tripPattern == null) {
                tripPattern = new TripPattern(String.format("%s:%s", gtfs.feedId, route.route_id), stopTimes, (TObjectIntMap)indexForUnscopedStopId);
                if (level == TransitLayer.LoadLevel.FULL) {
                    if (!routeIndexForRoute.containsKey((Object)trip.route_id)) {
                        int routeIndex = this.routes.size();
                        RouteInfo ri = new RouteInfo(route, (Agency)gtfs.agency.get(route.agency_id));
                        this.routes.add(ri);
                        routeIndexForRoute.put((Object)trip.route_id, routeIndex);
                    }
                    tripPattern.routeIndex = routeIndexForRoute.get((Object)trip.route_id);
                    if (trip.shape_id != null) {
                        Shape shape = gtfs.getShape(trip.shape_id);
                        if (shape == null) {
                            LOG.warn("Shape {} for trip {} was missing", (Object)trip.shape_id, (Object)trip.trip_id);
                        } else {
                            LinearLocation[] locations;
                            tripPattern.shape = shape.geometry;
                            boolean stopsHaveShapeDistTraveled = StreamSupport.stream(stopTimes.spliterator(), false).noneMatch(st -> Double.isNaN(st.shape_dist_traveled));
                            boolean shapePointsHaveDistTraveled = DoubleStream.of(shape.shape_dist_traveled).noneMatch(Double::isNaN);
                            if (stopsHaveShapeDistTraveled && shapePointsHaveDistTraveled) {
                                locations = (LinearLocation[])StreamSupport.stream(stopTimes.spliterator(), false).map(st -> {
                                    int segment;
                                    double dist = st.shape_dist_traveled;
                                    for (segment = 0; segment < shape.shape_dist_traveled.length - 2 && dist > shape.shape_dist_traveled[segment + 1]; ++segment) {
                                    }
                                    double endSegment = shape.shape_dist_traveled[segment + 1];
                                    double beginSegment = shape.shape_dist_traveled[segment];
                                    double proportion = (dist - beginSegment) / (endSegment - beginSegment);
                                    return new LinearLocation(segment, proportion);
                                }).toArray(LinearLocation[]::new);
                            } else {
                                LocationIndexedLineInLocalCoordinateSystem line = new LocationIndexedLineInLocalCoordinateSystem(shape.geometry.getCoordinates());
                                locations = (LinearLocation[])StreamSupport.stream(stopTimes.spliterator(), false).map(st -> {
                                    Stop stop = (Stop)gtfs.stops.get(st.stop_id);
                                    return line.project(new Coordinate(stop.stop_lon, stop.stop_lat));
                                }).toArray(LinearLocation[]::new);
                            }
                            tripPattern.stopShapeSegment = new int[locations.length];
                            tripPattern.stopShapeFraction = new float[locations.length];
                            for (int i = 0; i < locations.length; ++i) {
                                tripPattern.stopShapeSegment[i] = locations[i].getSegmentIndex();
                                tripPattern.stopShapeFraction[i] = (float)locations[i].getSegmentFraction();
                            }
                        }
                    }
                }
                tripPatternForPatternId.put(patternId, tripPattern);
                tripPattern.originalId = this.tripPatterns.size();
                this.tripPatterns.add(tripPattern);
            }
            tripPattern.setOrVerifyDirection(trip.direction_id);
            int serviceCode = serviceCodeNumber.get((Object)trip.service_id);
            Collection frequencies = gtfs.getFrequencies(trip.trip_id);
            TripSchedule tripSchedule = TripSchedule.create((Trip)trip, (int[])arrivals.toArray(), (int[])departures.toArray(), (Collection)frequencies, (int[])stopSequences.toArray(), (int)serviceCode);
            if (tripSchedule == null) continue;
            tripPattern.addTrip(tripSchedule);
            this.hasFrequencies = this.hasFrequencies || tripSchedule.headwaySeconds != null;
            this.hasSchedules = this.hasSchedules || tripSchedule.headwaySeconds == null;
            ++nTripsAdded;
            if (Strings.isNullOrEmpty((String)trip.block_id)) continue;
            tripsForBlock.put((Object)trip.block_id, (Object)tripSchedule);
        }
        LOG.info("Done creating {} trips on {} patterns.", (Object)nTripsAdded, (Object)tripPatternForPatternId.size());
        LOG.info("{} zero-duration hops found.", (Object)nZeroDurationHops);
        LOG.info("Chaining trips together according to blocks to model interlining...");
        tripsForBlock.asMap().forEach((blockId, trips) -> {
            Object[] schedules = trips.toArray(new TripSchedule[trips.size()]);
            Arrays.sort(schedules);
            for (int i = 0; i < schedules.length - 1; ++i) {
                schedules[i].chainTo((TripSchedule)schedules[i + 1]);
            }
        });
        LOG.info("Done chaining trips together according to blocks.");
        LOG.info("Sorting trips on each pattern");
        for (TripPattern tripPattern : tripPatternForPatternId.values()) {
            Collections.sort(tripPattern.tripSchedules);
        }
        LOG.info("done sorting");
        LOG.info("Finding the approximate center of the transport network...");
        this.findCenter(gtfs.stops.values());
        if (gtfs.agency.size() == 0) {
            this.timeZone = ZoneId.of("GMT");
            LOG.warn("graph contains no agencies; API request times will be interpreted as GMT.");
        } else {
            for (Agency agency : gtfs.agency.values()) {
                ZoneId tz;
                if (agency.agency_timezone == null) {
                    LOG.warn("Agency {} is without timezone", (Object)agency.agency_name);
                    continue;
                }
                try {
                    tz = ZoneId.of(agency.agency_timezone);
                }
                catch (ZoneRulesException z) {
                    LOG.error("Agency {} in GTFS with timezone '{}' wasn't found in timezone database reason: {}", new Object[]{agency.agency_name, agency.agency_timezone, z.getMessage()});
                    continue;
                }
                catch (DateTimeException dt) {
                    LOG.error("Agency {} in GTFS has timezone in wrong format:'{}'. Expected format: area/city ", (Object)agency.agency_name, (Object)agency.agency_timezone);
                    continue;
                }
                if (this.timeZone == null) {
                    LOG.info("TransportNetwork time zone set to {} from agency '{}' and agency_timezone:{}", new Object[]{tz, agency.agency_name, agency.agency_timezone});
                    this.timeZone = tz;
                    continue;
                }
                if (this.timeZone.equals(tz)) continue;
                LOG.error("agency time zone {} differs from TransportNetwork time zone: {}. This will be problematic.", (Object)tz, (Object)this.timeZone);
            }
            if (this.timeZone == null) {
                this.timeZone = ZoneId.of("GMT");
                LOG.warn("No agency in graph had valid timezone; API request times will be interpreted as GMT.");
            }
        }
        if (level == TransitLayer.LoadLevel.FULL) {
            this.fares = new HashMap(gtfs.fares);
        }
    }

    private void findCenter(Collection<Stop> stops) {
        double lonSum = 0.0;
        double latSum = 0.0;
        for (Stop stop : stops) {
            latSum += stop.stop_lat;
            lonSum += stop.stop_lon;
        }
        this.centerLat = latSum / (double)stops.size();
        this.centerLon = lonSum / (double)stops.size();
    }

    private /* synthetic */ void lambda$loadFromGtfs$0(TObjectIntMap serviceCodeNumber, String serviceId, Service service) {
        int serviceIndex = this.services.size();
        this.services.add(service);
        serviceCodeNumber.put((Object)serviceId, serviceIndex);
        LOG.debug("Service {} has ID {}", (Object)serviceIndex, (Object)serviceId);
    }
}

