/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.binary;

import org.chocosolver.sat.Reason;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

@Explained
public class PropNotEqualX_Y
extends Propagator<IntVar> {
    private final IntVar x;
    private final IntVar y;

    public PropNotEqualX_Y(IntVar x, IntVar y) {
        super((Variable[])ArrayUtils.toArray(x, y), (Priority)PropagatorPriority.BINARY, false);
        this.x = ((IntVar[])this.vars)[0];
        this.y = ((IntVar[])this.vars)[1];
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (((IntVar[])this.vars)[vIdx].hasEnumeratedDomain()) {
            return IntEventType.instantiation();
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.x.isInstantiated() && this.y.isInstantiated() && this.x.isInstantiatedTo(this.y.getValue())) {
            this.fails(this.lcg() ? Reason.r(this.x.getValLit(), this.y.getValLit()) : Reason.undef());
        }
        if (this.x.isInstantiated()) {
            if (this.y.removeValue(this.x.getValue(), this, this.lcg() ? Reason.r(this.x.getValLit()) : Reason.undef()) || !this.y.contains(this.x.getValue())) {
                this.setPassive();
            }
        } else if (this.y.isInstantiated()) {
            if (this.x.removeValue(this.y.getValue(), this, this.lcg() ? Reason.r(this.y.getValLit()) : Reason.undef()) || !this.x.contains(this.y.getValue())) {
                this.setPassive();
            }
        } else if (this.x.getUB() < this.y.getLB() || this.y.getUB() < this.x.getLB()) {
            this.setPassive();
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.x.getUB() < this.y.getLB() || this.y.getUB() < this.x.getLB()) {
            return ESat.TRUE;
        }
        if (this.x.isInstantiated() && this.y.isInstantiated()) {
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return "prop(" + ((IntVar[])this.vars)[0].getName() + ".NEQ." + ((IntVar[])this.vars)[1].getName() + ")";
    }
}

