/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.tools;

import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.IntStream;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.expression.continuous.arithmetic.RealIntervalConstant;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.objects.RealInterval;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSetUtils;
import org.chocosolver.util.tools.MathUtils;
import org.chocosolver.util.tools.RealUtils;

public class VariableUtils {
    public static int[] boundsForAddition(IntVar ... vars) {
        long[] bounds = new long[2];
        IntStream.range(0, vars.length).forEach(i -> {
            bounds[0] = bounds[0] + (long)vars[i].getLB();
            bounds[1] = bounds[1] + (long)vars[i].getUB();
        });
        return new int[]{MathUtils.safeCast(bounds[0]), MathUtils.safeCast(bounds[1])};
    }

    public static int[] boundsForScalar(IntVar[] vars, int[] coeffs) {
        long[] bounds = new long[2];
        for (int i = 0; i < vars.length; ++i) {
            int c = coeffs[i];
            if (c >= 0) {
                bounds[0] = bounds[0] + (long)vars[i].getLB() * (long)coeffs[i];
                bounds[1] = bounds[1] + (long)vars[i].getUB() * (long)coeffs[i];
                continue;
            }
            bounds[0] = bounds[0] + (long)vars[i].getUB() * (long)coeffs[i];
            bounds[1] = bounds[1] + (long)vars[i].getLB() * (long)coeffs[i];
        }
        return new int[]{MathUtils.safeCast(bounds[0]), MathUtils.safeCast(bounds[1])};
    }

    public static double[] boundsForAddition(RealVar ... vars) {
        double[] bounds = new double[2];
        for (int i = 0; i < vars.length; ++i) {
            bounds[0] = bounds[0] + vars[i].getLB();
            bounds[1] = bounds[1] + vars[i].getUB();
        }
        return bounds;
    }

    private static int[] bound(long ... values) {
        return new int[]{MathUtils.safeCast(Arrays.stream(values).min().getAsLong()), MathUtils.safeCast(Arrays.stream(values).max().getAsLong())};
    }

    private static double[] bound(double ... values) {
        return new double[]{Arrays.stream(values).min().getAsDouble(), Arrays.stream(values).max().getAsDouble()};
    }

    public static int[] boundsForSubstraction(IntVar x, IntVar y) {
        return new int[]{MathUtils.safeCast(x.getLB() - y.getUB()), MathUtils.safeCast(x.getUB() - y.getLB())};
    }

    public static double[] boundsForSubstraction(RealVar x, RealVar y) {
        RealInterval res = RealUtils.sub(x, y);
        return new double[]{res.getLB(), res.getUB()};
    }

    public static int[] boundsForMultiplication(IntVar x, IntVar y) {
        return VariableUtils.bound((long)x.getLB() * (long)y.getLB(), (long)x.getLB() * (long)y.getUB(), (long)x.getUB() * (long)y.getLB(), (long)x.getUB() * (long)y.getUB());
    }

    public static double[] boundsForMultiplication(RealVar x, RealVar y) {
        RealInterval res = RealUtils.mul(x, y);
        return new double[]{res.getLB(), res.getUB()};
    }

    public static int[] boundsForDivision(IntVar x, IntVar y) {
        int lx = x.getLB();
        int ux = x.getUB();
        int ly = y.getLB();
        int uy = y.getUB();
        if (ly == 0) {
            ++ly;
        }
        if (uy == 0) {
            --uy;
        }
        if (ly < 0 && 0 < uy) {
            ly = -1;
            uy = 1;
        }
        return VariableUtils.bound(new long[]{lx / ly, lx / uy, ux / ly, ux / uy});
    }

    public static double[] boundsForDivision(RealVar x, RealVar y) {
        RealInterval res = RealUtils.odiv(x, y);
        return new double[]{res.getLB(), res.getUB()};
    }

    public static int[] boundsForModulo(IntVar x, IntVar y) {
        long[] vals = new long[4];
        if (y.isInstantiatedTo(0)) {
            vals[0] = Integer.MIN_VALUE;
            vals[1] = Integer.MAX_VALUE;
            vals[2] = 0L;
            vals[3] = 0L;
        } else {
            int yl = y.getLB();
            int yu = y.getUB();
            vals[0] = 0L;
            vals[1] = 0L;
            vals[2] = 0L;
            if (yl >= 0) {
                vals[3] = yu - 1;
            } else if (yu <= 0) {
                vals[3] = yl + 1;
            } else {
                vals[0] = Math.abs(yl) - 1;
                vals[1] = Math.abs(yu) - 1;
                vals[2] = -vals[0];
                vals[3] = -vals[1];
            }
        }
        return VariableUtils.bound(vals);
    }

    public static int[] boundsForPow(IntVar x, IntVar y) {
        return VariableUtils.bound(new long[]{0L, 1L, MathUtils.pow(x.getLB(), y.getUB()), MathUtils.pow(x.getUB(), y.getUB()), MathUtils.pow(x.getLB() + 1, y.getUB()), MathUtils.pow(x.getUB() - 1, y.getUB()), MathUtils.pow(x.getLB(), Math.max(0, y.getUB() - 1)), MathUtils.pow(x.getUB(), Math.max(0, y.getUB() - 1)), MathUtils.pow(x.getLB() + 1, Math.max(0, y.getUB() - 1)), MathUtils.pow(x.getUB() - 1, Math.max(0, y.getUB() - 1))});
    }

    public static double[] boundsForPow(RealVar x, RealVar y) {
        return VariableUtils.bound(0.0, Math.pow(x.getLB(), y.getLB()), Math.pow(x.getLB(), y.getUB()), Math.pow(x.getUB(), y.getLB()), Math.pow(x.getUB(), y.getUB()));
    }

    public static double[] boundsForPow(RealVar x, double y) {
        if (y >= 0.0) {
            return VariableUtils.bound(0.0, Math.pow(x.getLB(), y), Math.pow(x.getUB(), y));
        }
        double[] bounds = VariableUtils.bound(0.0, Math.pow(x.getLB(), Math.abs(y)), Math.pow(x.getUB(), Math.abs(y)));
        RealInterval boundsDiv = RealUtils.odiv(new RealIntervalConstant(1.0, 1.0), new RealIntervalConstant(bounds[0], bounds[1]));
        return new double[]{boundsDiv.getLB(), boundsDiv.getUB()};
    }

    public static double[] boundsForAtan2(RealVar x, RealVar y) {
        return VariableUtils.bound(Math.atan2(x.getLB(), y.getLB()), Math.atan2(x.getLB(), y.getUB()), Math.atan2(x.getUB(), y.getLB()), Math.atan2(x.getUB(), y.getUB()));
    }

    public static int[] boundsForMinimum(IntVar ... vars) {
        int[] bounds = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE};
        for (int i = 0; i < vars.length; ++i) {
            bounds[0] = Math.min(bounds[0], vars[i].getLB());
            bounds[1] = Math.min(bounds[1], vars[i].getUB());
        }
        return bounds;
    }

    public static double[] boundsForMinimum(RealVar ... vars) {
        double[] bounds = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY};
        for (int i = 0; i < vars.length; ++i) {
            bounds[0] = Math.min(bounds[0], vars[i].getLB());
            bounds[1] = Math.min(bounds[1], vars[i].getUB());
        }
        return bounds;
    }

    public static int[] boundsForMaximum(IntVar ... vars) {
        int[] bounds = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE};
        for (int i = 0; i < vars.length; ++i) {
            bounds[0] = Math.max(bounds[0], vars[i].getLB());
            bounds[1] = Math.max(bounds[1], vars[i].getUB());
        }
        return bounds;
    }

    public static double[] boundsForMaximum(RealVar ... vars) {
        double[] bounds = new double[]{Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
        for (int i = 0; i < vars.length; ++i) {
            bounds[0] = Math.max(bounds[0], vars[i].getLB());
            bounds[1] = Math.max(bounds[1], vars[i].getUB());
        }
        return bounds;
    }

    public static long domainCardinality(IntVar ... vars) {
        long card = 1L;
        for (int i = 0; i < vars.length && card < Integer.MAX_VALUE; card *= (long)vars[i].getDomainSize(), ++i) {
        }
        return Math.min(Integer.MAX_VALUE, card);
    }

    public static double searchSpaceSize(IntVar[] vars) {
        double size = 1.0;
        for (int i = 0; i < vars.length && size > 0.0; size *= (double)vars[i].getDomainSize(), ++i) {
        }
        if (size <= 0.0 || size == Double.POSITIVE_INFINITY) {
            size = Double.MAX_VALUE;
        }
        return size;
    }

    public static double searchSpaceSize(Iterator<IntVar> vars) {
        double size;
        IntVar var;
        for (size = 1.0; vars.hasNext() && size >= 0.0 && size < Double.POSITIVE_INFINITY; size *= (double)var.getDomainSize()) {
            var = vars.next();
        }
        if (size <= 0.0 || size == Double.POSITIVE_INFINITY) {
            size = Double.MAX_VALUE;
        }
        return size;
    }

    public static boolean intersect(IntVar x, IntVar y) {
        int s1 = x.getDomainSize();
        int s2 = y.getDomainSize();
        int i = 0;
        int j = 0;
        int lbi = x.getLB();
        int ubi = x.nextValueOut(lbi) - 1;
        int lbj = y.getLB();
        int ubj = y.nextValueOut(lbj) - 1;
        while (i < s1 && j < s2) {
            if (lbi <= lbj && lbj <= ubi || lbj <= lbi && lbi <= ubj) {
                return true;
            }
            if (ubi <= ubj && ++i < s1) {
                lbi = x.nextValue(ubi);
                ubi = x.nextValueOut(lbi) - 1;
                continue;
            }
            if (ubj > ubi || ++j >= s2) continue;
            lbj = x.nextValue(ubj);
            ubj = y.nextValueOut(lbj) - 1;
        }
        return false;
    }

    public static IntIterableRangeSet union(IntVar ... vars) {
        IntIterableRangeSet set = new IntIterableRangeSet();
        if (vars.length == 0) {
            return set;
        }
        for (IntVar var : vars) {
            set.addAll(var);
        }
        return set;
    }

    public static IntIterableRangeSet intersection(IntVar ... vars) {
        IntIterableRangeSet set = new IntIterableRangeSet();
        if (vars.length == 0) {
            return set;
        }
        set.addAll(vars[0]);
        IntIterableRangeSet set0 = new IntIterableRangeSet();
        for (int i = 1; i < vars.length && set.size() > 0; ++i) {
            set0.clear();
            set0.addAll(vars[i]);
            set = IntIterableSetUtils.intersection(set0, set);
        }
        return set;
    }

    public static IntVar[] toIntVar(Model model, int ... values) {
        return (IntVar[])Arrays.stream(values).mapToObj(model::intVar).toArray(IntVar[]::new);
    }

    public static boolean isConstant(Variable var) {
        return (var.getTypeAndKind() & 2) != 0;
    }

    public static boolean isView(Variable var) {
        return (var.getTypeAndKind() & 4) != 0;
    }

    public static boolean isInt(Variable var) {
        return (var.getTypeAndKind() & 8) != 0;
    }

    public static boolean isBool(Variable var) {
        return (var.getTypeAndKind() & 0x3F8) == 24;
    }

    public static boolean isSet(Variable var) {
        return (var.getTypeAndKind() & 0x20) != 0;
    }

    public static boolean isReal(Variable var) {
        return (var.getTypeAndKind() & 0x40) != 0;
    }
}

